/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.distcache;

import com.caucho.env.service.ResinSystem;
import com.caucho.env.thread.AbstractTaskWorker;
import com.caucho.server.distcache.DataStore;
import com.caucho.util.CurrentTime;
import java.util.concurrent.LinkedBlockingQueue;

public class DataRemoveActor
extends AbstractTaskWorker {
    private final DataStore _dataStore;
    private final String _serverId;
    private final int _queueMax = 8192;
    private final LinkedBlockingQueue<RemoveItem> _queue = new LinkedBlockingQueue();

    DataRemoveActor(DataStore dataStore) {
        this._serverId = ResinSystem.getCurrentId();
        this._dataStore = dataStore;
    }

    public void offer(long dataId) {
        RemoveItem item = new RemoveItem(dataId);
        this._queue.offer(item);
        this.wake();
    }

    public long runTask() {
        RemoveItem item;
        DataStore dataStore = this._dataStore;
        long now = CurrentTime.getCurrentTime();
        while ((item = this._queue.peek()) != null) {
            if (now < item.getExpireTime() && this._queue.size() < 8192) {
                return item.getExpireTime() - now;
            }
            item = this._queue.poll();
            if (dataStore.isClosed()) {
                return 0L;
            }
            if (item == null) continue;
            this._dataStore.remove(item.getDataId());
        }
        return 0L;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._serverId + "]";
    }

    static final class RemoveItem {
        private final long _dataId;
        private final long _expireTime;

        RemoveItem(long dataId) {
            long delta = 120000L;
            if (CurrentTime.isTest()) {
                delta = 500L;
            }
            this._dataId = dataId;
            this._expireTime = CurrentTime.getCurrentTime() + delta;
        }

        public long getDataId() {
            return this._dataId;
        }

        public long getExpireTime() {
            return this._expireTime;
        }
    }
}

