/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.distcache;

import com.caucho.cloud.topology.TriadOwner;
import com.caucho.distcache.CacheSerializer;
import com.caucho.env.distcache.CacheDataBacking;
import com.caucho.env.service.ResinSystem;
import com.caucho.env.thread.ThreadPool;
import com.caucho.inject.Module;
import com.caucho.server.distcache.AbstractCacheEngine;
import com.caucho.server.distcache.AdminCacheStore;
import com.caucho.server.distcache.CacheConfig;
import com.caucho.server.distcache.CacheDataBackingImpl;
import com.caucho.server.distcache.CacheEngine;
import com.caucho.server.distcache.CacheEntryFactory;
import com.caucho.server.distcache.CacheEntryManager;
import com.caucho.server.distcache.CacheHandle;
import com.caucho.server.distcache.CacheImpl;
import com.caucho.server.distcache.CacheKeyManager;
import com.caucho.server.distcache.CacheMnodeListener;
import com.caucho.server.distcache.CacheRegionManager;
import com.caucho.server.distcache.DataStore;
import com.caucho.server.distcache.DistCacheEntry;
import com.caucho.server.distcache.LocalDataManager;
import com.caucho.server.distcache.LocalMnodeManager;
import com.caucho.server.distcache.LocalStoreManager;
import com.caucho.server.distcache.MnodeEntry;
import com.caucho.server.distcache.MnodeStore;
import com.caucho.server.distcache.MnodeUpdate;
import com.caucho.server.distcache.MnodeValue;
import com.caucho.util.HashKey;
import com.caucho.vfs.StreamSource;
import java.io.IOException;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Module
public final class CacheStoreManager
implements CacheEntryFactory {
    private final ResinSystem _resinSystem;
    private final CacheEntryManager _cacheEntryManager;
    private final CacheKeyManager _keyManager;
    private final CacheRegionManager _regionManager = new CacheRegionManager();
    private CacheDataBackingImpl _dataBacking;
    private final LocalMnodeManager _localMnodeManager;
    private final LocalDataManager _localDataManager;
    private final LocalStoreManager _localStoreManager;
    private final ConcurrentHashMap<HashKey, CacheMnodeListener> _cacheListenMap = new ConcurrentHashMap();
    private final CacheConfig _defaultCacheConfig = new CacheConfig();
    private boolean _isCacheListen;
    private boolean _isClosed;
    private CacheEngine _cacheEngine = new AbstractCacheEngine();
    private AdminCacheStore _admin = new AdminCacheStore(this);

    public CacheStoreManager(ResinSystem resinSystem) {
        this._resinSystem = resinSystem;
        this._cacheEntryManager = new CacheEntryManager(this);
        this._keyManager = new CacheKeyManager(this._cacheEntryManager);
        this._localMnodeManager = new LocalMnodeManager(this);
        this._localDataManager = new LocalDataManager(this);
        this._localStoreManager = new LocalStoreManager(this);
    }

    public final CacheEntryManager getCacheEntryManager() {
        return this._cacheEntryManager;
    }

    public void setCacheEngine(CacheEngine cacheEngine) {
        if (cacheEngine == null) {
            throw new NullPointerException();
        }
        this._cacheEngine = cacheEngine;
    }

    public CacheEngine getCacheEngine() {
        return this._cacheEngine;
    }

    public CacheDataBacking getDataBacking() {
        return this._dataBacking;
    }

    public LocalMnodeManager getLocalMnodeManager() {
        return this._localMnodeManager;
    }

    public LocalDataManager getLocalDataManager() {
        return this._localDataManager;
    }

    public LocalStoreManager getLocalStoreManager() {
        return this._localStoreManager;
    }

    public CacheKeyManager getKeyManager() {
        return this._keyManager;
    }

    public final CacheConfig getDefaultCacheConfig() {
        return this._defaultCacheConfig;
    }

    public void addCacheListener(HashKey cacheKey, CacheMnodeListener listener) {
        this._cacheListenMap.put(cacheKey, listener);
        this._isCacheListen = true;
    }

    public final DistCacheEntry getCacheEntry(Object key, CacheConfig config) {
        HashKey hashKey = this._keyManager.createHashKey(key, config);
        DistCacheEntry entry = this._cacheEntryManager.createCacheEntry(hashKey, config.getCache());
        if (key != null) {
            entry.setKey(key);
        }
        return entry;
    }

    public final DistCacheEntry getCacheEntry(HashKey key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return this._cacheEntryManager.getCacheEntry(key);
    }

    public final DistCacheEntry getCacheEntry(HashKey hashKey, HashKey cacheKey, Object oKey) {
        DistCacheEntry entry = this.getCacheEntry(hashKey, cacheKey);
        if (oKey != null) {
            entry.setKey(oKey);
        }
        return entry;
    }

    public final DistCacheEntry getCacheEntry(HashKey key, HashKey cacheKey) {
        if (key == null) {
            throw new NullPointerException();
        }
        DistCacheEntry entry = this._cacheEntryManager.getCacheEntry(key);
        if (entry != null) {
            return entry;
        }
        CacheConfig defaultConfig = this.getDefaultCacheConfig();
        CacheHandle cache = this._regionManager.createCache(cacheKey, defaultConfig);
        return this._cacheEntryManager.createCacheEntry(key, cache);
    }

    public final DistCacheEntry getCacheEntry(HashKey key, CacheHandle cache) {
        if (key == null) {
            throw new NullPointerException();
        }
        return this._cacheEntryManager.createCacheEntry(key, cache);
    }

    @Override
    public DistCacheEntry createCacheEntry(HashKey hashKey, CacheHandle cache) {
        TriadOwner owner = TriadOwner.getHashOwner(hashKey.getHash());
        return new DistCacheEntry(this, hashKey, cache, owner);
    }

    public final CacheHandle getCache(String guid, CacheSerializer keySerializer) {
        HashKey cacheHash = this.getKeyManager().createSelfHashKey(guid, keySerializer);
        return this.getCache(cacheHash);
    }

    public final CacheHandle getCache(HashKey cacheHash) {
        return this._regionManager.createCache(cacheHash, this.getDefaultCacheConfig());
    }

    public final DistCacheEntry loadLocalEntry(HashKey key, CacheConfig config) {
        if (key == null) {
            throw new NullPointerException();
        }
        DistCacheEntry entry = this.getCacheEntry((Object)key, config);
        entry.loadLocalEntry();
        return entry;
    }

    public final DistCacheEntry loadLocalEntry(HashKey key, HashKey cacheKey) {
        if (key == null) {
            throw new NullPointerException();
        }
        DistCacheEntry entry = this.getCacheEntry(key, cacheKey);
        entry.loadLocalEntry();
        return entry;
    }

    public final void saveLocalUpdateTime(HashKey key, long version, long accessTimeout, long lastAccessTime) {
        DistCacheEntry entry = this._cacheEntryManager.getCacheEntry(key);
        if (entry == null) {
            return;
        }
        MnodeEntry oldEntryValue = entry.getMnodeEntry();
        if (oldEntryValue == null || version != oldEntryValue.getVersion()) {
            return;
        }
        MnodeEntry mnodeValue = new MnodeEntry(oldEntryValue, oldEntryValue.getValueDataId(), accessTimeout, lastAccessTime);
        entry.saveLocalUpdateTime(mnodeValue);
    }

    public MnodeUpdate localPut(byte[] keyHash, MnodeUpdate update, StreamSource source) {
        try {
            HashKey key = new HashKey(keyHash);
            CacheConfig config = null;
            DistCacheEntry entry = this.loadLocalEntry(key, config);
            return entry.localUpdate(update, source.getInputStream());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    void notifyPutListeners(HashKey key, HashKey cacheKey, MnodeUpdate update, MnodeValue mnodeValue) {
        CacheMnodeListener listener;
        if (mnodeValue != null && mnodeValue.getValueHash() == update.getValueHash() && this._isCacheListen && (listener = this._cacheListenMap.get(cacheKey)) != null) {
            listener.onPut(key, cacheKey, mnodeValue);
        }
    }

    public final void clearLeases() {
        this._cacheEntryManager.clearLeases();
    }

    public void clearEphemeralEntries() {
    }

    public Iterator<HashKey> getEntries(HashKey cacheKey) {
        return this._dataBacking.getEntries(cacheKey);
    }

    public Iterator<DistCacheEntry> getEntries() {
        return this._cacheEntryManager.getEntries();
    }

    public void start() {
        if (this._dataBacking == null) {
            this._dataBacking = new CacheDataBackingImpl(this);
        }
        if (this.getDataBacking() == null) {
            throw new NullPointerException();
        }
        this._dataBacking.start();
        this._cacheEngine.start();
    }

    public void stop() {
        this._admin.unregister();
    }

    public void closeCache(String guid, HashKey cacheKey) {
        this._keyManager.closeCache(guid);
        this._cacheListenMap.remove(cacheKey);
    }

    public void initCache(CacheImpl<?, ?> cache) {
        CacheConfig config = cache.getConfig();
        CacheHandle cacheHandle = config.getCache();
        cacheHandle.setConfig(config);
    }

    public void destroyCache(CacheImpl<?, ?> cache) {
    }

    public void addCacheConfig(byte[] cacheHash, CacheConfig config) {
        HashKey cacheKey = HashKey.create(cacheHash);
        CacheHandle cacheHandle = this._regionManager.createCache(cacheKey, config);
    }

    public CacheConfig getCacheConfig(byte[] cacheHash) {
        if (cacheHash == null) {
            return null;
        }
        HashKey cacheKey = HashKey.create(cacheHash);
        CacheConfig defaultConfig = this.getDefaultCacheConfig();
        return this._regionManager.createCache(cacheKey, defaultConfig).getConfig();
    }

    void schedule(Runnable task) {
        ThreadPool.getCurrent().schedule(task);
    }

    public void close() {
        this._isClosed = true;
        if (this.getDataBacking() != null) {
            this.getDataBacking().close();
        }
    }

    public boolean isClosed() {
        return this._isClosed;
    }

    public long calculateValueHash(Object value, CacheConfig config) {
        return this._localDataManager.calculateValueHash(value, config);
    }

    public MnodeStore getMnodeStore() {
        return this._dataBacking.getMnodeStore();
    }

    public DataStore getDataStore() {
        return this._dataBacking.getDataStore();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._resinSystem.getId() + "]";
    }
}

