/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.distcache;

import com.caucho.server.distcache.CacheLoaderCallback;
import com.caucho.server.distcache.CacheLoaderExt;
import com.caucho.server.distcache.DistCacheEntry;
import java.util.Map;
import javax.cache.Cache;
import javax.cache.CacheLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheLoaderAdapter<K, V>
implements CacheLoaderExt<K, V> {
    private final CacheLoader<K, V> _loader;

    public CacheLoaderAdapter(CacheLoader<K, V> loader) {
        this._loader = loader;
    }

    @Override
    public void load(DistCacheEntry entry, CacheLoaderCallback cb) {
        Cache.Entry<K, V> loadedEntry = this._loader.load(entry.getKey());
        if (loadedEntry != null) {
            cb.onLoad(entry, loadedEntry.getValue());
        } else {
            cb.onLoad(entry, null);
        }
    }

    @Override
    public Cache.Entry<K, V> load(Object key) {
        return this._loader.load(key);
    }

    @Override
    public Map<K, V> loadAll(Iterable<? extends K> keys) {
        return this._loader.loadAll(keys);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._loader + "]";
    }
}

