/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.distcache;

import com.caucho.config.ConfigException;
import com.caucho.db.jdbc.DataSourceImpl;
import com.caucho.env.distcache.CacheDataBacking;
import com.caucho.env.health.HealthSystemFacade;
import com.caucho.env.service.ResinSystem;
import com.caucho.env.service.RootDirectorySystem;
import com.caucho.server.distcache.CacheData;
import com.caucho.server.distcache.CacheStoreManager;
import com.caucho.server.distcache.DataRemoveActor;
import com.caucho.server.distcache.DataStore;
import com.caucho.server.distcache.DistCacheEntry;
import com.caucho.server.distcache.MnodeEntry;
import com.caucho.server.distcache.MnodeStore;
import com.caucho.server.distcache.MnodeUpdate;
import com.caucho.util.Alarm;
import com.caucho.util.AlarmListener;
import com.caucho.util.CurrentTime;
import com.caucho.util.HashKey;
import com.caucho.vfs.Path;
import com.caucho.vfs.StreamSource;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheDataBackingImpl
implements CacheDataBacking {
    private static final Logger log = Logger.getLogger(CacheDataBackingImpl.class.getName());
    private CacheStoreManager _manager;
    private DataStore _dataStore;
    private MnodeStore _mnodeStore;
    private DataRemoveActor _removeActor;
    private final AtomicLong _createCount = new AtomicLong();
    private long _createReaperCount;
    private Alarm _reaperAlarm = new Alarm(new ReaperListener());
    private DataSourceImpl _dataSource;
    private long _reaperTimeout = 300000L;
    private long _reaperCycleMaxActiveDurationMs = 1000L;
    private double _reaperCycleIdleToActiveUtilizationRatio = 2.0;

    public CacheDataBackingImpl(CacheStoreManager storeManager) {
        this._manager = storeManager;
    }

    public void setDataStore(DataStore dataStore) {
        this._dataStore = dataStore;
    }

    public void setMnodeStore(MnodeStore mnodeStore) {
        this._mnodeStore = mnodeStore;
    }

    @Override
    public DataStore getDataStore() {
        return this._dataStore;
    }

    @Override
    public MnodeStore getMnodeStore() {
        return this._mnodeStore;
    }

    public long getReaperTimeout() {
        return this._reaperTimeout;
    }

    public void setReaperTimeout(long ms) {
        this._reaperTimeout = ms;
    }

    public long getReaperCycleMaxActiveTime() {
        return this._reaperCycleMaxActiveDurationMs;
    }

    public void setReaperCycleMaxActiveTime(long ms) {
        this._reaperCycleMaxActiveDurationMs = ms;
    }

    public double getReaperCycleIdleToActiveUtilizationRatio() {
        return this._reaperCycleIdleToActiveUtilizationRatio;
    }

    public void setReaperCycleIdleToActiveUtilizationRatio(double ratio) {
        this._reaperCycleIdleToActiveUtilizationRatio = ratio;
    }

    @Override
    public MnodeEntry loadLocalEntryValue(HashKey key) {
        MnodeStore mnodeStore = this._mnodeStore;
        if (mnodeStore != null) {
            return mnodeStore.load(key);
        }
        return null;
    }

    @Override
    public MnodeEntry insertLocalValue(HashKey key, HashKey cacheKey, MnodeEntry mnodeUpdate, MnodeEntry oldEntryValue) {
        long oldDataId;
        MnodeEntry entry = null;
        boolean isSave = false;
        if (oldEntryValue == null || oldEntryValue.isImplicitNull() || oldEntryValue == MnodeEntry.NULL) {
            if (this._mnodeStore.insert(key, cacheKey, mnodeUpdate, mnodeUpdate.getValueDataId(), mnodeUpdate.getLastAccessedTime(), mnodeUpdate.getLastModifiedTime())) {
                entry = mnodeUpdate;
            } else {
                log.fine(this + " db insert failed due to timing conflict" + "(key=" + key + ")");
                entry = oldEntryValue;
            }
        } else if (this._mnodeStore.updateSave(key.getHash(), cacheKey.getHash(), mnodeUpdate, mnodeUpdate.getValueDataId(), mnodeUpdate.getLastAccessedTime(), mnodeUpdate.getLastModifiedTime())) {
            isSave = true;
            entry = mnodeUpdate;
        } else if (this._mnodeStore.insert(key, cacheKey, mnodeUpdate, mnodeUpdate.getValueDataId(), mnodeUpdate.getLastAccessedTime(), mnodeUpdate.getLastModifiedTime())) {
            isSave = true;
            entry = mnodeUpdate;
        } else {
            log.fine(this + " db update failed due to timing conflict" + "(key=" + key + ")");
            entry = oldEntryValue;
        }
        if (isSave && oldEntryValue != null && (oldDataId = oldEntryValue.getValueDataId()) > 0L && mnodeUpdate.getValueDataId() != oldDataId) {
            this.removeData(oldDataId);
        }
        return entry;
    }

    @Override
    public boolean putLocalValue(MnodeEntry mnodeEntry, HashKey key, HashKey cacheKey, MnodeEntry oldEntryEntry, MnodeUpdate mnodeUpdate) {
        long oldDataId;
        boolean isSave = false;
        if (oldEntryEntry == null || oldEntryEntry.isImplicitNull() || oldEntryEntry == MnodeEntry.NULL) {
            long lastAccessTime = mnodeUpdate.getLastAccessTime();
            long lastModifiedTime = mnodeUpdate.getLastAccessTime();
            if (this._mnodeStore.insert(key, cacheKey, mnodeUpdate, mnodeEntry.getValueDataId(), lastAccessTime, lastModifiedTime)) {
                isSave = true;
                this.addCreateCount();
            } else {
                log.fine(this + " db insert failed due to timing conflict" + "(key=" + key + ", version=" + mnodeUpdate.getVersion() + ")");
            }
        } else if (this._mnodeStore.updateSave(key.getHash(), cacheKey.getHash(), mnodeUpdate, mnodeEntry.getValueDataId(), mnodeEntry.getLastAccessedTime(), mnodeEntry.getLastModifiedTime())) {
            isSave = true;
        } else if (this._mnodeStore.insert(key, cacheKey, mnodeUpdate, mnodeEntry.getValueDataId(), mnodeEntry.getLastAccessedTime(), mnodeEntry.getLastModifiedTime())) {
            isSave = true;
            this.addCreateCount();
        } else {
            log.fine(this + " db update failed due to timing conflict" + "(key=" + key + ", version=" + mnodeUpdate.getVersion() + ")");
        }
        if (isSave && oldEntryEntry != null && (oldDataId = oldEntryEntry.getValueDataId()) > 0L && mnodeEntry.getValueDataId() != oldDataId) {
            this.removeData(oldDataId);
        }
        return isSave;
    }

    private void addCreateCount() {
        this._createCount.incrementAndGet();
        if (this._createReaperCount < this._createCount.get()) {
            this.updateCreateReaperCount();
            this._reaperAlarm.queue(0L);
        }
    }

    @Override
    public MnodeEntry saveLocalUpdateTime(HashKey keyHash, MnodeEntry mnodeValue, MnodeEntry oldMnodeValue) {
        if (this._mnodeStore.updateAccessTime(keyHash, mnodeValue.getVersion(), mnodeValue.getAccessedExpireTimeout(), mnodeValue.getLastAccessedTime())) {
            return mnodeValue;
        }
        log.fine(this + " db updateTime failed due to timing conflict" + "(key=" + keyHash + ", version=" + mnodeValue.getVersion() + ")");
        return oldMnodeValue;
    }

    @Override
    public boolean loadData(long valueDataId, WriteStream os) throws IOException {
        return this._dataStore.load(valueDataId, os);
    }

    @Override
    public Blob loadBlob(long valueDataId) {
        return this._dataStore.loadBlob(valueDataId);
    }

    @Override
    public long saveData(StreamSource source, int length) {
        try {
            DataStore dataStore = this._dataStore;
            if (dataStore != null) {
                return this._dataStore.save(source, length);
            }
            return -1L;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long saveData(InputStream is, int length) throws IOException {
        return this._dataStore.save(is, length);
    }

    @Override
    public boolean removeData(long dataId) {
        this._removeActor.offer(dataId);
        return true;
    }

    @Override
    public boolean isDataAvailable(long valueIndex) {
        return valueIndex > 0L;
    }

    @Override
    public long getStartupLastUpdateTime() {
        return this._mnodeStore.getStartupLastUpdateTime();
    }

    @Override
    public long getStartupLastUpdateTime(HashKey cacheKey) {
        return this._mnodeStore.getStartupLastUpdateTime(cacheKey);
    }

    @Override
    public ArrayList<CacheData> getUpdates(long accessTime, int offset) {
        return this._mnodeStore.getUpdates(accessTime, offset);
    }

    @Override
    public ArrayList<CacheData> getUpdates(HashKey cacheKey, long accessTime, int offset) {
        return this._mnodeStore.getUpdates(cacheKey, accessTime, offset);
    }

    public Iterator<HashKey> getEntries(HashKey cacheKey) {
        return this._mnodeStore.getKeys(cacheKey);
    }

    @Override
    public void start() {
        try {
            Path dataDirectory = RootDirectorySystem.getCurrentDataDirectory();
            String serverId = ResinSystem.getCurrentId();
            if (serverId.isEmpty()) {
                serverId = "default";
            }
            this._dataSource = this.createDataSource(dataDirectory, serverId);
            Path mnodeDb = dataDirectory.lookup(serverId).lookup("mnode.db");
            Path dataDb = dataDirectory.lookup(serverId).lookup("data.db");
            String exitMessage = HealthSystemFacade.getExitMessage();
            if (exitMessage.indexOf(mnodeDb.getFullPath()) >= 0 || exitMessage.indexOf(dataDb.getFullPath()) >= 0) {
                log.warning("removing cache database " + mnodeDb.getFullPath() + " because of corruption");
                try {
                    mnodeDb.remove();
                }
                catch (Exception e) {
                    log.log(Level.WARNING, e.toString(), e);
                }
                try {
                    dataDb.remove();
                }
                catch (Exception e) {
                    log.log(Level.WARNING, e.toString(), e);
                }
            }
            String tableName = "mnode";
            this._mnodeStore = new MnodeStore(this._dataSource, tableName, serverId);
            this._mnodeStore.init();
            this._dataStore = new DataStore(serverId, this._mnodeStore);
            this._dataStore.init();
            this._removeActor = new DataRemoveActor(this._dataStore);
            this.updateCreateReaperCount();
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
        this._reaperAlarm.queue(0L);
    }

    private DataSourceImpl createDataSource(Path dataDirectory, String serverId) {
        Path path = dataDirectory.lookup("distcache");
        if (path == null) {
            throw new NullPointerException();
        }
        try {
            path.mkdirs();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            DataSourceImpl dataSource = new DataSourceImpl();
            dataSource.setPath(path);
            dataSource.setRemoveOnError(true);
            dataSource.init();
            return dataSource;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private boolean removeData(byte[] key, byte[] cacheHash, long dataId) {
        Object config = null;
        DistCacheEntry distEntry = this._manager.getCacheEntry(HashKey.create(key), HashKey.create(cacheHash));
        distEntry.clear();
        if (!this._mnodeStore.remove(key)) {
            return false;
        }
        if (dataId > 0L) {
            this.removeData(dataId);
        }
        return true;
    }

    private void updateCreateReaperCount() {
        long entryCount = this._mnodeStore.getCount();
        long createCount = this._createCount.get();
        int delta = Math.max(1024, (int)(entryCount / 8L));
        this._createReaperCount = createCount + (long)delta;
    }

    @Override
    public void close() {
        this._reaperAlarm.dequeue();
        MnodeStore mnodeStore = this._mnodeStore;
        this._mnodeStore = null;
        DataStore dataStore = this._dataStore;
        this._dataStore = null;
        DataRemoveActor removeActor = this._removeActor;
        this._removeActor = null;
        DataSourceImpl dataSource = this._dataSource;
        this._dataSource = null;
        if (removeActor != null) {
            removeActor.close();
        }
        if (mnodeStore != null) {
            mnodeStore.close();
        }
        if (dataStore != null) {
            dataStore.destroy();
        }
        if (dataSource != null) {
            dataSource.close();
        }
    }

    static class Throttler {
        final long _startTime = CurrentTime.getCurrentTime();
        final long _maxActiveDurationMs;
        final double _idleToActiveUtilizationRatio;
        long _batchStartTime;
        long _totalSleepDurationMs;
        long _lastBatchDurationMs;

        public Throttler(long maxActiveDurationMs, double idleToActiveUtilizationRatio) {
            this._maxActiveDurationMs = maxActiveDurationMs;
            this._idleToActiveUtilizationRatio = idleToActiveUtilizationRatio;
            this._batchStartTime = this._startTime;
        }

        public long throttle() {
            long batchEndTime = CurrentTime.getCurrentTime();
            long batchDurationMs = batchEndTime - this._batchStartTime;
            if ((double)this._maxActiveDurationMs <= (double)batchDurationMs * 1.25) {
                this._lastBatchDurationMs = batchDurationMs;
                long sleepDurationMs = this.sleep(batchDurationMs, batchEndTime);
                this.resetBatch();
                return sleepDurationMs;
            }
            return -1L;
        }

        private void resetBatch() {
            this._batchStartTime = CurrentTime.getCurrentTime();
        }

        private long sleep(long batchDurationMs, long batchEndTime) {
            try {
                long salt = batchDurationMs * (batchEndTime % 10L + 1L) / 10L;
                long sleepDurationMs = (long)(this._idleToActiveUtilizationRatio * (double)batchDurationMs) + salt;
                if (sleepDurationMs < 0L) {
                    sleepDurationMs = batchDurationMs * 2L;
                }
                Thread.sleep(sleepDurationMs);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            long actualSleepDurationMs = CurrentTime.getCurrentTime() - batchEndTime;
            this._totalSleepDurationMs += actualSleepDurationMs;
            return actualSleepDurationMs;
        }
    }

    class ReaperListener
    implements AlarmListener {
        ReaperListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleAlarm(Alarm alarm) {
            CacheDataBackingImpl.this.updateCreateReaperCount();
            ReaperListener reaperListener = this;
            synchronized (reaperListener) {
                try {
                    this.removeExpiredData();
                }
                finally {
                    if (CacheDataBackingImpl.this._mnodeStore != null) {
                        alarm.queue(CacheDataBackingImpl.this._reaperTimeout);
                    }
                }
            }
        }

        private void removeExpiredData() {
            ArrayList<MnodeStore.Mnode> mnodeList;
            Throttler throttler = new Throttler(CacheDataBackingImpl.this._reaperCycleMaxActiveDurationMs, CacheDataBackingImpl.this._reaperCycleIdleToActiveUtilizationRatio);
            Level level = Level.FINER;
            if (log.isLoggable(level)) {
                log.log(level, this + " starting mnode cache reaper run" + ", current mnode count=" + CacheDataBackingImpl.this._mnodeStore.getCount() + ", reaperTimeout=" + CacheDataBackingImpl.this._reaperTimeout + "ms" + ", reaperCycleMaxActiveDuration=" + CacheDataBackingImpl.this._reaperCycleMaxActiveDurationMs + "ms" + ", reaperCycleIdleToActiveUtilizationRatio=" + CacheDataBackingImpl.this._reaperCycleIdleToActiveUtilizationRatio);
            }
            long oid = 0L;
            long mnodeCount = 0L;
            long removeCount = 0L;
            while ((mnodeList = CacheDataBackingImpl.this._mnodeStore.selectExpiredData(oid)).size() > 0) {
                mnodeCount += (long)mnodeList.size();
                for (MnodeStore.Mnode mnode : mnodeList) {
                    if (oid < mnode.getOid()) {
                        oid = mnode.getOid();
                    }
                    if (!(mnode instanceof MnodeStore.ExpiredMnode)) continue;
                    MnodeStore.ExpiredMnode expiredMnode = (MnodeStore.ExpiredMnode)mnode;
                    try {
                        if (CacheDataBackingImpl.this.removeData(expiredMnode.getKey(), expiredMnode.getCacheHash(), expiredMnode.getDataId())) {
                            ++removeCount;
                        }
                        this.throttle(throttler, mnodeCount, removeCount);
                    }
                    catch (Exception e) {
                        log.log(Level.FINER, e.toString(), e);
                    }
                }
                this.throttle(throttler, mnodeCount, removeCount);
            }
            long endTime = CurrentTime.getCurrentTime();
            if (log.isLoggable(level)) {
                log.log(level, this + " finished mnode cache reaper run" + ", removed " + removeCount + " expired entries in " + (endTime - throttler._startTime) + "ms" + ", current mnode count=" + CacheDataBackingImpl.this._mnodeStore.getCount() + ", total sleep duration=" + throttler._totalSleepDurationMs + "ms");
            }
        }

        private void throttle(Throttler throttler, long mnodeCount, long removeCount) {
            long sleepDurationMs = throttler.throttle();
            if (sleepDurationMs >= 0L && log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, this + " idled mnode cache reaper for " + sleepDurationMs + "ms" + ", mnode scanned count=" + mnodeCount + ", current remove count=" + removeCount + ", last batch duration=" + throttler._lastBatchDurationMs + " ms");
            }
        }
    }
}

