/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.dispatch;

import com.caucho.config.Config;
import com.caucho.config.ConfigException;
import com.caucho.config.Configurable;
import com.caucho.config.LineConfigException;
import com.caucho.config.annotation.DisableConfig;
import com.caucho.config.inject.BeanBuilder;
import com.caucho.config.inject.InjectManager;
import com.caucho.config.inject.ManagedBeanImpl;
import com.caucho.config.inject.OwnerCreationalContext;
import com.caucho.config.program.ContainerProgram;
import com.caucho.config.types.CronType;
import com.caucho.config.types.Icon;
import com.caucho.config.types.InitParam;
import com.caucho.jmx.Jmx;
import com.caucho.jsp.Page;
import com.caucho.jsp.QServlet;
import com.caucho.naming.Jndi;
import com.caucho.remote.server.ProtocolServletFactory;
import com.caucho.security.BasicPrincipal;
import com.caucho.server.dispatch.CometServletFilterChain;
import com.caucho.server.dispatch.MultipartConfigImpl;
import com.caucho.server.dispatch.PageFilterChain;
import com.caucho.server.dispatch.RunAt;
import com.caucho.server.dispatch.SecurityRoleRef;
import com.caucho.server.dispatch.ServletFilterChain;
import com.caucho.server.dispatch.ServletManager;
import com.caucho.server.dispatch.ServletMapper;
import com.caucho.server.dispatch.ServletMapping;
import com.caucho.server.dispatch.ServletProtocolConfig;
import com.caucho.server.dispatch.SingleThreadServletFilterChain;
import com.caucho.server.dispatch.WebServiceFilterChain;
import com.caucho.server.http.StubServletRequest;
import com.caucho.server.http.StubServletResponse;
import com.caucho.server.webapp.WebApp;
import com.caucho.servlet.comet.CometServlet;
import com.caucho.util.Alarm;
import com.caucho.util.AlarmListener;
import com.caucho.util.CompileException;
import com.caucho.util.CurrentTime;
import com.caucho.util.L10N;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.enterprise.inject.InjectionException;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.naming.NamingException;
import javax.servlet.FilterChain;
import javax.servlet.MultipartConfigElement;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.ServletSecurityElement;
import javax.servlet.SingleThreadModel;
import javax.servlet.UnavailableException;
import javax.servlet.annotation.MultipartConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletConfigImpl
implements ServletConfig,
ServletRegistration.Dynamic,
AlarmListener {
    static L10N L = new L10N(ServletConfigImpl.class);
    protected static final Logger log = Logger.getLogger(ServletConfigImpl.class.getName());
    private String _location;
    private String _jndiName;
    private String _var;
    private String _servletName;
    private String _servletNameDefault;
    private String _servletClassName;
    private Class<?> _servletClass;
    private Bean _bean;
    private String _jspFile;
    private String _displayName;
    private int _loadOnStartup = Integer.MIN_VALUE;
    private boolean _isAsyncSupported;
    private Servlet _singletonServlet;
    private boolean _allowEL = true;
    private HashMap<String, String> _initParams = new HashMap();
    private Set<String> _paramNames = new HashSet<String>();
    private HashMap<String, String> _roleMap;
    private ContainerProgram _init;
    private RunAt _runAt;
    private CronType _cron;
    private MultipartConfigElement _multipartConfigElement;
    private ServletProtocolConfig _protocolConfig;
    private ProtocolServletFactory _protocolFactory;
    private Alarm _alarm;
    private InjectionTarget _comp;
    private WebApp _webApp;
    private ServletContext _servletContext;
    private ServletManager _servletManager;
    private ServletMapper _servletMapper;
    private ServletException _initException;
    private long _nextInitTime;
    private Object _servlet;
    private FilterChain _servletChain;
    private Principal _runAs;
    private FRAGMENT_MODE _fragmentMode = FRAGMENT_MODE.IN_WEBXML;
    private AnnotatedType<?> _annType;

    public ServletConfigImpl() {
    }

    public ServletConfigImpl(FRAGMENT_MODE fragmentMode) {
        this._fragmentMode = fragmentMode;
    }

    public void setConfigUriLocation(String location, int line) {
        this._location = location + ":" + line + ": ";
    }

    public void setId(String id) {
    }

    public void setServletName(String name) {
        this._servletName = name;
    }

    @Override
    public String getServletName() {
        return this._servletName;
    }

    @Override
    public String getName() {
        return this._servletName;
    }

    public ServletConfigImpl createRegexpConfig(String servletName) throws ServletException {
        ServletConfigImpl config = new ServletConfigImpl();
        config.setServletName(servletName);
        config.setServletClass(servletName);
        config.init();
        return config;
    }

    @Override
    public String getClassName() {
        return this._servletClassName;
    }

    @Override
    public boolean setInitParameter(String name, String value) {
        if (!this._webApp.isInitializing()) {
            throw new IllegalStateException();
        }
        if (this._initParams.containsKey(name)) {
            return false;
        }
        this._initParams.put(name, value);
        return true;
    }

    @Override
    public Set<String> setServletSecurity(ServletSecurityElement securityElement) {
        this._servletManager.addSecurityElement(this.getServletClass(), securityElement);
        return new HashSet<String>();
    }

    public ServletSecurityElement getSecurityElement() {
        try {
            return this._servletManager.getSecurityElement(this.getServletClass());
        }
        catch (Exception e) {
            log.log(Level.FINER, e.toString(), e);
            return null;
        }
    }

    public MultipartConfigImpl createMultipartConfig() {
        return new MultipartConfigImpl();
    }

    @Override
    public void setMultipartConfig(MultipartConfigElement multipartConfig) {
        if (multipartConfig == null) {
            throw new IllegalArgumentException();
        }
        if (!this._webApp.isInitializing()) {
            throw new IllegalStateException(L.l("setMultipartConfig must be called during initialization."));
        }
        this._multipartConfigElement = multipartConfig;
    }

    public MultipartConfigElement getMultipartConfig() {
        if (this._multipartConfigElement == null) {
            MultipartConfig config;
            Class servletClass = null;
            try {
                servletClass = this.getServletClass();
            }
            catch (Exception e) {
                log.log(Level.FINER, e.toString(), e);
            }
            if (servletClass != null && (config = servletClass.getAnnotation(MultipartConfig.class)) != null) {
                this._multipartConfigElement = new MultipartConfigElement(config);
            }
        }
        return this._multipartConfigElement;
    }

    @Override
    public Set<String> addMapping(String ... urlPatterns) {
        if (!this._webApp.isInitializing()) {
            throw new IllegalStateException();
        }
        try {
            HashSet<String> result = new HashSet<String>();
            for (String urlPattern : urlPatterns) {
                String servletName;
                ServletMapping map = this._servletMapper.getServletMapping(urlPattern);
                if (map == null || map.isDefault() || this._servletName.equals(servletName = map.getServletName()) || servletName == null) continue;
                if (log.isLoggable(Level.FINE)) {
                    log.fine(L.l("programmatic addMapping for '{0}' ignored because of existing servlet-mapping to '{1}'", (Object)urlPattern, (Object)servletName));
                }
                result.add(urlPattern);
            }
            if (result.size() > 0) {
                return result;
            }
            ServletMapping mapping = this._webApp.createServletMapping();
            mapping.setIfAbsent(true);
            mapping.setServletName(this.getServletName());
            for (String urlPattern : urlPatterns) {
                mapping.addURLPattern(urlPattern);
            }
            this._webApp.addServletMapping(mapping);
            return Collections.unmodifiableSet(result);
        }
        catch (ServletException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public Collection<String> getMappings() {
        Set<String> patterns = this._servletMapper.getUrlPatterns(this._servletName);
        if (patterns != null) {
            return Collections.unmodifiableSet(new LinkedHashSet<String>(patterns));
        }
        return new LinkedHashSet<String>();
    }

    @Override
    public Set<String> setInitParameters(Map<String, String> initParameters) {
        if (!this._webApp.isInitializing()) {
            throw new IllegalStateException();
        }
        HashSet<String> conflicting = new HashSet<String>();
        for (Map.Entry<String, String> param : initParameters.entrySet()) {
            if (this._initParams.containsKey(param.getKey())) {
                conflicting.add(param.getKey());
                continue;
            }
            this._initParams.put(param.getKey(), param.getValue());
        }
        return Collections.unmodifiableSet(conflicting);
    }

    @Override
    public Map<String, String> getInitParameters() {
        return this._initParams;
    }

    @Override
    public void setAsyncSupported(boolean asyncSupported) {
        this._isAsyncSupported = asyncSupported;
    }

    public boolean isAsyncSupported() {
        return this._isAsyncSupported;
    }

    public void setServletNameDefault(String name) {
        this._servletNameDefault = name;
    }

    public String getServletNameDefault() {
        return this._servletNameDefault;
    }

    public String getServletClassName() {
        return this._servletClassName;
    }

    @Configurable
    public void setBean(Bean<?> bean) {
        this._bean = bean;
    }

    public Bean<?> getBean() {
        return this._bean;
    }

    public boolean isServletConfig() {
        return this._bean != null || this._servletClassName != null;
    }

    @Configurable
    public void setServletClass(String servletClassName) {
        this._servletClassName = servletClassName;
        if (this.isFacesServlet()) {
            if (this._loadOnStartup < 0) {
                this._loadOnStartup = 1;
            }
            if (this._servletContext instanceof WebApp) {
                ((WebApp)this._servletContext).createJsp().setLoadTldOnInit(true);
            }
        }
        InjectManager cdiManager = InjectManager.create();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            this._servletClass = Class.forName(servletClassName, false, loader);
            if (this._annType == null) {
                this._annType = cdiManager.createAnnotatedType(this._servletClass);
                cdiManager.discoverBean(this._annType);
            }
        }
        catch (ClassNotFoundException e) {
            log.log(Level.ALL, e.toString(), e);
        }
    }

    private boolean isFacesServlet() {
        return "javax.faces.webapp.FacesServlet".equals(this._servletClassName);
    }

    @DisableConfig
    public void setServletClass(Class<? extends Servlet> servletClass) {
        if (this._servletClass == null) {
            throw new NullPointerException();
        }
        this._servletClass = servletClass;
    }

    public Class getServletClass() {
        if (this._bean != null) {
            return this._bean.getBeanClass();
        }
        if (this._servletClassName == null) {
            return null;
        }
        if (this._servletClass == null) {
            try {
                Thread thread = Thread.currentThread();
                ClassLoader loader = thread.getContextClassLoader();
                this._servletClass = Class.forName(this.calculateServletClassName(), false, loader);
            }
            catch (Exception e) {
                throw this.error(L.l("'{0}' is not a known servlet class.  Servlets belong in the classpath, for example WEB-INF/classes.", (Object)this._servletClassName), e);
            }
        }
        return this._servletClass;
    }

    protected String calculateServletClassName() {
        return this.getServletClassName();
    }

    public void setServlet(Servlet servlet) {
        this._singletonServlet = servlet;
    }

    public void setJspFile(String jspFile) {
        this._jspFile = jspFile;
    }

    public String getJspFile() {
        return this._jspFile;
    }

    public void setAllowEL(boolean allowEL) {
        this._allowEL = allowEL;
    }

    public void setInitParam(String param, String value) {
        this._initParams.put(param, value);
    }

    public InitParam createInitParam() {
        InitParam initParam = new InitParam();
        initParam.setAllowEL(this._allowEL);
        return initParam;
    }

    public void setInitParam(InitParam initParam) {
        if (this._webApp.isAllowInitParamOverride()) {
            this._initParams.putAll(initParam.getParameters());
        } else {
            for (Map.Entry<String, String> param : initParam.getParameters().entrySet()) {
                if (this._initParams.containsKey(param.getKey())) continue;
                this._initParams.put(param.getKey(), param.getValue());
                this._paramNames.add(param.getKey());
            }
        }
    }

    public Map getInitParamMap() {
        return this._initParams;
    }

    @Override
    public String getInitParameter(String name) {
        return this._initParams.get(name);
    }

    public Enumeration getInitParameterNames() {
        return Collections.enumeration(this._initParams.keySet());
    }

    public void setRunAs(RunAs runAs) {
        String roleName = runAs.getRoleName();
        if (roleName != null) {
            this._runAs = new BasicPrincipal(roleName);
        }
    }

    @Override
    public String getRunAsRole() {
        if (this._runAs != null) {
            return this._runAs.getName();
        }
        return null;
    }

    @Override
    public void setRunAsRole(String roleName) {
        if (roleName == null) {
            throw new IllegalArgumentException();
        }
        if (!this._webApp.isInitializing()) {
            throw new IllegalStateException();
        }
        this._runAs = new BasicPrincipal(roleName);
    }

    @Override
    public ServletContext getServletContext() {
        return this._servletContext;
    }

    public void setServletContext(ServletContext app) {
        this._servletContext = app;
    }

    public void setWebApp(WebApp webApp) {
        this._webApp = webApp;
    }

    public ServletManager getServletManager() {
        return this._servletManager;
    }

    public void setServletManager(ServletManager manager) {
        this._servletManager = manager;
    }

    public void setServletMapper(ServletMapper servletMapper) {
        this._servletMapper = servletMapper;
    }

    public void setInit(ContainerProgram init) {
        this._init = init;
    }

    public ContainerProgram getInit() {
        return this._init;
    }

    @Override
    public void setLoadOnStartup(int loadOnStartup) {
        this._loadOnStartup = loadOnStartup;
    }

    public int getLoadOnStartup() {
        if (this._loadOnStartup > Integer.MIN_VALUE) {
            return this._loadOnStartup;
        }
        if (this._runAt != null || this._cron != null) {
            return 0;
        }
        return Integer.MIN_VALUE;
    }

    public RunAt createRunAt() {
        if (this._runAt == null) {
            this._runAt = new RunAt();
        }
        return this._runAt;
    }

    public void setCron(CronType cron) {
        this._cron = cron;
    }

    public void setJndiName(String jndiName) {
        this._jndiName = jndiName;
    }

    public void setVar(String var) {
        this._var = var;
    }

    public RunAt getRunAt() {
        return this._runAt;
    }

    public CronType getCron() {
        return this._cron;
    }

    public void addSecurityRoleRef(SecurityRoleRef ref) {
        if (this._roleMap == null) {
            this._roleMap = new HashMap(8);
        }
        this._roleMap.put(ref.getRoleName(), ref.getRoleLink());
    }

    public HashMap<String, String> getRoleMap() {
        return this._roleMap;
    }

    public void setDisplayName(String displayName) {
        this._displayName = displayName;
    }

    public String getDisplayName() {
        return this._displayName;
    }

    public void setDescription(String description) {
    }

    public void setIcon(Icon icon) {
    }

    public void setProtocol(ServletProtocolConfig protocol) {
        this._protocolConfig = protocol;
    }

    public void setProtocolFactory(ProtocolServletFactory factory) {
        this._protocolFactory = factory;
    }

    public void setInitException(ServletException exn) {
        UnavailableException unExn;
        this._initException = exn;
        this._nextInitTime = 0x3FFFFFFFFFFFFFFFL;
        if (exn instanceof UnavailableException && !(unExn = (UnavailableException)exn).isPermanent()) {
            this._nextInitTime = CurrentTime.getCurrentTime() + 1000L * (long)unExn.getUnavailableSeconds();
        }
    }

    public void setInFragmentMode() {
        this._fragmentMode = FRAGMENT_MODE.IN_FRAGMENT;
    }

    public boolean isInFragmentMode() {
        return this._fragmentMode == FRAGMENT_MODE.IN_FRAGMENT;
    }

    public Object getServlet() {
        return this._servlet;
    }

    public void merge(ServletConfigImpl config) {
        if (this._loadOnStartup == Integer.MIN_VALUE) {
            this._loadOnStartup = config._loadOnStartup;
        }
        if (!this.getClassName().equals(config.getClassName())) {
            throw new ConfigException(L.l("Illegal attempt to specify different servlet-class '{0}' for servlet '{1}'. Servlet '{1}' has already been defined with servlet-class '{2}'. Consider using <absolute-ordering> to exclude conflicting web-fragment.", (Object)config.getClassName(), (Object)this._servletName, (Object)this._servletClassName));
        }
        for (Map.Entry<String, String> param : config._initParams.entrySet()) {
            if (this._paramNames.contains(param.getKey())) continue;
            if (!this._initParams.containsKey(param.getKey())) {
                this._initParams.put(param.getKey(), param.getValue());
                continue;
            }
            if (this._initParams.get(param.getKey()).equals(param.getValue())) continue;
            throw new ConfigException(L.l("Illegal attempt to specify different param-value of '{0}' for parameter '{1}'. This error indicates that two web-fragments use different values. Consider defining the parameter in web.xml to override definitions in web-fragment.", (Object)param.getValue(), (Object)param.getKey()));
        }
    }

    @PostConstruct
    public void init() throws ServletException {
        if (this._runAt != null || this._cron != null) {
            this._alarm = new Alarm(this);
        }
        if (this._servletName == null) {
            if (this.getServletNameDefault() != null) {
                this._servletName = this.getServletNameDefault();
            } else if (this._protocolConfig != null) {
                String protocolName = this._protocolConfig.getUri();
                this.setServletName(this._servletClassName + "-" + protocolName);
            } else {
                this.setServletName(this._servletClassName);
            }
        }
        if (this._jndiName != null) {
            this.validateClass(true);
            Object servlet = this.createServlet(false);
            try {
                Jndi.bindDeepShort(this._jndiName, servlet);
            }
            catch (NamingException e) {
                throw new ServletException(e);
            }
        }
        InjectManager cdiManager = InjectManager.create();
        if (this._var != null) {
            this.validateClass(true);
            Object servlet = this.createServlet(false);
            BeanBuilder<?> factory = cdiManager.createBeanFactory(servlet.getClass());
            factory.name(this._var);
            cdiManager.addBeanDiscover(factory.singleton(servlet));
        }
    }

    protected void validateClass(boolean requireClass) throws ServletException {
        if (this._runAt != null || this._cron != null || this._loadOnStartup >= 0) {
            requireClass = true;
        }
        Thread thread = Thread.currentThread();
        ClassLoader loader = thread.getContextClassLoader();
        if (this._servletClassName != null && !this._servletClassName.equals("invoker")) {
            try {
                this._servletClass = Class.forName(this._servletClassName, false, loader);
            }
            catch (ClassNotFoundException e) {
                if (e instanceof CompileException) {
                    throw this.error(e);
                }
                log.log(Level.FINER, e.toString(), e);
            }
            if (this._servletClass == null) {
                if (requireClass) {
                    throw this.error(L.l("'{0}' is not a known servlet class.  Servlets belong in the classpath, for example WEB-INF/classes.", (Object)this._servletClassName));
                }
                String location = this._location != null ? this._location : "";
                log.warning(L.l(location + "'{0}' is not a known servlet.  Servlets belong in the classpath, often in WEB-INF/classes.", (Object)this._servletClassName));
                return;
            }
            Config.checkCanInstantiate(this._servletClass);
            if (!Servlet.class.isAssignableFrom(this._servletClass) && this._protocolConfig == null && this._protocolFactory == null) {
                throw this.error(L.l("'{0}' must implement javax.servlet.Servlet or have a <protocol>.  All servlets must implement the Servlet interface.", (Object)this._servletClassName));
            }
        }
    }

    public void checkConstructor() throws ServletException {
        Constructor<?>[] constructors = this._servletClass.getDeclaredConstructors();
        Constructor<?> zeroArg = null;
        for (int i = 0; i < constructors.length; ++i) {
            if (constructors[i].getParameterTypes().length != 0) continue;
            zeroArg = constructors[i];
            break;
        }
        if (zeroArg == null) {
            throw this.error(L.l("'{0}' must have a zero arg constructor.  Servlets must have public zero-arg constructors.\n{1} is not a valid constructor.", (Object)this._servletClassName, (Object)(constructors != null ? constructors[0] : null)));
        }
        if (!Modifier.isPublic(zeroArg.getModifiers())) {
            throw this.error(L.l("'{0}' must be public.  '{1}' must have a public, zero-arg constructor.", (Object)zeroArg, (Object)this._servletClassName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleAlarm(Alarm alarm) {
        try {
            log.fine(this + " cron");
            FilterChain chain = this.createServletChain();
            StubServletRequest req = new StubServletRequest();
            StubServletResponse res = new StubServletResponse();
            chain.doFilter(req, res);
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        finally {
            long now = CurrentTime.getCurrentTime();
            long nextTime = this.nextTimeout(now);
            Alarm nextAlarm = this._alarm;
            if (nextAlarm != null) {
                alarm.queue(nextTime - now);
            }
        }
    }

    private long nextTimeout(long now) {
        if (this._cron != null) {
            return this._cron.nextTime(now);
        }
        return this._runAt.getNextTimeout(now);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FilterChain createServletChain() throws ServletException {
        ServletConfigImpl servletConfigImpl = this;
        synchronized (servletConfigImpl) {
            if (this._servletChain != null) {
                return this._servletChain;
            }
            return this.createServletChainImpl();
        }
    }

    private FilterChain createServletChainImpl() throws ServletException {
        String jspFile = this.getJspFile();
        FilterChain servletChain = null;
        if (jspFile != null) {
            QServlet jsp = (QServlet)this._servletManager.createServlet("resin-jsp");
            servletChain = new PageFilterChain(this._servletContext, jsp, jspFile, this);
            return servletChain;
        }
        if (this._singletonServlet != null) {
            servletChain = new ServletFilterChain(this);
            return servletChain;
        }
        this.validateClass(true);
        Class servletClass = this.getServletClass();
        if (servletClass == null) {
            throw new IllegalStateException(L.l("servlet class for {0} can't be null", (Object)this.getServletName()));
        }
        servletChain = QServlet.class.isAssignableFrom(servletClass) ? new PageFilterChain(this._servletContext, (QServlet)this.createServlet(false)) : (SingleThreadModel.class.isAssignableFrom(servletClass) ? new SingleThreadServletFilterChain(this) : (this._protocolConfig != null || this._protocolFactory != null ? new WebServiceFilterChain(this) : (CometServlet.class.isAssignableFrom(servletClass) ? new CometServletFilterChain(this) : new ServletFilterChain(this))));
        return servletChain;
    }

    public Object createServlet() throws ServletException {
        return this.createServlet(false);
    }

    Object createServletMulti() throws ServletException {
        return this.createServlet(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object createServlet(boolean isNew) throws ServletException {
        if (this._servlet != null && !isNew) {
            return this._servlet;
        }
        if (this._singletonServlet != null) {
            ServletConfigImpl servletConfigImpl = this;
            synchronized (servletConfigImpl) {
                if (this._servlet == null) {
                    this._servlet = this._singletonServlet;
                    this._singletonServlet.init(this);
                }
            }
            return this._singletonServlet;
        }
        Object servlet = null;
        if (CurrentTime.getCurrentTime() < this._nextInitTime) {
            throw this._initException;
        }
        try {
            ServletConfigImpl servletConfigImpl = this;
            synchronized (servletConfigImpl) {
                if (!isNew && this._servlet != null) {
                    return this._servlet;
                }
                servlet = this.createServletImpl();
                if (!isNew) {
                    this._servlet = servlet;
                }
            }
            if (log.isLoggable(Level.FINE)) {
                log.finer("Servlet[" + this._servletName + "] active");
            }
            if (!isNew) {
                try {
                    Hashtable<String, String> props = new Hashtable<String, String>();
                    props.put("type", this._servlet.getClass().getSimpleName());
                    props.put("name", this._servletName);
                    Jmx.register(this._servlet, props);
                }
                catch (Exception e) {
                    log.finest(e.toString());
                }
                if ((this._runAt != null || this._cron != null) && this._alarm != null) {
                    long nextTime = this.nextTimeout(CurrentTime.getCurrentTime());
                    this._alarm.queue(nextTime - CurrentTime.getCurrentTime());
                }
            }
            if (log.isLoggable(Level.FINE)) {
                log.finer("Servlet[" + this._servletName + "] active");
            }
            return servlet;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (ServletException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServletException(e);
        }
    }

    Servlet createProtocolServlet() throws ServletException {
        try {
            Object service = this.createServletImpl();
            if (this._protocolFactory == null) {
                this._protocolFactory = this._protocolConfig.createFactory();
            }
            if (this._protocolFactory == null) {
                throw new IllegalStateException(L.l("unknown protocol factory for '{0}'", (Object)this));
            }
            Servlet servlet = this._protocolFactory.createServlet(this.getServletClass(), service);
            servlet.init(this);
            return servlet;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (ServletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException(e);
        }
    }

    private Object createServletImpl() throws Exception {
        Object servlet = this.createServletInstance();
        this.configureServlet(servlet);
        try {
            if (!(servlet instanceof Page) && servlet instanceof Servlet) {
                Servlet servletObj = (Servlet)servlet;
                servletObj.init(this);
            }
        }
        catch (UnavailableException e) {
            this.setInitException(e);
            throw e;
        }
        return servlet;
    }

    private Object createServletInstance() throws Exception {
        Servlet servlet;
        InjectManager cdiManager = InjectManager.create();
        if (this._bean != null) {
            OwnerCreationalContext env = new OwnerCreationalContext(this._bean);
            Object value = cdiManager.findReference(this._bean);
            if (value != null) {
                return value;
            }
            return this._bean.create(env);
        }
        Class servletClass = this.getServletClass();
        if (this._jspFile != null) {
            servlet = this.createJspServlet(this._servletName, this._jspFile);
            if (servlet == null) {
                throw new ServletException(L.l("'{0}' is a missing JSP file.", (Object)this._jspFile));
            }
        } else if (servletClass != null) {
            InjectManager inject = InjectManager.create();
            if (this._comp == null) {
                Set<Bean<?>> beanSet;
                Bean<?> bean;
                if (this._annType != null && (bean = this.findBean(beanSet = inject.getBeans((Type)servletClass, new Annotation[0]), servletClass)) instanceof ManagedBeanImpl) {
                    this._comp = ((ManagedBeanImpl)bean).getInjectionTarget();
                }
                if (this._comp == null) {
                    this._comp = inject.createInjectionTarget(servletClass);
                }
            }
            OwnerCreationalContext env = new OwnerCreationalContext(null);
            try {
                if (this._comp != null) {
                    servlet = this._comp.produce(env);
                    this._comp.inject(servlet, env);
                } else {
                    servlet = servletClass.newInstance();
                }
                BeanBuilder<?> factory = cdiManager.createBeanFactory(servlet.getClass());
                cdiManager.addBeanDiscover(factory.singleton(servlet));
            }
            catch (InjectionException e) {
                throw ConfigException.createConfig(e);
            }
        } else {
            throw new ServletException(L.l("Null servlet class for '{0}'.", (Object)this._servletName));
        }
        return servlet;
    }

    private Bean<?> findBean(Set<Bean<?>> beanSet, Class<?> cl) {
        if (beanSet.size() == 0) {
            return null;
        }
        for (Bean<?> bean : beanSet) {
            if (!bean.getBeanClass().equals(cl)) continue;
            return bean;
        }
        Iterator<Bean<?>> i$ = beanSet.iterator();
        if (i$.hasNext()) {
            Bean<?> bean;
            bean = i$.next();
            return bean;
        }
        return null;
    }

    void configureServlet(Object servlet) {
        ContainerProgram init = this.getInit();
        if (init != null) {
            init.configure(servlet);
        }
        Config.init(servlet);
    }

    private Servlet createJspServlet(String servletName, String jspFile) throws ServletException {
        try {
            ServletConfigImpl jspConfig = this._servletManager.getServlet("resin-jsp");
            QServlet jsp = (QServlet)jspConfig.createServlet(false);
            Page page = jsp.getPage(servletName, jspFile, this);
            return page;
        }
        catch (ServletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException(e);
        }
    }

    void killServlet() {
        Object servlet = this._servlet;
        this._servlet = null;
        Alarm alarm = this._alarm;
        this._alarm = null;
        if (alarm != null) {
            alarm.dequeue();
        }
        if (this._comp != null) {
            this._comp.preDestroy(servlet);
        }
        if (servlet instanceof Servlet) {
            ((Servlet)servlet).destroy();
        }
    }

    public void close() {
        this.killServlet();
        this._alarm = null;
    }

    protected ConfigException error(String msg) {
        ConfigException e = this._location != null ? new LineConfigException(this._location + msg) : new ConfigException(msg);
        log.warning(e.getMessage());
        return e;
    }

    protected ConfigException error(String msg, Throwable e) {
        ConfigException e1 = this._location != null ? new LineConfigException(this._location + msg, e) : new ConfigException(msg, e);
        log.warning(e1.getMessage());
        return e1;
    }

    protected RuntimeException error(Throwable e) {
        RuntimeException e1 = this._location != null ? new LineConfigException(this._location + e.getMessage(), e) : ConfigException.create(e);
        log.warning(e1.toString());
        return e1;
    }

    protected void copyFrom(ServletConfigImpl source) {
        this._initParams.putAll(source._initParams);
        this._init = source._init;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[name=" + this._servletName + ",class=" + this._servletClass + "]";
    }

    public static class RunAs {
        private String _roleName;

        public void setRoleName(String roleName) {
            this._roleName = roleName;
        }

        public String getRoleName() {
            return this._roleName;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FRAGMENT_MODE {
        IN_FRAGMENT,
        IN_WEBXML;

    }
}

