/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.dispatch;

import com.caucho.server.webapp.RequestDispatcherImpl;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RewriteIncludeFilterChain
implements FilterChain {
    private static final Logger log = Logger.getLogger(RewriteIncludeFilterChain.class.getName());
    private String _url;

    public RewriteIncludeFilterChain(FilterChain next, String url) {
        this._url = url;
    }

    public void doFilter(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        try {
            RequestDispatcherImpl disp = (RequestDispatcherImpl)req.getRequestDispatcher(this._url);
            disp.include(request, response);
        }
        catch (FileNotFoundException e) {
            log.log(Level.FINE, e.toString(), e);
            res.sendError(404);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._url + "]";
    }
}

