/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.cluster;

import com.caucho.cloud.network.NetworkListenSystem;
import com.caucho.env.meter.MeterService;
import com.caucho.env.meter.TotalMeter;
import com.caucho.env.service.ResinSystem;
import com.caucho.management.server.AbstractEmitterObject;
import com.caucho.management.server.CacheItem;
import com.caucho.management.server.ClusterMXBean;
import com.caucho.management.server.ClusterServerMXBean;
import com.caucho.management.server.EnvironmentMXBean;
import com.caucho.management.server.PortMXBean;
import com.caucho.management.server.ServerMXBean;
import com.caucho.management.server.TcpConnectionInfo;
import com.caucho.management.server.ThreadPoolMXBean;
import com.caucho.network.listen.TcpPort;
import com.caucho.network.listen.TcpSocketLink;
import com.caucho.server.cluster.ServletService;
import com.caucho.server.dispatch.Invocation;
import com.caucho.server.dispatch.InvocationServer;
import com.caucho.server.util.CauchoSystem;
import com.caucho.util.CurrentTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerAdmin
extends AbstractEmitterObject
implements ServerMXBean {
    private static final String BYTES_PROBE = "Resin|Http|Request Bytes";
    private TotalMeter _httpBytesProbe;
    private ServletService _server;

    ServerAdmin(ServletService server) {
        this._server = server;
        MeterService.createAverageMeter(BYTES_PROBE, "");
        String name = BYTES_PROBE;
        this._httpBytesProbe = (TotalMeter)MeterService.getMeter(name);
        this.registerSelf();
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public String getType() {
        return "Server";
    }

    @Override
    public String getId() {
        return this._server.getServerId();
    }

    @Override
    public int getServerIndex() {
        return this._server.getServerIndex();
    }

    @Override
    public ClusterServerMXBean getSelfServer() {
        return this._server.getSelfServer().getAdmin();
    }

    @Override
    public ClusterMXBean getCluster() {
        return this._server.getCluster().getAdmin();
    }

    @Override
    public EnvironmentMXBean getEnvironment() {
        return this._server.getEnvironmentAdmin();
    }

    @Override
    public PortMXBean[] getPorts() {
        Collection<TcpPort> portList = this.getNetworkListeners();
        PortMXBean[] ports = new PortMXBean[portList.size()];
        int i = 0;
        for (TcpPort port : portList) {
            ports[i++] = port.getAdmin();
        }
        return ports;
    }

    @Override
    public ThreadPoolMXBean getThreadPool() {
        return this._server.getResin().getAdmin().getThreadPoolAdmin();
    }

    @Override
    public PortMXBean getClusterPort() {
        return null;
    }

    @Override
    public boolean isBindPortsAfterStart() {
        ResinSystem resinSystem = this._server.getResinSystem();
        NetworkListenSystem listenService = resinSystem.getService(NetworkListenSystem.class);
        return listenService.isBindPortsAfterStart();
    }

    @Override
    public boolean isDetailedStatistics() {
        return false;
    }

    @Override
    public boolean isDevelopmentModeErrorPage() {
        return this._server.isDevelopmentModeErrorPage();
    }

    @Override
    public long getMemoryFreeMin() {
        return 0L;
    }

    @Override
    public long getPermGenFreeMin() {
        return 0L;
    }

    @Override
    public String getServerHeader() {
        return this._server.getServerHeader();
    }

    @Override
    public boolean isSelectManagerEnabled() {
        return false;
    }

    @Override
    public long getShutdownWaitMax() {
        return this._server.getShutdownWaitMax();
    }

    @Override
    public String getStage() {
        return this._server.getStage();
    }

    @Override
    public int getUrlLengthMax() {
        return this._server.getUrlLengthMax();
    }

    @Override
    public int getHeaderSizeMax() {
        return this._server.getHeaderSizeMax();
    }

    @Override
    public int getHeaderCountMax() {
        return this._server.getHeaderCountMax();
    }

    @Override
    public String getState() {
        return this._server.getState();
    }

    @Override
    public Date getCurrentTime() {
        return new Date(CurrentTime.getCurrentTime());
    }

    @Override
    public Date getStartTime() {
        return new Date(this._server.getStartTime());
    }

    @Override
    public long getUptime() {
        return CurrentTime.getCurrentTime() - this._server.getStartTime();
    }

    @Override
    public int getThreadActiveCount() {
        int activeThreadCount = -1;
        for (TcpPort port : this.getNetworkListeners()) {
            if (port.getActiveThreadCount() < 0) continue;
            if (activeThreadCount == -1) {
                activeThreadCount = 0;
            }
            activeThreadCount += port.getActiveThreadCount();
        }
        return activeThreadCount;
    }

    @Override
    public int getThreadKeepaliveCount() {
        int keepaliveThreadCount = -1;
        for (TcpPort port : this.getNetworkListeners()) {
            if (port.getKeepaliveConnectionCount() < 0) continue;
            if (keepaliveThreadCount == -1) {
                keepaliveThreadCount = 0;
            }
            keepaliveThreadCount += port.getKeepaliveConnectionCount();
        }
        return keepaliveThreadCount;
    }

    @Override
    public int getSelectKeepaliveCount() {
        return 0;
    }

    @Override
    public long getRequestCountTotal() {
        long lifetimeRequestCount = 0L;
        for (TcpPort port : this.getNetworkListeners()) {
            lifetimeRequestCount += port.getLifetimeRequestCount();
        }
        return lifetimeRequestCount;
    }

    @Override
    public long getKeepaliveCountTotal() {
        return -1L;
    }

    @Override
    public long getClientDisconnectCountTotal() {
        long lifetimeClientDisconnectCount = 0L;
        for (TcpPort port : this.getNetworkListeners()) {
            lifetimeClientDisconnectCount += port.getLifetimeClientDisconnectCount();
        }
        return lifetimeClientDisconnectCount;
    }

    @Override
    public long getRequestTimeTotal() {
        return -1L;
    }

    @Override
    public long getRequestReadBytesTotal() {
        return -1L;
    }

    @Override
    public long getRequestWriteBytesTotal() {
        if (this._httpBytesProbe != null) {
            return (long)this._httpBytesProbe.getTotal();
        }
        return 0L;
    }

    @Override
    public long getInvocationCacheHitCountTotal() {
        return this._server.getInvocationServer().getInvocationCacheHitCount();
    }

    @Override
    public long getInvocationCacheMissCountTotal() {
        return this._server.getInvocationServer().getInvocationCacheMissCount();
    }

    @Override
    public long getSendfileCountTotal() {
        return this._server.getSendfileCount();
    }

    @Override
    public long getRuntimeMemory() {
        if (CurrentTime.isTest()) {
            return 666L;
        }
        return Runtime.getRuntime().totalMemory();
    }

    @Override
    public long getRuntimeMemoryFree() {
        if (CurrentTime.isTest()) {
            return 666L;
        }
        return Runtime.getRuntime().freeMemory();
    }

    @Override
    public double getCpuLoadAvg() {
        try {
            if (CurrentTime.isTest()) {
                return 0.0;
            }
            return CauchoSystem.getLoadAvg();
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public ArrayList<CacheItem> getCacheStatistics() {
        InvocationServer server = this._server.getInvocationServer();
        ArrayList<Invocation> invocationList = server.getInvocations();
        if (invocationList == null) {
            return null;
        }
        HashMap<String, CacheItem> itemMap = new HashMap<String, CacheItem>();
        for (int i = 0; i < invocationList.size(); ++i) {
            CacheItem item;
            Invocation inv = invocationList.get(i);
            String uri = inv.getURI();
            int p = uri.indexOf(63);
            if (p >= 0) {
                uri = uri.substring(0, p);
            }
            if ((item = (CacheItem)itemMap.get(uri)) != null) continue;
            item = new CacheItem();
            item.setUrl(uri);
            itemMap.put(uri, item);
        }
        return null;
    }

    @Override
    public void restart() {
        this._server.destroy();
    }

    @Override
    public TcpConnectionInfo findConnectionByThreadId(long threadId) {
        TcpSocketLink conn = this.getListenService().findConnectionByThreadId(threadId);
        if (conn != null) {
            return conn.getConnectionInfo();
        }
        return null;
    }

    private Collection<TcpPort> getNetworkListeners() {
        NetworkListenSystem listenService = this._server.getResinSystem().getService(NetworkListenSystem.class);
        return listenService.getListeners();
    }

    private NetworkListenSystem getListenService() {
        return this._server.getResinSystem().getService(NetworkListenSystem.class);
    }
}

