/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.security;

import com.caucho.config.Config;
import com.caucho.config.ConfigException;
import com.caucho.security.AbstractAuthenticator;
import com.caucho.security.BasicPrincipal;
import com.caucho.security.PasswordUser;
import com.caucho.util.CurrentTime;
import com.caucho.vfs.Depend;
import com.caucho.vfs.Path;
import java.security.Principal;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.inject.Singleton;
import javax.servlet.ServletException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class XmlAuthenticator
extends AbstractAuthenticator {
    private static final Logger log = Logger.getLogger(XmlAuthenticator.class.getName());
    private Path _path;
    private Hashtable<String, PasswordUser> _userMap = new Hashtable();
    private Depend _depend;
    private long _lastCheck;

    public void setPath(Path path) {
        this._path = path;
    }

    public Path getPath() {
        return this._path;
    }

    protected String getDefaultGroup() {
        return "user";
    }

    public User createUser() {
        return new User();
    }

    public void addUser(User user) {
        if (user.getName() != null && !"".equals(user.getName())) {
            this._userMap.put(user.getName(), user.getPasswordUser());
        }
    }

    protected Hashtable<String, PasswordUser> getUserMap() {
        return this._userMap;
    }

    @Override
    @PostConstruct
    public synchronized void init() throws ServletException {
        super.init();
        this.reload();
    }

    @Override
    protected PasswordUser getPasswordUser(String userName) {
        PasswordUser user;
        if (userName == null) {
            return null;
        }
        if (this.isModified()) {
            this.reload();
        }
        if ((user = this._userMap.get(userName)) != null) {
            return user.copy();
        }
        return null;
    }

    public synchronized void reload() {
        if (this._path == null) {
            return;
        }
        try {
            this._lastCheck = CurrentTime.getCurrentTime();
            this._depend = new Depend(this._path);
            if (log.isLoggable(Level.FINE)) {
                log.fine(this + " loading users from " + this._path);
            }
            this._userMap = new Hashtable();
            new Config().configureBean((Object)this, this._path);
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }

    private boolean isModified() {
        if (this._path == null) {
            return false;
        }
        if (this._depend == null) {
            return true;
        }
        if (CurrentTime.getCurrentTime() < this._lastCheck + 5000L) {
            return false;
        }
        this._lastCheck = CurrentTime.getCurrentTime();
        return this._depend.isModified();
    }

    public class User {
        private String _name;
        private String _password;
        private Principal _principal;
        private String[] _roles = new String[0];
        private boolean _isDisabled;

        public User() {
        }

        User(String name, String password, Principal principal) {
            this._name = name;
            this._password = password;
            this._principal = principal;
        }

        public void setName(String name) {
            this._name = name;
            if (this._principal == null) {
                this._principal = new BasicPrincipal(name);
            }
        }

        public String getName() {
            return this._name;
        }

        public void setPassword(String password) {
            this._password = password;
        }

        public void setPrincipal(Principal principal) {
            this._principal = principal;
        }

        Principal getPrincipal() {
            return this._principal;
        }

        public void addRoles(String roles) {
            for (String role : roles.split("[ ,]")) {
                this.addRole(role);
            }
        }

        public void setEnable(boolean isEnabled) {
            this._isDisabled = !isEnabled;
        }

        public void setDisable(boolean isDisabled) {
            this._isDisabled = isDisabled;
        }

        public void addGroup(String role) {
            this.addRole(role);
        }

        public void addRole(String role) {
            if ("disabled".equals(role)) {
                this._isDisabled = true;
            }
            String[] newRoles = new String[this._roles.length + 1];
            System.arraycopy(this._roles, 0, newRoles, 0, this._roles.length);
            newRoles[this._roles.length] = role;
            this._roles = newRoles;
        }

        String[] getRoles() {
            return this._roles;
        }

        public void addText(String userParam) {
            String roles;
            String password;
            int p1 = userParam.indexOf(58);
            if (p1 < 0) {
                return;
            }
            String name = userParam.substring(0, p1);
            int p2 = userParam.indexOf(58, p1 + 1);
            if (p2 < 0) {
                password = userParam.substring(p1 + 1);
                roles = XmlAuthenticator.this.getDefaultGroup();
            } else {
                password = userParam.substring(p1 + 1, p2);
                roles = userParam.substring(p2 + 1);
            }
            this.setName(name);
            this.setPassword(password);
            this.addRoles(roles);
        }

        @PostConstruct
        public void init() {
            if ((this._roles == null || this._roles.length == 0) && XmlAuthenticator.this.getDefaultGroup() != null) {
                this._roles = new String[]{XmlAuthenticator.this.getDefaultGroup()};
            }
        }

        public PasswordUser getPasswordUser() {
            boolean isAnonymous = false;
            return new PasswordUser(this._principal, this._password.toCharArray(), this._isDisabled, isAnonymous, this._roles);
        }
    }
}

