/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.security;

import com.caucho.util.L10N;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.util.logging.Logger;

public class PolicyImpl
extends Policy {
    private static Logger _log;
    private static L10N _L;
    private static final PolicyImpl _policy;
    private ClassLoader _systemClassLoader;
    private Policy _parent = Policy.getPolicy();

    private PolicyImpl() {
        this._systemClassLoader = ClassLoader.getSystemClassLoader();
    }

    public static PolicyImpl getPolicy() {
        return _policy;
    }

    public static void init() {
        Policy.setPolicy(_policy);
    }

    public PermissionCollection getPermissions(CodeSource codesource) {
        Permissions perms = new Permissions();
        ((PermissionCollection)perms).add(new AllPermission());
        return perms;
    }

    public PermissionCollection getPermissions(ProtectionDomain domain) {
        Permissions perms = new Permissions();
        ((PermissionCollection)perms).add(new AllPermission());
        return perms;
    }

    public boolean implies(ProtectionDomain domain, Permission permission) {
        ClassLoader loader = domain.getClassLoader();
        if (loader == this._systemClassLoader) {
            return true;
        }
        return true;
    }

    public void refresh() {
    }

    private Logger log() {
        if (_log == null) {
            _log = Logger.getLogger(PolicyImpl.class.getName());
        }
        return _log;
    }

    private L10N L() {
        if (_L == null) {
            _L = new L10N(PolicyImpl.class);
        }
        return _L;
    }

    public String toString() {
        return "PolicyImpl[]";
    }

    static {
        _policy = new PolicyImpl();
    }
}

