/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.security;

import com.caucho.security.BasicPrincipal;
import java.io.Serializable;
import java.security.Principal;

public class PasswordUser
implements Serializable {
    private final Principal _principal;
    private final char[] _password;
    private final boolean _isDisabled;
    private final boolean _isAnonymous;
    private final String[] _roles;

    public PasswordUser(Principal principal, char[] password, boolean isDisabled, boolean isAnonymous, String[] roles) {
        this._principal = principal;
        this._password = password;
        this._isDisabled = isDisabled;
        this._isAnonymous = isAnonymous;
        this._roles = roles;
    }

    public PasswordUser(Principal principal, char[] password, String[] roles) {
        this(principal, password, false, false, roles);
    }

    public PasswordUser(String user, char[] password, String[] roles) {
        this(new BasicPrincipal(user), password, false, false, roles);
    }

    public PasswordUser(String user, char[] password) {
        this(new BasicPrincipal(user), password, false, false, new String[]{"user"});
    }

    public PasswordUser(String user, String password) {
        this(new BasicPrincipal(user), password.toCharArray(), false, false, new String[]{"user"});
    }

    public Principal getPrincipal() {
        return this._principal;
    }

    public boolean isDisabled() {
        return this._isDisabled;
    }

    public boolean isAnonymous() {
        return this._isAnonymous;
    }

    public char[] getPassword() {
        return this._password;
    }

    public void clearPassword() {
        for (int i = this._password.length - 1; i >= 0; --i) {
            this._password[i] = '\u0000';
        }
    }

    public boolean isUserInRole(String testRole) {
        if (this._roles == null) {
            return false;
        }
        for (String role : this._roles) {
            if (!role.equals(testRole)) continue;
            return true;
        }
        return false;
    }

    public String[] getRoles() {
        return this._roles;
    }

    public PasswordUser copy() {
        return new PasswordUser(this._principal, this._password, this._isDisabled, this._isAnonymous, this._roles);
    }

    public String toString() {
        if (this.isDisabled()) {
            return this.getClass().getSimpleName() + "[" + this._principal + ",disabled]";
        }
        return this.getClass().getSimpleName() + "[" + this._principal + "]";
    }
}

