/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.security;

import com.caucho.security.Authenticator;
import com.caucho.security.Login;
import java.security.Principal;
import java.util.ArrayList;
import javax.ejb.Startup;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
@Startup
public class LoginList
implements Login {
    private final ArrayList<Login> _loginList = new ArrayList();

    public void add(Login login) {
        this._loginList.add(login);
    }

    public ArrayList<Login> getLoginList() {
        return this._loginList;
    }

    @Override
    public String getAuthType() {
        if (this._loginList.size() == 0) {
            return null;
        }
        return this._loginList.get(0).getAuthType();
    }

    @Override
    public Authenticator getAuthenticator() {
        if (this._loginList.size() == 0) {
            return null;
        }
        return this._loginList.get(0).getAuthenticator();
    }

    @Override
    public boolean isLoginUsedForRequest(HttpServletRequest request) {
        for (int i = 0; i < this._loginList.size(); ++i) {
            if (!this._loginList.get(i).isLoginUsedForRequest(request)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Principal getUserPrincipal(HttpServletRequest request) {
        for (int i = 0; i < this._loginList.size(); ++i) {
            Principal user = this._loginList.get(i).getUserPrincipal(request);
            if (user == null) continue;
            return user;
        }
        return null;
    }

    @Override
    public Principal login(HttpServletRequest request, HttpServletResponse response, boolean isFail) {
        for (int i = 0; i < this._loginList.size(); ++i) {
            Principal user;
            Login login = this._loginList.get(i);
            if (!login.isLoginUsedForRequest(request) || (user = login.login(request, response, isFail)) == null) continue;
            return user;
        }
        if (this._loginList.size() > 0) {
            Login login = this._loginList.get(0);
            Principal user = login.login(request, response, isFail);
            return user;
        }
        return null;
    }

    @Override
    public boolean isPasswordBased() {
        for (int i = 0; i < this._loginList.size(); ++i) {
            if (!this._loginList.get(i).isPasswordBased()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isUserInRole(Principal user, String role) {
        for (int i = 0; i < this._loginList.size(); ++i) {
            if (!this._loginList.get(i).isUserInRole(user, role)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void logout(Principal user, HttpServletRequest request, HttpServletResponse response) {
        for (int i = 0; i < this._loginList.size(); ++i) {
            this._loginList.get(i).logout(user, request, response);
        }
    }

    @Override
    public void sessionInvalidate(HttpSession session, boolean isTimeout) {
        for (int i = 0; i < this._loginList.size(); ++i) {
            this._loginList.get(i).sessionInvalidate(session, isTimeout);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + this._loginList;
    }
}

