/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.rewrite;

import com.caucho.config.ConfigException;
import com.caucho.config.Configurable;
import com.caucho.management.server.AbstractManagedObject;
import com.caucho.management.server.IfMBeanEnabledMXBean;
import com.caucho.rewrite.RequestPredicate;
import com.caucho.util.L10N;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;

@Configurable
public class IfMBeanEnabled
implements RequestPredicate {
    private static final L10N L = new L10N(IfMBeanEnabled.class);
    private String _name;
    private boolean _isEnabledDefault = true;
    private Boolean _isEnabled;
    private Admin _admin;

    @Configurable
    public void setName(String name) {
        this._name = name;
    }

    @Configurable
    public void setEnabled(boolean isEnabled) {
        this._isEnabledDefault = isEnabled;
    }

    public boolean isMatch(HttpServletRequest request) {
        if (this._isEnabled != null) {
            return this._isEnabled;
        }
        return this._isEnabledDefault;
    }

    @PostConstruct
    private void init() {
        if (this._name == null) {
            throw new ConfigException(L.l("resin:IfMBeanEnabled requires a 'name' attribute."));
        }
        this._admin = new Admin();
        this._admin.register();
    }

    class Admin
    extends AbstractManagedObject
    implements IfMBeanEnabledMXBean {
        Admin() {
        }

        protected void register() {
            this.registerSelf();
        }

        public String getName() {
            return IfMBeanEnabled.this._name;
        }

        public void disable() {
            IfMBeanEnabled.this._isEnabled = false;
        }

        public void enable() {
            IfMBeanEnabled.this._isEnabled = true;
        }

        public String getState() {
            if (IfMBeanEnabled.this._isEnabled != null) {
                return String.valueOf(IfMBeanEnabled.this._isEnabled);
            }
            return "default";
        }

        public void reset() {
            IfMBeanEnabled.this._isEnabled = null;
        }
    }
}

