/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.rewrite;

import com.caucho.config.ConfigException;
import com.caucho.config.Configurable;
import com.caucho.rewrite.RequestPredicate;
import com.caucho.util.L10N;
import javax.servlet.http.HttpServletRequest;

@Configurable
public class IfAuthType
implements RequestPredicate {
    private static final L10N L = new L10N(IfAuthType.class);
    private String _authType;

    @Configurable
    public void setValue(String authType) {
        if ("NONE".equalsIgnoreCase(authType)) {
            this._authType = null;
        } else if ("BASIC".equalsIgnoreCase(authType)) {
            this._authType = "BASIC";
        } else if ("CLIENT_CERT".equalsIgnoreCase(authType)) {
            this._authType = "CLIENT_CERT";
        } else if ("DIGEST".equalsIgnoreCase(authType)) {
            this._authType = "DIGEST";
        } else if ("FORM".equalsIgnoreCase(authType)) {
            this._authType = "FORM";
        } else {
            throw new ConfigException(L.l("auth-type expects a 'value' of BASIC, CLIENT-CERT, DIGEST, FORM, or NONE"));
        }
    }

    public boolean isMatch(HttpServletRequest request) {
        String authType = request.getAuthType();
        if (authType == null) {
            authType = "none";
        }
        if (this._authType != null) {
            return this._authType.equalsIgnoreCase(authType);
        }
        return "none".equalsIgnoreCase(authType);
    }
}

