/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.resources.rmi;

import com.caucho.config.ConfigException;
import com.caucho.jca.ra.AbstractResourceAdapter;
import com.caucho.resources.rmi.RmiService;
import com.caucho.util.L10N;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ResourceAdapterInternalException;

public class RmiRegistry
extends AbstractResourceAdapter {
    private static final Logger log = Logger.getLogger(RmiRegistry.class.getName());
    static final L10N L = new L10N(RmiRegistry.class);
    private String _server = "localhost";
    private int _port = 1099;
    private LinkedList<RmiService> _services = new LinkedList();
    private String _namePrefix;

    public void setServer(String server) {
        this._server = server;
    }

    public String getServer() {
        return this._server;
    }

    public void setPort(int port) {
        this._port = port;
    }

    public int getPort() {
        return this._port;
    }

    public void addRmiService(RmiService service) throws ConfigException {
        this._services.add(service);
    }

    @PostConstruct
    public void init() throws ConfigException {
        if (System.getSecurityManager() == null) {
            throw new ConfigException("RMI requires a SecurityManager - add a <security-manager/> element to <resin>");
        }
        this._namePrefix = "//" + this._server + ':' + this._port + '/';
    }

    public void start(BootstrapContext ctx) throws ResourceAdapterInternalException {
        if (this._server.equals("localhost")) {
            this.startRegistry();
        } else {
            log.config(L.l("using remote RMI Registry `{0}:{1}'", (Object)this._server, (Object)String.valueOf(this._port)));
        }
        for (RmiService s : this._services) {
            s.start();
        }
    }

    String makeFullName(String serviceName) {
        return this._namePrefix + serviceName;
    }

    private void startRegistry() throws ResourceAdapterInternalException {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            try {
                thread.setContextClassLoader(ClassLoader.getSystemClassLoader());
                try {
                    Registry reg = LocateRegistry.getRegistry(this._port);
                    reg.list();
                    if (log.isLoggable(Level.CONFIG)) {
                        log.config(L.l("found RMI Registry on port `{0}'", this._port));
                    }
                }
                catch (Exception e) {
                    if (log.isLoggable(Level.CONFIG)) {
                        log.config(L.l("creating RMI Registry on port `{0}'", this._port));
                    }
                    LocateRegistry.createRegistry(this._port);
                }
                Object var5_6 = null;
                thread.setContextClassLoader(oldLoader);
            }
            catch (Exception ex) {
                throw new ResourceAdapterInternalException(ex);
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            thread.setContextClassLoader(oldLoader);
            throw throwable;
        }
    }

    public void stop() {
        for (RmiService s : this._services) {
            s.stop();
        }
    }
}

