/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.resources;

import com.caucho.config.ConfigException;
import com.caucho.config.Configurable;
import com.caucho.config.Unbound;
import com.caucho.config.inject.CandiELContext;
import com.caucho.config.inject.InjectManager;
import com.caucho.config.types.CronType;
import com.caucho.config.types.Period;
import com.caucho.config.types.Trigger;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.EnvironmentListener;
import com.caucho.resources.TimerTrigger;
import com.caucho.server.http.StubServletRequest;
import com.caucho.server.http.StubServletResponse;
import com.caucho.server.util.ScheduledThreadPool;
import com.caucho.server.webapp.RequestDispatcherImpl;
import com.caucho.server.webapp.WebApp;
import com.caucho.util.Alarm;
import com.caucho.util.AlarmListener;
import com.caucho.util.CurrentTime;
import com.caucho.util.L10N;
import java.util.Date;
import java.util.TimerTask;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.ejb.Startup;
import javax.el.ELContext;
import javax.el.MethodExpression;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.resource.spi.work.Work;

@Singleton
@Startup
@Unbound
@Configurable
public class ScheduledTask
implements AlarmListener,
EnvironmentListener {
    private static final L10N L = new L10N(ScheduledTask.class);
    private static final Logger log = Logger.getLogger(ScheduledTask.class.getName());
    private Executor _threadPool;
    private ClassLoader _loader;
    private Trigger _trigger;
    private TimerTrigger _timerTrigger = new TimerTrigger();
    private Runnable _task;
    private MethodExpression _method;
    private String _url;
    @Inject
    private Instance<WebApp> _webAppInstance;
    private WebApp _webApp;
    private Alarm _alarm;
    private volatile boolean _isActive;
    private long _nextTime;

    public ScheduledTask() {
        this._loader = Thread.currentThread().getContextClassLoader();
        this._threadPool = ScheduledThreadPool.getLocal();
    }

    @Configurable
    public void setDelay(Period delay) {
        this._trigger = this._timerTrigger;
        this._timerTrigger.setFirstTime(CurrentTime.getExactTime() + delay.getPeriod());
    }

    @Configurable
    public void setPeriod(Period period) {
        this._trigger = this._timerTrigger;
        this._timerTrigger.setPeriod(period.getPeriod());
    }

    @Configurable
    public void setCron(String cron) {
        this._trigger = new CronType(cron);
    }

    @Configurable
    public void setMethod(MethodExpression method) {
        this._method = method;
    }

    @Configurable
    public void setUrl(String url) {
        if (!url.startsWith("/")) {
            throw new ConfigException(L.l("url '{0}' must be absolute", (Object)url));
        }
        this._url = url;
        this._webApp = WebApp.getCurrent();
    }

    @Configurable
    public void setTask(Runnable task) {
        this._task = task;
    }

    public Runnable getTask() {
        return this._task;
    }

    @Configurable
    public void add(Runnable task) {
        this._task = task;
    }

    @PostConstruct
    public void init() throws ConfigException {
        if (this._task == null) {
            if (this._method != null) {
                this._task = new MethodTask(this._method);
            } else if (this._url != null) {
                this._task = new ServletTask(this._url, this._webApp);
            }
        }
        if (this._task == null) {
            throw new ConfigException(L.l("{0} requires a <task>, <method>, or <url> because the ScheduledTask needs a task to run.", (Object)this));
        }
        if (this._trigger == null) {
            this._timerTrigger.setFirstTime(0x3FFFFFFFFFFFFFFFL);
            this._trigger = this._timerTrigger;
        }
        Environment.addEnvironmentListener(this);
    }

    private void start() {
        long now = CurrentTime.getCurrentTime();
        long nextTime = this._trigger.nextTime(now + 500L);
        this._isActive = true;
        assert (this._task != null);
        this._alarm = new Alarm("cron-resource", (AlarmListener)this, nextTime - now);
        if (log.isLoggable(Level.FINER)) {
            log.finer(this + " started. Next event at " + new Date(nextTime));
        }
    }

    private void stop() {
        this._isActive = false;
        Alarm alarm = this._alarm;
        this._alarm = null;
        if (alarm != null) {
            alarm.dequeue();
        }
        if (this._task instanceof Work) {
            ((Work)this._task).release();
        } else if (this._task instanceof TimerTask) {
            ((TimerTask)this._task).cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleAlarm(Alarm alarm) {
        if (!this._isActive) {
            return;
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            block6: {
                try {
                    thread.setContextClassLoader(this._loader);
                    log.fine(this + " executing " + this._task);
                    long now = CurrentTime.getExactTime();
                    long nextTime = this._trigger.nextTime(now + 500L);
                    if (nextTime != this._nextTime) {
                        this._threadPool.execute(this._task);
                    }
                    this._nextTime = nextTime;
                    if (!this._isActive) break block6;
                    alarm.queueAt(nextTime);
                    if (!log.isLoggable(Level.FINER)) break block6;
                    log.finer(this + " complete. Next event at " + new Date(nextTime));
                }
                catch (Exception e) {
                    log.log(Level.WARNING, e.toString(), e);
                    Object var9_8 = null;
                    thread.setContextClassLoader(oldLoader);
                }
            }
            Object var9_7 = null;
            thread.setContextClassLoader(oldLoader);
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            thread.setContextClassLoader(oldLoader);
            throw throwable;
        }
    }

    public void environmentConfigure(EnvironmentClassLoader loader) throws ConfigException {
    }

    public void environmentBind(EnvironmentClassLoader loader) throws ConfigException {
    }

    public void environmentStart(EnvironmentClassLoader loader) {
        this.start();
    }

    public void environmentStop(EnvironmentClassLoader loader) {
        this.stop();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._task + "," + this._trigger + "]";
    }

    public class ServletTask
    implements Runnable {
        private String _url;
        private WebApp _webApp;

        ServletTask(String url, WebApp webApp) {
            this._url = url;
            this._webApp = webApp;
        }

        public void run() {
            StubServletRequest req = new StubServletRequest();
            StubServletResponse res = new StubServletResponse();
            try {
                RequestDispatcherImpl dispatcher = this._webApp.getRequestDispatcher(this._url);
                dispatcher.forward(req, res);
            }
            catch (Exception e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this._url + "," + this._webApp + "]";
        }
    }

    public static class MethodTask
    implements Runnable {
        private static final Object[] _args = new Object[0];
        private ELContext _elContext;
        private MethodExpression _method;

        MethodTask(MethodExpression method) {
            this._method = method;
            this._elContext = new CandiELContext(InjectManager.create());
        }

        public void run() {
            this._method.invoke(this._elContext, _args);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this._method + "]";
        }
    }
}

