/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.resin;

import com.caucho.cloud.network.NetworkListenSystem;
import com.caucho.config.ConfigException;
import com.caucho.env.service.ResinSystem;
import com.caucho.network.listen.TcpPort;
import com.caucho.resin.PortEmbed;
import com.caucho.server.cluster.ServletService;
import com.caucho.server.http.HttpProtocol;

public class HttpEmbed
extends PortEmbed {
    private TcpPort _port;

    public HttpEmbed() {
    }

    public HttpEmbed(int port) {
        this.setPort(port);
    }

    public HttpEmbed(int port, String ipAddress) {
        this.setPort(port);
        this.setAddress(ipAddress);
    }

    public int getLocalPort() {
        if (this._port != null) {
            return this._port.getLocalPort();
        }
        return this.getPort();
    }

    public void bindTo(ServletService server) {
        try {
            this._port = new TcpPort();
            this._port.setProtocol(new HttpProtocol());
            this._port.setPort(this.getPort());
            this._port.setAddress(this.getAddress());
            this._port.init();
            ResinSystem system = server.getResinSystem();
            NetworkListenSystem listenService = system.getService(NetworkListenSystem.class);
            listenService.addListener(this._port);
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }
}

