/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.remote.websocket;

import com.caucho.remote.websocket.FrameInputStream;
import com.caucho.remote.websocket.WebSocketConstants;
import java.io.IOException;
import java.io.InputStream;

public class WebSocketInputStream
extends InputStream
implements WebSocketConstants {
    private final FrameInputStream _is;
    private long _length;
    private boolean _isFinal = true;

    public WebSocketInputStream(FrameInputStream is) {
        this._is = is;
    }

    public void init() {
        this._isFinal = this._is.isFinal();
        this._length = this._is.getLength();
    }

    public boolean startBinaryMessage() throws IOException {
        while (!this._isFinal || this._length > 0L) {
            this.skip(this._length);
        }
        if (!this._is.readFrameHeader()) {
            return false;
        }
        if (this._is.getOpcode() != 2) {
            throw new UnsupportedOperationException("Expected binary at: OP:" + this._is.getOpcode());
        }
        this.init();
        return true;
    }

    public long getLength() {
        return this._is.getLength();
    }

    public int available() {
        if (this._length > 0L) {
            return (int)Math.max(Integer.MAX_VALUE, this._length);
        }
        if (this._isFinal) {
            return -1;
        }
        return 1;
    }

    public int read() throws IOException {
        while (this._length == 0L && !this._isFinal) {
            if (!this._is.readFrameHeader()) {
                return -1;
            }
            if (this._is.getOpcode() == 8) {
                return -1;
            }
            if (this._is.getOpcode() != 0) {
                this._is.closeError(1002, "illegal fragment");
                return -1;
            }
            this._length = this._is.getLength();
            this._isFinal = this._is.isFinal();
        }
        if (this._length > 0L) {
            int ch = this._is.read();
            --this._length;
            return ch;
        }
        return -1;
    }

    public int read(byte[] buffer, int offset, int length) throws IOException {
        FrameInputStream is = this._is;
        while (this._length == 0L && !this._isFinal) {
            if (!is.readFrameHeader()) {
                return -1;
            }
            int opcode = is.getOpcode();
            if (opcode == 8) {
                return -1;
            }
            if (opcode != 0) {
                is.closeError(1002, "illegal fragment");
                return -1;
            }
            this._length = is.getLength();
            this._isFinal = is.isFinal();
        }
        if (this._length <= 0L) {
            return -1;
        }
        int sublen = (int)this._length;
        if (length < sublen) {
            sublen = length;
        }
        if ((sublen = is.read(buffer, offset, sublen)) < 0) {
            return -1;
        }
        this._length -= (long)sublen;
        return sublen;
    }

    public long skip(long length) throws IOException {
        long skipLength = 0L;
        do {
            long sublen;
            if (this._length == 0L && !this._isFinal) {
                if (!this._is.readFrameHeader()) {
                    return -1L;
                }
                this._length = this._is.getLength();
                this._isFinal = this._is.isFinal();
            }
            if (length < (sublen = this._length)) {
                sublen = length;
            }
            this._length -= sublen;
            skipLength += sublen;
        } while (length > 0L && (this._length > 0L || !this._isFinal));
        return skipLength;
    }

    public void close() throws IOException {
        while (this._length > 0L || !this._isFinal) {
            this.skip(this._length);
        }
    }
}

