/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.servlet;

import com.caucho.config.ConfigException;
import com.caucho.quercus.QuercusContext;
import com.caucho.quercus.QuercusRuntimeException;
import com.caucho.quercus.lib.db.QuercusDataSource;
import com.caucho.quercus.module.QuercusModule;
import com.caucho.quercus.servlet.PhpClassConfig;
import com.caucho.quercus.servlet.QuercusServletImpl;
import com.caucho.util.CurrentTime;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;

public class QuercusServlet
extends HttpServlet {
    private static final L10N L = new L10N(QuercusServlet.class);
    private static final Logger log = Logger.getLogger(QuercusServlet.class.getName());
    private QuercusContext _quercus;
    private QuercusServletImpl _impl;
    private boolean _isCompile;
    private boolean _isLazyCompile = true;
    private boolean _isCompileFailover = true;
    private double _profileProbability;
    private boolean _isRequireSource = true;
    private DataSource _database;
    private boolean _isStrict;
    private boolean _isLooseParse = true;
    private int _pageCacheSize = -1;
    private int _regexpCacheSize = -1;
    private boolean _isConnectionPool = true;
    private String _iniPath;
    private String _scriptEncoding;
    private String _mysqlVersion;
    private String _phpVersion;
    private File _licenseDirectory;
    private Long _dependencyCheckInterval;
    private ArrayList<QuercusModule> _moduleList = new ArrayList();
    private ArrayList<PhpClassConfig> _classList = new ArrayList();
    private ArrayList<PhpClassConfig> _classImplList = new ArrayList();
    private ArrayList<PhpIni> _phpIniList = new ArrayList();
    private ArrayList<ServerEnv> _serverEnvList = new ArrayList();

    public QuercusServlet() {
        QuercusServlet.checkJavaVersion();
    }

    protected QuercusServletImpl getQuercusServlet(boolean isResin) {
        Constructor<?> cons;
        Class<?> cls;
        QuercusServletImpl impl = null;
        if (isResin) {
            try {
                cls = Class.forName("com.caucho.quercus.servlet.ProResinQuercusServlet");
                cons = cls.getConstructor(File.class);
                impl = (QuercusServletImpl)cons.newInstance(this._licenseDirectory);
            }
            catch (Exception e) {
                log.log(Level.FINEST, e.getMessage(), e);
            }
        }
        if (impl == null) {
            try {
                cls = Class.forName("com.caucho.quercus.servlet.ProQuercusServlet");
                cons = cls.getConstructor(File.class);
                impl = (QuercusServletImpl)cons.newInstance(this._licenseDirectory);
            }
            catch (Exception e) {
                log.log(Level.FINEST, e.getMessage(), e);
            }
        }
        if (impl == null) {
            impl = new QuercusServletImpl();
        }
        return impl;
    }

    private static void checkJavaVersion() {
        String version = System.getProperty("java.version");
        if (version.startsWith("1.3.") || version.startsWith("1.4.")) {
            throw new QuercusRuntimeException(L.l("Quercus requires JDK 1.5 or higher."));
        }
    }

    public void setCompile(String isCompile) throws ConfigException {
        if ("true".equals(isCompile) || "".equals(isCompile)) {
            this._isCompile = true;
            this._isLazyCompile = false;
        } else if ("false".equals(isCompile)) {
            this._isCompile = false;
            this._isLazyCompile = false;
        } else if ("lazy".equals(isCompile)) {
            this._isLazyCompile = true;
        } else {
            throw new ConfigException(L.l("'{0}' is an unknown compile value. Values are 'true', 'false', or 'lazy'.", (Object)isCompile));
        }
    }

    public void setCompileFailover(String isCompileFailover) throws ConfigException {
        if ("true".equals(isCompileFailover) || "".equals(isCompileFailover)) {
            this._isCompileFailover = true;
        } else if ("false".equals(isCompileFailover)) {
            this._isCompileFailover = false;
        } else {
            throw new ConfigException(L.l("'{0}' is an unknown compile-failover value.  Values are 'true' or 'false'.", (Object)isCompileFailover));
        }
    }

    public void setProfileProbability(double probability) throws ConfigException {
        this._profileProbability = probability;
    }

    public void setRequireSource(boolean isRequireSource) {
        this._isRequireSource = isRequireSource;
    }

    public void setDependencyCheckInterval(long ms) {
        this._dependencyCheckInterval = ms;
    }

    public void setDatabase(DataSource database) throws ConfigException {
        if (database == null) {
            throw new ConfigException(L.l("invalid database"));
        }
        this._database = database;
    }

    public void setStrict(boolean isStrict) {
        this._isStrict = isStrict;
    }

    public void setLooseParse(boolean isLooseParse) {
        this._isLooseParse = isLooseParse;
    }

    public void setPageCacheEntries(int entries) {
        this._pageCacheSize = entries;
    }

    public void setPageCacheSize(int size) {
        this._pageCacheSize = size;
    }

    public void setRegexpCacheSize(int size) {
        this._regexpCacheSize = size;
    }

    public void setConnectionPool(boolean isEnable) {
        this._isConnectionPool = isEnable;
    }

    public void addModule(QuercusModule module) throws ConfigException {
        this._moduleList.add(module);
    }

    public void addClass(PhpClassConfig classConfig) throws ConfigException {
        this._classList.add(classConfig);
    }

    public void addImplClass(PhpClassConfig classConfig) throws ConfigException {
        this._classImplList.add(classConfig);
    }

    public PhpIni createPhpIni() throws ConfigException {
        PhpIni ini = new PhpIni();
        this._phpIniList.add(ini);
        return ini;
    }

    public ServerEnv createServerEnv() throws ConfigException {
        ServerEnv ini = new ServerEnv();
        this._serverEnvList.add(ini);
        return ini;
    }

    public void setIniFile(String relPath) {
        this._iniPath = relPath;
    }

    public void setScriptEncoding(String encoding) throws ConfigException {
        this._scriptEncoding = encoding;
    }

    public void setMysqlVersion(String version) {
        this._mysqlVersion = version;
    }

    public void setPhpVersion(String version) {
        this._phpVersion = version;
    }

    public void setLicenseDirectory(String relPath) {
        String dir = relPath.startsWith("/") || relPath.contains(":") ? relPath : this.getServletContext().getRealPath(relPath);
        if (dir != null) {
            this._licenseDirectory = new File(dir);
        }
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        Enumeration<String> paramNames = config.getInitParameterNames();
        while (paramNames.hasMoreElements()) {
            String paramName = paramNames.nextElement();
            String paramValue = config.getInitParameter(paramName);
            this.setInitParam(paramName, paramValue);
        }
        this.initImpl(config);
    }

    protected void setInitParam(String paramName, String paramValue) throws ServletException {
        if ("compile".equals(paramName)) {
            this.setCompile(paramValue);
        } else if ("database".equals(paramName)) {
            this.setJndiDatabase(paramValue);
        } else if ("ini-file".equals(paramName)) {
            this.setIniFile(paramValue);
        } else if ("mysql-version".equals(paramName)) {
            this.setMysqlVersion(paramValue);
        } else if ("php-version".equals(paramName)) {
            this.setPhpVersion(paramValue);
        } else if ("script-encoding".equals(paramName)) {
            this.setScriptEncoding(paramValue);
        } else if ("strict".equals(paramName)) {
            this.setStrict("true".equals(paramValue));
        } else if ("loose-parse".equals(paramName)) {
            this.setLooseParse("true".equals(paramValue));
        } else if ("page-cache-entries".equals(paramName) || "page-cache-size".equals(paramName)) {
            this.setPageCacheSize(Integer.parseInt(paramValue));
        } else if ("regexp-cache-size".equals(paramName)) {
            this.setRegexpCacheSize(Integer.parseInt(paramValue));
        } else if ("connection-pool".equals(paramName)) {
            this.setConnectionPool("true".equals(paramValue));
        } else if ("require-source".equals(paramName)) {
            this.setRequireSource("true".equals(paramValue));
        } else if ("dependency-check-interval".equals(paramName)) {
            this.setDependencyCheckInterval(Long.parseLong(paramValue));
        } else if ("license-directory".equals(paramName)) {
            this.setLicenseDirectory(paramValue);
        } else {
            throw new ServletException(L.l("'{0}' is not a recognized init-param", (Object)paramName));
        }
    }

    private void setJndiDatabase(String value) throws ServletException {
        try {
            DataSource ds;
            InitialContext ic = new InitialContext();
            if (!value.startsWith("java:comp")) {
                try {
                    ds = (DataSource)ic.lookup("java:comp/env/" + value);
                }
                catch (Exception e) {
                    ds = (DataSource)ic.lookup(value);
                }
            } else {
                ds = (DataSource)ic.lookup(value);
            }
            if (ds == null) {
                throw new ServletException(L.l("database '{0}' is not valid", (Object)value));
            }
            this.setDatabase(new QuercusDataSource(ds, null, null, false));
        }
        catch (NamingException e) {
            throw new ServletException(e);
        }
    }

    private void initImpl(ServletConfig config) throws ServletException {
        long start = CurrentTime.getCurrentTime();
        Class<?> configClass = config.getClass();
        this._impl = this.getQuercusServlet(configClass.getName().startsWith("com.caucho"));
        log.info(L.l("QuercusServlet starting as {0}", (Object)this._impl.getClass().getSimpleName()));
        QuercusContext quercus = this.getQuercus();
        quercus.setCompile(this._isCompile);
        quercus.setLazyCompile(this._isLazyCompile);
        quercus.setCompileFailover(this._isCompileFailover);
        quercus.setProfileProbability(this._profileProbability);
        quercus.setRequireSource(this._isRequireSource);
        quercus.setDatabase(this._database);
        quercus.setStrict(this._isStrict);
        quercus.setLooseParse(this._isLooseParse);
        quercus.setPageCacheSize(this._pageCacheSize);
        quercus.setRegexpCacheSize(this._regexpCacheSize);
        quercus.setConnectionPool(this._isConnectionPool);
        if (this._dependencyCheckInterval != null) {
            quercus.setDependencyCheckInterval(this._dependencyCheckInterval);
        }
        if (this._iniPath != null) {
            Path path = null;
            if (this._iniPath.startsWith("/") || this._iniPath.contains(":")) {
                path = this.getQuercus().getPwd().lookup(this._iniPath);
            } else {
                String realPath = this.getServletContext().getRealPath(this._iniPath);
                if (realPath != null) {
                    path = this.getQuercus().getPwd().lookup(realPath);
                }
            }
            if (path != null) {
                quercus.setIniFile(path);
            }
        } else {
            String realPath = this.getServletContext().getRealPath("WEB-INF/php.ini");
            if (realPath != null) {
                quercus.setIniFile(this.getQuercus().getPwd().lookup(realPath));
            }
        }
        if (this._scriptEncoding != null) {
            quercus.setScriptEncoding(this._scriptEncoding);
        }
        if (this._mysqlVersion != null) {
            quercus.setMysqlVersion(this._mysqlVersion);
        }
        if (this._phpVersion != null) {
            quercus.setPhpVersion(this._phpVersion);
        }
        for (QuercusModule module : this._moduleList) {
            quercus.addInitModule(module);
        }
        for (PhpClassConfig cls : this._classList) {
            quercus.addJavaClass(cls.getName(), cls.getType());
        }
        for (PhpClassConfig cls : this._classImplList) {
            quercus.addImplClass(cls.getName(), cls.getType());
        }
        for (PhpIni ini : this._phpIniList) {
            for (Map.Entry<String, String> entry : ini.getPropertyMap().entrySet()) {
                quercus.setIni(entry.getKey(), entry.getValue());
            }
        }
        for (ServerEnv serverEnv : this._serverEnvList) {
            for (Map.Entry<String, String> entry : serverEnv.getPropertyMap().entrySet()) {
                quercus.setServerEnv(entry.getKey(), entry.getValue());
            }
        }
        this._impl.init(config);
        long end = CurrentTime.getCurrentTime();
        log.info(L.l("Quercus finished initialization in {0}ms", end - start));
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this._impl.service(request, response);
    }

    private QuercusContext getQuercus() {
        if (this._quercus == null) {
            this._quercus = this._impl.getQuercus();
        }
        return this._quercus;
    }

    public void destroy() {
        this._impl.destroy();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ServerEnv {
        private HashMap<String, String> _propertyMap = new HashMap();

        public void setProperty(String key, String value) {
            this._propertyMap.put(key, value);
        }

        public HashMap<String, String> getPropertyMap() {
            return this._propertyMap;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PhpIni {
        private HashMap<String, String> _propertyMap = new HashMap();

        public void setProperty(String key, String value) {
            this._propertyMap.put(key, value);
        }

        public HashMap<String, String> getPropertyMap() {
            return this._propertyMap;
        }
    }
}

