/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.servlet;

import com.caucho.quercus.GoogleQuercus;
import com.caucho.quercus.QuercusRequestAdapter;
import com.caucho.quercus.servlet.api.QuercusHttpServletRequest;
import com.caucho.quercus.servlet.api.QuercusHttpServletRequestImpl;
import com.caucho.util.Base64;
import com.caucho.util.L10N;
import com.caucho.util.LruCache;
import com.caucho.util.QDate;
import com.caucho.vfs.FilePath;
import com.caucho.vfs.GoogleMergePath;
import com.caucho.vfs.Path;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.GenericServlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class GoogleStaticFileServlet
extends GenericServlet {
    private static final L10N L = new L10N(GoogleStaticFileServlet.class);
    private static final Logger log = Logger.getLogger(GoogleStaticFileServlet.class.getName());
    private String _gsBucket;
    private Path _pwd;
    private ServletContext _context;
    private LruCache<String, CacheEntry> _cache;

    public void init(ServletConfig config) throws ServletException {
        String iniPath;
        super.init(config);
        this._context = config.getServletContext();
        this._cache = new LruCache(1024);
        this._pwd = new FilePath(this._context.getRealPath("/"));
        String mode = System.getProperty("com.google.appengine.tools.development.ApplicationPreparationMode");
        boolean isGsDisabled = "true".equals(mode);
        if (!isGsDisabled && (iniPath = this.getInitParameter("ini-file")) != null) {
            String realPath = this._context.getRealPath(iniPath);
            GoogleQuercus quercus = new GoogleQuercus();
            quercus.setIniFile(this._pwd.lookup(realPath));
            this._gsBucket = quercus.getIniString("google.cloud_storage_bucket");
            if (this._gsBucket != null) {
                this._pwd = new GoogleMergePath(this._pwd, this._gsBucket, true);
            }
        }
        log.log(Level.INFO, L.l("{0} initialized with bucket={1},pwd={2}", (Object)this.getClass().getSimpleName(), (Object)this._gsBucket, (Object)this._pwd.getUserPath()));
    }

    public void service(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        QuercusHttpServletRequestImpl req = new QuercusHttpServletRequestImpl((HttpServletRequest)request);
        HttpServletResponse res = (HttpServletResponse)response;
        String uri = QuercusRequestAdapter.getPageURI(req);
        CacheEntry entry = this._cache.get(uri);
        if (entry == null) {
            Path path = this.getPath(req);
            String relPath = path.getUserPath();
            String mimeType = this._context.getMimeType(uri);
            entry = new CacheEntry(path, relPath, mimeType);
            this._cache.put(uri, entry);
        } else if (entry.isModified()) {
            entry = new CacheEntry(entry.getPath(), entry.getRelPath(), entry.getMimeType());
            this._cache.put(uri, entry);
        }
        String ifMatch = req.getHeader("If-None-Match");
        String etag = entry.getEtag();
        if (ifMatch != null && ifMatch.equals(etag)) {
            res.addHeader("ETag", etag);
            res.sendError(304);
            return;
        }
        String lastModified = entry.getLastModifiedString();
        if (ifMatch == null) {
            String ifModified = req.getHeader("If-Modified-Since");
            boolean isModified = true;
            if (ifModified != null) {
                if (ifModified.equals(lastModified)) {
                    isModified = false;
                } else {
                    long ifModifiedTime;
                    QDate date = QDate.allocateLocalDate();
                    try {
                        ifModifiedTime = date.parseDate(ifModified);
                    }
                    catch (Exception e) {
                        log.log(Level.FINER, e.toString(), e);
                        ifModifiedTime = 0L;
                    }
                    QDate.freeLocalDate(date);
                    boolean bl = isModified = ifModifiedTime == 0L || ifModifiedTime != entry.getLastModified();
                }
            }
            if (!isModified) {
                if (etag != null) {
                    res.addHeader("ETag", etag);
                }
                res.sendError(304);
                return;
            }
        }
        res.addHeader("ETag", etag);
        res.addHeader("Last-Modified", lastModified);
        String mime = entry.getMimeType();
        if (mime != null) {
            res.setContentType(mime);
        }
        res.setContentLength((int)entry.getLength());
        String method = req.getMethod();
        if (method.equalsIgnoreCase("HEAD")) {
            return;
        }
        Path path = entry.getPath();
        if (path.isDirectory()) {
            res.sendError(404);
            return;
        }
        if (!path.canRead()) {
            res.sendError(404);
            return;
        }
        ServletOutputStream os = response.getOutputStream();
        path.writeToStream(os);
    }

    protected Path getPath(QuercusHttpServletRequest req) {
        Path pwd = this._pwd.copy();
        StringBuilder sb = new StringBuilder();
        String servletPath = QuercusRequestAdapter.getPageServletPath(req);
        if (servletPath.startsWith("/")) {
            sb.append(servletPath, 1, servletPath.length());
        } else {
            sb.append(servletPath);
        }
        String pathInfo = QuercusRequestAdapter.getPagePathInfo(req);
        if (pathInfo != null) {
            sb.append(pathInfo);
        }
        String scriptPath = sb.toString();
        Path path = pwd.lookupChild(scriptPath);
        return path;
    }

    static class CacheEntry {
        private Path _path;
        private boolean _isDirectory;
        private boolean _canRead;
        private long _length;
        private long _lastModified = -2401057700593545203L;
        private String _relPath;
        private String _etag;
        private String _lastModifiedString;
        private String _mimeType;

        CacheEntry(Path path, String relPath, String mimeType) {
            this._path = path;
            this._relPath = relPath;
            this._mimeType = mimeType;
            this.init();
        }

        Path getPath() {
            return this._path;
        }

        boolean canRead() {
            return this._canRead;
        }

        boolean isDirectory() {
            return this._isDirectory;
        }

        long getLength() {
            return this._length;
        }

        String getRelPath() {
            return this._relPath;
        }

        String getEtag() {
            return this._etag;
        }

        long getLastModified() {
            return this._lastModified;
        }

        String getLastModifiedString() {
            return this._lastModifiedString;
        }

        String getMimeType() {
            return this._mimeType;
        }

        boolean isModified() {
            this._path.clearStatusCache();
            long lastModified = this._path.getLastModified();
            long length = this._path.getLength();
            return lastModified != this._lastModified || length != this._length;
        }

        private void init() {
            long lastModified = this._path.getLastModified();
            long length = this._path.getLength();
            this._lastModified = lastModified;
            this._length = length;
            this._canRead = this._path.canRead();
            this._isDirectory = this._path.isDirectory();
            StringBuilder sb = new StringBuilder();
            sb.append('\"');
            Base64.encode(sb, this._path.getCrc64());
            sb.append('\"');
            this._etag = sb.toString();
            QDate cal = QDate.allocateGmtDate();
            cal.setGMTTime(lastModified);
            this._lastModifiedString = cal.printDate();
            QDate.freeGmtDate(cal);
            if (lastModified == 0L) {
                this._canRead = false;
                this._isDirectory = false;
            }
        }
    }
}

