/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.servlet;

import com.caucho.quercus.GoogleQuercus;
import com.caucho.quercus.QuercusContext;
import com.caucho.quercus.servlet.QuercusServletImpl;
import com.caucho.util.L10N;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

public class GoogleQuercusServletImpl
extends QuercusServletImpl {
    private static final L10N L = new L10N(GoogleQuercusServletImpl.class);
    private static final Logger log = Logger.getLogger(GoogleQuercusServletImpl.class.getName());
    protected final String _gsBucket;

    public GoogleQuercusServletImpl(String gsBucket) {
        this._gsBucket = gsBucket;
    }

    protected QuercusContext getQuercus() {
        if (this._quercus == null) {
            this._quercus = new GoogleQuercus();
            if (this._gsBucket != null) {
                this._quercus.setIni("google.cloud_storage_bucket", this._gsBucket);
            }
        }
        return this._quercus;
    }

    protected void handleThrowable(HttpServletResponse response, Throwable e) throws IOException, ServletException {
        log.log(Level.WARNING, e.toString(), e);
        ServletOutputStream os = response.getOutputStream();
        WriteStream out = Vfs.openWrite(os);
        out.println(e);
        out.close();
    }
}

