/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.program;

import com.caucho.quercus.Location;
import com.caucho.quercus.QuercusException;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.EnvVar;
import com.caucho.quercus.env.EnvVarImpl;
import com.caucho.quercus.env.NullThisValue;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.Var;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.expr.ExprFactory;
import com.caucho.quercus.expr.ParamRequiredExpr;
import com.caucho.quercus.function.AbstractFunction;
import com.caucho.quercus.program.Arg;
import com.caucho.quercus.program.ClassDef;
import com.caucho.quercus.program.FunctionInfo;
import com.caucho.quercus.statement.Statement;
import java.util.HashMap;
import java.util.Map;

public class Function
extends AbstractFunction {
    protected final FunctionInfo _info;
    protected final boolean _isReturnsReference;
    protected final String _name;
    protected final Arg[] _args;
    protected final Statement _statement;
    protected boolean _hasReturn;
    protected String _comment;
    protected Arg[] _closureUseArgs;

    public Function(ExprFactory exprFactory, Location location, String name, FunctionInfo info, Arg[] args, Statement[] statements) {
        super(location);
        this._name = name.intern();
        this._info = info;
        this._info.setFunction(this);
        this._isReturnsReference = info.isReturnsReference();
        this._args = new Arg[args.length];
        System.arraycopy(args, 0, this._args, 0, args.length);
        this._statement = exprFactory.createBlock(location, statements);
        this.setGlobal(info.isPageStatic());
        this.setClosure(info.isClosure());
        this._isStatic = true;
    }

    public String getName() {
        return this._name;
    }

    public ClassDef getDeclaringClass() {
        return this._info.getDeclaringClass();
    }

    public FunctionInfo getInfo() {
        return this._info;
    }

    protected boolean isMethod() {
        return this.getDeclaringClassName() != null;
    }

    public String getDeclaringClassName() {
        ClassDef declaringClass = this._info.getDeclaringClass();
        if (declaringClass != null) {
            return declaringClass.getName();
        }
        return null;
    }

    public Arg[] getArgs(Env env) {
        return this._args;
    }

    public Arg[] getClosureUseArgs() {
        return this._closureUseArgs;
    }

    public void setClosureUseArgs(Arg[] useArgs) {
        this._closureUseArgs = useArgs;
    }

    public boolean isObjectMethod() {
        return false;
    }

    public boolean isReturnsReference(Env env) {
        return this._isReturnsReference;
    }

    public void setComment(String comment) {
        this._comment = comment;
    }

    public String getComment() {
        return this._comment;
    }

    public Value execute(Env env) {
        return null;
    }

    public Value[] evalArguments(Env env, Expr fun, Expr[] args) {
        Value[] values = new Value[args.length];
        for (int i = 0; i < args.length; ++i) {
            Arg arg = null;
            if (i < this._args.length) {
                arg = this._args[i];
            }
            values[i] = arg == null ? args[i].eval(env).copy() : (arg.isReference() ? args[i].evalVar(env) : args[i].eval(env));
        }
        return values;
    }

    public Value call(Env env, Expr[] args) {
        return this.callImpl(env, args, false);
    }

    public Value callCopy(Env env, Expr[] args) {
        return this.callImpl(env, args, false);
    }

    public Value callRef(Env env, Expr[] args) {
        return this.callImpl(env, args, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Value callImpl(Env env, Expr[] args, boolean isRef) {
        Arg arg;
        int i;
        HashMap<StringValue, EnvVar> map = new HashMap<StringValue, EnvVar>();
        Value[] values = new Value[args.length];
        for (i = 0; i < args.length; ++i) {
            arg = null;
            if (i < this._args.length) {
                arg = this._args[i];
            }
            if (arg == null) {
                values[i] = args[i].eval(env).copy();
                continue;
            }
            if (arg.isReference()) {
                values[i] = args[i].evalVar(env);
                map.put(arg.getName(), new EnvVarImpl(values[i].toLocalVarDeclAsRef()));
                continue;
            }
            values[i] = args[i].eval(env);
            Var var = values[i].toVar();
            map.put(arg.getName(), new EnvVarImpl(var));
            values[i] = var.toValue();
        }
        for (i = args.length; i < this._args.length; ++i) {
            arg = this._args[i];
            Expr defaultExpr = arg.getDefault();
            if (defaultExpr == null) {
                return env.error("expected default expression");
            }
            if (arg.isReference()) {
                map.put(arg.getName(), new EnvVarImpl(defaultExpr.evalVar(env).toVar()));
                continue;
            }
            map.put(arg.getName(), new EnvVarImpl(defaultExpr.eval(env).copy().toVar()));
        }
        Map<StringValue, EnvVar> oldMap = env.pushEnv(map);
        Value[] oldArgs = env.setFunctionArgs(values);
        Value oldThis = this.isStatic() ? env.setThis(env.getCallingClass()) : env.getThis();
        try {
            Value value = this._statement.execute(env);
            if (value != null) {
                Value value2 = value;
                return value2;
            }
            if (this._info.isReturnsReference()) {
                Var var = new Var();
                return var;
            }
            NullValue nullValue = NullValue.NULL;
            return nullValue;
        }
        finally {
            env.restoreFunctionArgs(oldArgs);
            env.popEnv(oldMap);
            env.setThis(oldThis);
        }
    }

    public Value call(Env env, Value[] args) {
        return this.callImpl(env, args, false, null, null);
    }

    public Value callCopy(Env env, Value[] args) {
        return this.callImpl(env, args, false, null, null).copy();
    }

    public Value callRef(Env env, Value[] args) {
        return this.callImpl(env, args, true, null, null);
    }

    public Value callClosure(Env env, Value[] args, Value[] useArgs) {
        return this.callImpl(env, args, false, this.getClosureUseArgs(), useArgs).copy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value callImpl(Env env, Value[] args, boolean isRef, Arg[] useParams, Value[] useArgs) {
        Arg arg;
        int i;
        HashMap<StringValue, EnvVar> map = new HashMap<StringValue, EnvVar>(8);
        if (useParams != null) {
            for (i = 0; i < useParams.length; ++i) {
                map.put(useParams[i].getName(), new EnvVarImpl(useArgs[i].toVar()));
            }
        }
        for (i = 0; i < args.length; ++i) {
            arg = null;
            if (i < this._args.length) {
                arg = this._args[i];
            }
            if (arg == null) continue;
            if (arg.isReference()) {
                map.put(arg.getName(), new EnvVarImpl(args[i].toLocalVarDeclAsRef()));
                continue;
            }
            Var var = args[i].toLocalVar();
            if (arg.getExpectedClass() != null && arg.getDefault() instanceof ParamRequiredExpr) {
                env.checkTypeHint(var, arg.getExpectedClass(), arg.getName().toString(), this.getName());
            }
            map.put(arg.getName(), new EnvVarImpl(var));
        }
        for (i = args.length; i < this._args.length; ++i) {
            arg = this._args[i];
            Expr defaultExpr = arg.getDefault();
            try {
                if (defaultExpr == null) {
                    return env.error("expected default expression");
                }
                if (arg.isReference()) {
                    map.put(arg.getName(), new EnvVarImpl(defaultExpr.evalVar(env).toVar()));
                    continue;
                }
                map.put(arg.getName(), new EnvVarImpl(defaultExpr.eval(env).toLocalVar()));
                continue;
            }
            catch (Exception e) {
                throw new QuercusException(this.getName() + ":arg(" + arg.getName() + ") " + e.getMessage(), e);
            }
        }
        Map<StringValue, EnvVar> oldMap = env.pushEnv(map);
        Value[] oldArgs = env.setFunctionArgs(args);
        Value oldThis = this._info.isMethod() ? env.getThis() : env.setThis(NullThisValue.NULL);
        try {
            Value value = this._statement.execute(env);
            if (value == null) {
                if (this._isReturnsReference) {
                    Var var = new Var();
                    return var;
                }
                NullValue nullValue = NullValue.NULL;
                return nullValue;
            }
            if (this._isReturnsReference) {
                Value value2 = value;
                return value2;
            }
            Value value3 = value.toValue().copy();
            return value3;
        }
        finally {
            env.restoreFunctionArgs(oldArgs);
            env.popEnv(oldMap);
            env.setThis(oldThis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value callMethod(Env env, QuercusClass qClass, Value qThis, Value[] args) {
        if (this.isStatic()) {
            qThis = qClass;
        }
        Value oldThis = env.setThis(qThis);
        QuercusClass oldClass = env.setCallingClass(qClass);
        try {
            Value value = this.callImpl(env, args, false, null, null);
            return value;
        }
        finally {
            env.setThis(oldThis);
            env.setCallingClass(oldClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value callMethodRef(Env env, QuercusClass qClass, Value qThis, Value[] args) {
        Value oldThis = env.setThis(qThis);
        QuercusClass oldClass = env.setCallingClass(qClass);
        try {
            Value value = this.callImpl(env, args, true, null, null);
            return value;
        }
        finally {
            env.setThis(oldThis);
            env.setCallingClass(oldClass);
        }
    }

    private boolean isVariableArgs() {
        return this._info.isVariableArgs() || this._args.length > 5;
    }

    private boolean isVariableMap() {
        return this._info.isUsesSymbolTable() || this._info.isVariableVar();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._name + "]";
    }
}

