/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.profile;

import com.caucho.quercus.profile.ProfileItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileMethod {
    private final int _id;
    private final String _name;
    private long _count;
    private long _selfMicros;
    private long _totalMicros;
    private ArrayList<ProfileItem> _parentList = new ArrayList();
    private ArrayList<ProfileItem> _childList = new ArrayList();

    public ProfileMethod(int id, String name) {
        this._id = id;
        this._name = name;
    }

    public int getId() {
        return this._id;
    }

    public String getName() {
        return this._name;
    }

    public long getCount() {
        return this._count;
    }

    public long getTotalMicros() {
        return this._totalMicros;
    }

    public long getSelfMicros() {
        return this._selfMicros;
    }

    public ArrayList<ProfileItem> getParentItems() {
        return this._parentList;
    }

    public ArrayList<ProfileItem> getParentItemsByMicros() {
        ArrayList<ProfileItem> parentList = new ArrayList<ProfileItem>(this._parentList);
        Collections.sort(parentList, new ItemMicrosComparator());
        return parentList;
    }

    public ArrayList<ProfileItem> getChildItems() {
        return this._childList;
    }

    public ArrayList<ProfileItem> getChildItemsByMicros() {
        ArrayList<ProfileItem> childList = new ArrayList<ProfileItem>(this._childList);
        Collections.sort(childList, new ItemMicrosComparator());
        return childList;
    }

    public void addParent(ProfileItem item) {
        this._parentList.add(item);
        this._count += item.getCount();
        this._totalMicros += item.getMicros();
        this._selfMicros += item.getMicros();
    }

    public void addChild(ProfileItem item) {
        this._childList.add(item);
        this._selfMicros -= item.getMicros();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._name + ",count=" + this._count + ",self-micros=" + this._selfMicros + ",total-micros=" + this._totalMicros + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ItemMicrosComparator
    implements Comparator<ProfileItem> {
        ItemMicrosComparator() {
        }

        @Override
        public int compare(ProfileItem a, ProfileItem b) {
            long delta = b.getMicros() - a.getMicros();
            if (delta == 0L) {
                return 0;
            }
            if (delta < 0L) {
                return -1;
            }
            return 1;
        }
    }
}

