/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.mysql;

import com.caucho.quercus.lib.db.QuercusResultSetMetaData;
import com.caucho.quercus.mysql.MysqlColumn;
import com.caucho.util.L10N;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MysqlResultSetMetaData
implements QuercusResultSetMetaData {
    private static final Logger log = Logger.getLogger(MysqlResultSetMetaData.class.getName());
    private static final L10N L = new L10N(MysqlResultSetMetaData.class);
    private int _columnCount;
    private ArrayList<MysqlColumn> _columns = new ArrayList();

    MysqlResultSetMetaData() {
    }

    @Override
    public int getColumnCount() {
        return this._columnCount;
    }

    public void setColumnCount(int columnCount) {
        this._columnCount = columnCount;
        while (this._columns.size() < columnCount) {
            this._columns.add(new MysqlColumn());
        }
    }

    public ArrayList<MysqlColumn> getColumns() {
        return this._columns;
    }

    public MysqlColumn getColumn(int column) {
        if (column < 1 || this._columnCount < column) {
            throw new IllegalArgumentException(L.l("{0} is an invalid column [1-{1}]", column, this._columnCount));
        }
        return this._columns.get(column - 1);
    }

    @Override
    public boolean isAutoIncrement(int column) {
        return this.getColumn(column).isAutoIncrement();
    }

    @Override
    public boolean isCaseSensitive(int column) {
        return true;
    }

    @Override
    public boolean isSearchable(int column) {
        return false;
    }

    @Override
    public boolean isCurrency(int column) {
        return false;
    }

    @Override
    public int isNullable(int column) {
        if (this.getColumn(column).isNotNull()) {
            return 0;
        }
        return 1;
    }

    @Override
    public int getColumnDisplaySize(int column) {
        return this.getColumn(column).getPrecision();
    }

    @Override
    public String getColumnLabel(int column) {
        return this.getColumnName(column);
    }

    @Override
    public String getColumnName(int column) {
        return this.getColumn(column).getName();
    }

    public String getColumnOrigName(int column) {
        return this.getColumn(column).getOrigName();
    }

    public String getColumnSchema(int column) {
        return this.getColumn(column).getSchema();
    }

    @Override
    public boolean isSigned(int column) {
        return !this.getColumn(column).isUnsigned();
    }

    @Override
    public int getPrecision(int column) {
        return this.getColumn(column).getPrecision();
    }

    @Override
    public int getScale(int column) {
        return this.getColumn(column).getScale();
    }

    @Override
    public String getSchemaName(int column) {
        return this.getColumn(column).getSchema();
    }

    @Override
    public String getTableName(int column) {
        return this.getColumn(column).getTable();
    }

    public String getOrigTableName(int column) {
        return this.getColumn(column).getOrigTable();
    }

    @Override
    public String getCatalogName(int column) {
        return this.getColumn(column).getCatalog();
    }

    @Override
    public int getColumnType(int column) {
        return this.getColumn(column).getSQLType();
    }

    @Override
    public String getColumnTypeName(int column) {
        return this.getColumn(column).getTypeName();
    }

    @Override
    public boolean isReadOnly(int column) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isWritable(int column) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isDefinitelyWritable(int column) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getColumnClassName(int column) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isBlob(int column) {
        return this.getColumn(column).isBlob();
    }

    @Override
    public boolean isMultipleKey(int column) {
        return this.getColumn(column).isMultipleKey();
    }

    @Override
    public boolean isZeroFill(int column) {
        return this.getColumn(column).isZeroFill();
    }

    @Override
    public boolean isUnsigned(int column) {
        return this.getColumn(column).isUnsigned();
    }

    @Override
    public boolean isUniqueKey(int column) {
        return this.getColumn(column).isUniqueKey();
    }

    @Override
    public boolean isPrimaryKey(int column) {
        return this.getColumn(column).isPrimaryKey();
    }

    @Override
    public boolean isNotNull(int column) {
        return this.getColumn(column).isNotNull();
    }

    @Override
    public int getLength(int column) {
        return this.getColumn(column).getLength();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }
}

