/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.marshal;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.marshal.Marshal;

public class LongValueMarshal
extends Marshal {
    public static final Marshal MARSHAL = new LongValueMarshal();

    public boolean isReadOnly() {
        return true;
    }

    public boolean isValue() {
        return true;
    }

    public Object marshal(Env env, Expr expr, Class expectedClass) {
        return expr.eval(env).toLongValue();
    }

    public Object marshal(Env env, Value value, Class expectedClass) {
        return value.toLongValue();
    }

    public Value unmarshal(Env env, Object value) {
        if (value instanceof LongValue) {
            return (LongValue)value;
        }
        if (value instanceof Value) {
            return ((Value)value).toLongValue();
        }
        return null;
    }

    protected int getMarshalingCostImpl(Value argValue) {
        if (argValue instanceof LongValue) {
            return 0;
        }
        if (argValue.isLongConvertible()) {
            return 301;
        }
        if (argValue.isDoubleConvertible()) {
            return 305;
        }
        return 400;
    }

    public Class getExpectedClass() {
        return LongValue.class;
    }
}

