/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.marshal;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.marshal.Marshal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaArrayMarshal
extends Marshal {
    private Class<?> _expectedClass;

    public JavaArrayMarshal() {
        this._expectedClass = Object[].class;
    }

    public JavaArrayMarshal(Class<?> expectedClass) {
        this._expectedClass = expectedClass;
    }

    @Override
    public Object marshal(Env env, Expr expr, Class expectedClass) {
        return this.marshal(env, expr.eval(env), expectedClass);
    }

    @Override
    public Object marshal(Env env, Value value, Class expectedClass) {
        Class<?> componentType = expectedClass.getComponentType();
        Object array = value.valuesToArray(env, componentType);
        return array;
    }

    @Override
    public Value unmarshal(Env env, Object value) {
        return env.wrapJava(value);
    }

    @Override
    protected int getMarshalingCostImpl(Value argValue) {
        if (argValue.isArray()) {
            if (Value[].class.equals(this._expectedClass) || Object[].class.equals(this._expectedClass)) {
                return 100;
            }
            return 300;
        }
        return 400;
    }

    @Override
    public Class getExpectedClass() {
        return this._expectedClass;
    }
}

