/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.string;

import com.caucho.quercus.QuercusModuleException;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.Post;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.ArrayModule;
import com.caucho.quercus.lib.string.StringModule;
import com.caucho.util.L10N;
import com.caucho.vfs.ByteToChar;
import java.io.IOException;

public class StringUtility {
    private static final L10N L = new L10N(StringModule.class);

    public static Value parseStr(Env env, CharSequence str, ArrayValue result, boolean isRef, String encoding, boolean isReplaceSpacesWithUnderscores) {
        return StringUtility.parseStr(env, str, result, isRef, encoding, env.getIniBoolean("magic_quotes_gpc"), isReplaceSpacesWithUnderscores, Env.DEFAULT_QUERY_SEPARATOR_MAP);
    }

    public static Value parseStr(Env env, CharSequence str, ArrayValue result, boolean isRef, String encoding, boolean isMagicQuotes, boolean isReplaceSpacesWithUnderscores, int[] querySeparatorMap) {
        try {
            ByteToChar byteToChar = env.getByteToChar();
            if (encoding != null) {
                byteToChar.setEncoding(encoding);
            }
            int len = str.length();
            for (int i = 0; i < len; ++i) {
                String value;
                char ch = '\u0000';
                byteToChar.clear();
                while (i < len && StringUtility.isSeparator(querySeparatorMap, ch = str.charAt(i))) {
                    ++i;
                }
                while (i < len && (ch = str.charAt(i)) != '=' && !StringUtility.isSeparator(querySeparatorMap, ch)) {
                    i = StringUtility.addQueryChar(byteToChar, str, len, i, ch, querySeparatorMap);
                    ++i;
                }
                String key = byteToChar.getConvertedString();
                byteToChar.clear();
                if (ch == '=') {
                    ++i;
                    while (i < len && !StringUtility.isSeparator(querySeparatorMap, ch = str.charAt(i))) {
                        i = StringUtility.addQueryChar(byteToChar, str, len, i, ch, querySeparatorMap);
                        ++i;
                    }
                    value = byteToChar.getConvertedString();
                } else {
                    value = "";
                }
                if (key.length() == 0) continue;
                if (isRef) {
                    Post.addFormValue(env, result, key, new String[]{value}, isMagicQuotes, isReplaceSpacesWithUnderscores);
                    continue;
                }
                int openBracketIndex = key.indexOf(91);
                int closeBracketIndex = key.indexOf(93);
                if (openBracketIndex == 0) continue;
                if (openBracketIndex > 0) {
                    String arrayName = key.substring(0, openBracketIndex);
                    Value v = env.getVar(arrayName = arrayName.replace('.', '_')).getRawValue();
                    if (v instanceof ArrayValue) {
                        if (closeBracketIndex < 0) {
                            env.warning(L.l("invalid array {0}", (Object)key));
                            return NullValue.NULL;
                        }
                        if (closeBracketIndex > openBracketIndex + 1) {
                            String index = key.substring(key.indexOf(91) + 1, key.indexOf(93));
                            v.put(env.createString(index), env.createString(value));
                            continue;
                        }
                        v.put(env.createString(value));
                        continue;
                    }
                    Post.addFormValue(env, result, key, new String[]{value}, isMagicQuotes, isReplaceSpacesWithUnderscores);
                    continue;
                }
                Post.addFormValue(env, result, key, new String[]{value}, isMagicQuotes, isReplaceSpacesWithUnderscores);
            }
            if (!isRef) {
                ArrayModule.extract(env, result, 0L, null);
            }
            return NullValue.NULL;
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    private static boolean isSeparator(int[] sep, int ch) {
        return ch < sep.length && sep[ch] > 0;
    }

    protected static int addQueryChar(ByteToChar byteToChar, CharSequence str, int len, int i, int ch, int[] querySeparatorMap) throws IOException {
        if (str == null) {
            str = "";
        }
        switch (ch) {
            case 43: {
                byteToChar.addChar(' ');
                return i;
            }
            case 37: {
                char ch2;
                char ch1;
                if (i + 2 < len && (ch1 = str.charAt(i + 1)) != '=' && !StringUtility.isSeparator(querySeparatorMap, ch1) && (ch2 = str.charAt(i + 2)) != '=' && !StringUtility.isSeparator(querySeparatorMap, ch2)) {
                    int d1 = StringModule.hexToDigit(ch1);
                    int d2 = StringModule.hexToDigit(ch2);
                    byteToChar.addByte(d1 * 16 + d2);
                    return i + 2;
                }
                byteToChar.addByte((byte)ch);
                return i;
            }
        }
        byteToChar.addByte((byte)ch);
        return i;
    }

    public static void addQueryValue(Env env, ArrayValue array, String key, String valueStr) {
        if (key == null) {
            key = "";
        }
        if (valueStr == null) {
            valueStr = "";
        }
        StringValue value = env.createString(valueStr);
        int p = key.indexOf(91);
        if (p > 0 && key.endsWith("]")) {
            String index = key.substring(p + 1, key.length() - 1);
            key = key.substring(0, p);
            StringValue keyValue = env.createString(key);
            Value part = array != null ? array.get(keyValue) : env.getVar(keyValue);
            if (!part.isArray()) {
                part = new ArrayValueImpl();
            }
            if (index.equals("")) {
                part.put(value);
            } else {
                part.put(env.createString(index), value);
            }
            if (array != null) {
                array.put(keyValue, part);
            } else {
                env.setVar(key, part);
            }
        } else if (array != null) {
            array.put(env.createString(key), value);
        } else {
            env.setVar(key, value);
        }
    }
}

