/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.simplexml;

import com.caucho.quercus.annotation.EntrySet;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.simplexml.DocumentView;
import com.caucho.quercus.lib.simplexml.ElementView;
import com.caucho.quercus.lib.simplexml.IteratorIndex;
import com.caucho.quercus.lib.simplexml.SimpleHandler;
import com.caucho.quercus.lib.simplexml.SimpleView;
import com.caucho.quercus.lib.simplexml.SimpleXMLNode;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.AbstractMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleXMLElement
extends SimpleXMLNode {
    private static final Logger log = Logger.getLogger(SimpleXMLElement.class.getName());
    private static final L10N L = new L10N(SimpleXMLElement.class);

    protected SimpleXMLElement(QuercusClass cls, SimpleView view) {
        super(cls, view);
    }

    protected static Value create(Env env, QuercusClass cls, Value data, int options, boolean dataIsUrl, Value namespaceV, boolean isPrefix) {
        if (data.length() == 0) {
            env.warning(L.l("xml data must have length greater than 0"));
            return BooleanValue.FALSE;
        }
        try {
            Document doc;
            String namespace = null;
            if (!namespaceV.isNull()) {
                namespace = namespaceV.toString();
            }
            if ((doc = SimpleXMLElement.parse2(env, data, options, dataIsUrl, namespace, isPrefix)) == null) {
                return BooleanValue.FALSE;
            }
            DocumentView view = SimpleXMLElement.buildNode(env, cls, doc, namespace, isPrefix);
            SimpleXMLElement e = new SimpleXMLElement(cls, view);
            return e.wrapJava(env);
        }
        catch (IOException e) {
            env.warning(e);
            return BooleanValue.FALSE;
        }
        catch (ParserConfigurationException e) {
            env.warning(e);
            return BooleanValue.FALSE;
        }
        catch (SAXException e) {
            e.printStackTrace();
            env.warning(e);
            return BooleanValue.FALSE;
        }
    }

    public static Value __construct(Env env, Value data, @Optional int options, @Optional boolean dataIsUrl, @Optional Value namespaceV, @Optional boolean isPrefix) {
        QuercusClass cls = env.getCallingClass();
        if (cls == null) {
            cls = env.getClass("SimpleXMLElement");
        }
        return SimpleXMLElement.create(env, cls, data, options, dataIsUrl, namespaceV, isPrefix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Document parse(Env env, Value data, int options, boolean dataIsUrl, String namespace, boolean isPrefix) throws IOException, ParserConfigurationException, SAXException {
        SimpleHandler resolver = new SimpleHandler(null);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setExpandEntityReferences(false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setEntityResolver(resolver);
        Document document = null;
        if (dataIsUrl) {
            Path path = env.lookup(data.toStringValue());
            if (path == null) {
                log.log(Level.FINE, L.l("Cannot read file/URL '{0}'", (Object)data));
                env.warning(L.l("Cannot read file/URL '{0}'", (Object)data));
                return null;
            }
            ReadStream is = path.openRead();
            try {
                document = builder.parse(is);
            }
            finally {
                is.close();
            }
        } else {
            StringReader stringReader = new StringReader(data.toString());
            document = builder.parse(new InputSource(stringReader));
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Document parse2(Env env, Value data, int options, boolean dataIsUrl, String namespace, boolean isPrefix) throws IOException, ParserConfigurationException, SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        DOMImplementation impl = builder.getDOMImplementation();
        SimpleHandler handler = new SimpleHandler(impl);
        SAXParserFactory saxFactory = SAXParserFactory.newInstance();
        saxFactory.setNamespaceAware(true);
        SAXParser parser = saxFactory.newSAXParser();
        XMLReader reader = parser.getXMLReader();
        reader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        reader.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
        if (dataIsUrl) {
            Path path = env.lookup(data.toStringValue());
            if (path == null) {
                log.log(Level.FINE, L.l("Cannot read file/URL '{0}'", (Object)data));
                env.warning(L.l("Cannot read file/URL '{0}'", (Object)data));
                return null;
            }
            ReadStream is = path.openRead();
            try {
                parser.parse((InputStream)is, (DefaultHandler)handler);
            }
            finally {
                is.close();
            }
        } else {
            StringReader stringReader = new StringReader(data.toString());
            parser.parse(new InputSource(stringReader), (DefaultHandler)handler);
        }
        Document doc = handler.getDocument();
        return doc;
    }

    private static DocumentView buildNode(Env env, QuercusClass cls, Document doc, String namespace, boolean isPrefix) {
        DocumentView view = new DocumentView(doc);
        return view;
    }

    public Iterator iterator() {
        Iterator<Map.Entry<IteratorIndex, SimpleView>> iter = this._view.getIterator();
        return new ViewIterator(iter);
    }

    @EntrySet
    public Set<Map.Entry<Value, Value>> entrySet() {
        Env env = Env.getInstance();
        return this._view.getEntrySet(env, this._cls);
    }

    public void varDumpImpl(Env env, Value obj, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
        this._view.varDump(env, out, depth, valueSet, this._cls);
    }

    public void printRImpl(Env env, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
        this._view.printR(env, out, depth, valueSet, this._cls);
    }

    private String getEncoding() {
        return this._view.getEncoding();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._view + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ElementEntry
    implements Map.Entry<Value, Value> {
        private Node _node;

        public ElementEntry(Node node) {
            this._node = node;
        }

        @Override
        public Value getKey() {
            Env env = Env.getInstance();
            return env.createString(this._node.getNodeName());
        }

        @Override
        public Value getValue() {
            Env env = Env.getInstance();
            if (this._node.getFirstChild() == null) {
                String text = this._node.getTextContent();
                return env.createString(text);
            }
            ElementView view = new ElementView(this._node);
            SimpleXMLElement e = new SimpleXMLElement(SimpleXMLElement.this._cls, view);
            return e.wrapJava(env);
        }

        @Override
        public Value setValue(Value value) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ElementIterator
    implements Iterator<ElementEntry> {
        private Node _node;

        ElementIterator(Node node) {
            this._node = node;
        }

        @Override
        public boolean hasNext() {
            for (Node node = this._node; node != null; node = node.getNextSibling()) {
                if (node.getNodeType() != 1) continue;
                return true;
            }
            return false;
        }

        @Override
        public ElementEntry next() {
            Node node = this._node;
            while (node != null) {
                this._node = node.getNextSibling();
                if (node.getNodeType() == 1) {
                    return new ElementEntry(node);
                }
                node = this._node;
            }
            return null;
        }

        @Override
        public void remove() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ViewIterator
    implements Iterator<Map.Entry<Value, SimpleXMLElement>> {
        private final Iterator<Map.Entry<IteratorIndex, SimpleView>> _iter;

        ViewIterator(Iterator<Map.Entry<IteratorIndex, SimpleView>> iter) {
            this._iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this._iter.hasNext();
        }

        @Override
        public Map.Entry<Value, SimpleXMLElement> next() {
            Map.Entry<IteratorIndex, SimpleView> entry = this._iter.next();
            Value index = entry.getKey().toValue(Env.getInstance(), SimpleXMLElement.this.getEncoding());
            SimpleView view = entry.getValue();
            SimpleXMLElement e = new SimpleXMLElement(SimpleXMLElement.this._cls, view);
            return new AbstractMap.SimpleEntry<Value, SimpleXMLElement>(index, e);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

