/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.resin;

import com.caucho.quercus.annotation.Name;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.resin.CompositeDataBean;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;

public class MBean {
    private static final Logger log = Logger.getLogger(MBean.class.getName());
    private static final HashMap<String, Marshall> _marshallMap = new HashMap();
    private MBeanServerConnection _server;
    private ObjectName _name;
    private MBeanInfo _info;

    MBean(MBeanServerConnection server, ObjectName name) {
        this._server = server;
        this._name = name;
    }

    public String getMbean_name() {
        return this._name.getCanonicalName();
    }

    @Name(value="mbean_info")
    public MBeanInfo getMbean_info() {
        try {
            if (this._info == null) {
                this._info = this._server.getMBeanInfo(this._name);
            }
            return this._info;
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            return null;
        }
    }

    public Object __getField(String attrName) {
        try {
            return this.unmarshall(this._server.getAttribute(this._name, attrName));
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            return null;
        }
    }

    public boolean __setField(String attrName, Object value) {
        try {
            this._server.setAttribute(this._name, new Attribute(attrName, value));
            return true;
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            return false;
        }
    }

    public Object __call(String name, Value values) {
        try {
            int size = values.getSize();
            Object[] args = new Object[values.getSize()];
            for (int i = 0; i < size; ++i) {
                args[i] = values.get(LongValue.create(i)).toJavaObject();
            }
            MBeanOperationInfo opInfo = this.findClosestOperation(name, args);
            if (opInfo != null) {
                String[] mbeanSig = this.createMBeanSig(opInfo);
                this.marshall(args, mbeanSig);
                Object value = this._server.invoke(this._name, name, args, mbeanSig);
                return this.unmarshall(value);
            }
            return this._server.invoke(this._name, name, args, null);
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            return null;
        }
    }

    private String[] createMBeanSig(MBeanOperationInfo opInfo) {
        MBeanParameterInfo[] paramInfo = opInfo.getSignature();
        String[] sig = new String[paramInfo.length];
        for (int i = 0; i < paramInfo.length; ++i) {
            sig[i] = paramInfo[i].getType();
        }
        return sig;
    }

    protected MBeanOperationInfo findClosestOperation(String name, Object[] args) throws Exception {
        MBeanInfo info = this.getMbean_info();
        if (info == null) {
            return null;
        }
        MBeanOperationInfo[] ops = info.getOperations();
        MBeanOperationInfo bestOp = null;
        long bestCost = Long.MAX_VALUE;
        for (int i = 0; i < ops.length; ++i) {
            long cost;
            MBeanOperationInfo op = ops[i];
            if (!name.equals(op.getName()) || op.getSignature().length != args.length || (cost = MBean.calculateCost(op.getSignature(), args)) >= bestCost) continue;
            bestCost = cost;
            bestOp = op;
        }
        return bestOp;
    }

    private static long calculateCost(MBeanParameterInfo[] paramInfo, Object[] args) {
        long cost = 0L;
        for (int i = 0; i < paramInfo.length; ++i) {
            String arg;
            String param = paramInfo[i].getType();
            if (param.equals(arg = args[i] != null ? args[i].getClass().getName() : "java.lang.Object")) continue;
            if (param.indexOf(91) >= 0 != arg.indexOf(91) >= 0) {
                cost += 100L;
                continue;
            }
            ++cost;
        }
        return cost;
    }

    private void marshall(Object[] args, String[] sig) {
        for (int i = 0; i < sig.length; ++i) {
            args[i] = this.findMarshall(sig[i]).marshall(args[i]);
        }
    }

    private Object unmarshall(Object value) {
        if (value instanceof ObjectName) {
            ObjectName name = (ObjectName)value;
            return new MBean(this._server, name);
        }
        if (value instanceof ObjectName[]) {
            ObjectName[] names = (ObjectName[])value;
            MBean[] mbeans = new MBean[names.length];
            for (int i = 0; i < names.length; ++i) {
                mbeans[i] = new MBean(this._server, names[i]);
            }
            return mbeans;
        }
        if (value instanceof CompositeData) {
            CompositeData compositeValue = (CompositeData)value;
            CompositeType type = compositeValue.getCompositeType();
            if (type != null) {
                String typeName = type.getTypeName();
                try {
                    ClassLoader loader = Thread.currentThread().getContextClassLoader();
                    Class<?> typeClass = Class.forName(typeName, false, loader);
                    Method from = typeClass.getMethod("from", CompositeData.class);
                    if (from != null) {
                        return from.invoke(null, compositeValue);
                    }
                }
                catch (Exception e) {
                    log.log(Level.FINER, e.toString(), e);
                }
            }
            return new CompositeDataBean(compositeValue);
        }
        if (value instanceof CompositeData[]) {
            CompositeData[] compositeValue = (CompositeData[])value;
            Object[] result = new Object[compositeValue.length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = this.unmarshall(compositeValue[i]);
            }
            return result;
        }
        return value;
    }

    private Marshall findMarshall(String sig) {
        Marshall marshall = _marshallMap.get(sig);
        if (marshall != null) {
            return marshall;
        }
        return Marshall.MARSHALL;
    }

    public String toString() {
        if (this._name == null) {
            return "MBean[]";
        }
        return "MBean[" + this._name.getCanonicalName() + "]";
    }

    static {
        _marshallMap.put("int", IntMarshall.MARSHALL);
        _marshallMap.put("java.lang.Integer", IntMarshall.MARSHALL);
        _marshallMap.put("long", LongMarshall.MARSHALL);
        _marshallMap.put("java.lang.Long", LongMarshall.MARSHALL);
        _marshallMap.put("[J", LongArrayMarshall.MARSHALL);
        _marshallMap.put("java.lang.String", StringMarshall.MARSHALL);
    }

    static class StringMarshall
    extends Marshall {
        static final Marshall MARSHALL = new StringMarshall();

        StringMarshall() {
        }

        public Object marshall(Object value) {
            if (value == null) {
                return null;
            }
            return value.toString();
        }
    }

    static class LongArrayMarshall
    extends Marshall {
        static final Marshall MARSHALL = new LongArrayMarshall();

        LongArrayMarshall() {
        }

        public Object marshall(Object value) {
            if (value instanceof Long) {
                return new long[]{(Long)value};
            }
            if (value instanceof Number) {
                return new long[]{((Number)value).longValue()};
            }
            if (value == null) {
                return null;
            }
            if (value instanceof ArrayValue) {
                ArrayValue array = (ArrayValue)value;
                long[] result = new long[array.getSize()];
                for (int i = 0; i < result.length; ++i) {
                    result[i] = array.get(LongValue.create(i)).toLong();
                }
                return result;
            }
            try {
                return new long[]{Long.parseLong(String.valueOf(value))};
            }
            catch (Exception e) {
                return new long[0];
            }
        }
    }

    static class LongMarshall
    extends Marshall {
        static final Marshall MARSHALL = new LongMarshall();

        LongMarshall() {
        }

        public Object marshall(Object value) {
            if (value instanceof Long) {
                return value;
            }
            if (value instanceof Number) {
                return new Long(((Number)value).longValue());
            }
            if (value == null) {
                return new Long(0L);
            }
            try {
                return new Long(Long.parseLong(String.valueOf(value)));
            }
            catch (Exception e) {
                return new Long(0L);
            }
        }
    }

    static class IntMarshall
    extends Marshall {
        static final Marshall MARSHALL = new IntMarshall();

        IntMarshall() {
        }

        public Object marshall(Object value) {
            if (value instanceof Integer) {
                return value;
            }
            if (value instanceof Number) {
                return new Integer(((Number)value).intValue());
            }
            if (value == null) {
                return new Integer(0);
            }
            try {
                return new Integer(Integer.parseInt(String.valueOf(value)));
            }
            catch (Exception e) {
                return new Integer(0);
            }
        }
    }

    static class Marshall {
        static final Marshall MARSHALL = new Marshall();

        Marshall() {
        }

        public Object marshall(Object value) {
            return value;
        }
    }
}

