/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.i18n;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.UnicodeBuilderValue;
import com.caucho.quercus.lib.i18n.Big5Decoder;
import com.caucho.quercus.lib.i18n.GenericDecoder;
import com.caucho.quercus.lib.i18n.Utf8Decoder;

public abstract class Decoder {
    protected String _charset;
    protected CharSequence _replacement;
    protected boolean _isIgnoreErrors = false;
    protected boolean _isReplaceUnicode = false;
    protected boolean _isAllowMalformedOut = false;
    protected boolean _hasError;

    protected Decoder(String charset) {
        this._charset = charset;
    }

    public static Decoder create(String charset) {
        if (charset.equalsIgnoreCase("utf8") || charset.equalsIgnoreCase("utf-8")) {
            return new Utf8Decoder(charset);
        }
        if (charset.equalsIgnoreCase("big5") || charset.equalsIgnoreCase("big-5")) {
            return new Big5Decoder(charset);
        }
        return new GenericDecoder(charset);
    }

    public boolean isUtf8() {
        return false;
    }

    public final boolean isIgnoreErrors() {
        return this._isIgnoreErrors;
    }

    public final void setIgnoreErrors(boolean isIgnore) {
        this._isIgnoreErrors = isIgnore;
    }

    public final boolean hasError() {
        return this._hasError;
    }

    public final void setReplacement(CharSequence replacement) {
        this._replacement = replacement;
    }

    public final void setReplaceUnicode(boolean isReplaceUnicode) {
        this._isReplaceUnicode = isReplaceUnicode;
    }

    public final void setAllowMalformedOut(boolean isAllowMalformedOut) {
        this._isAllowMalformedOut = isAllowMalformedOut;
    }

    public void reset() {
        this._hasError = false;
    }

    public final CharSequence decode(Env env, StringValue str) {
        if (str.isUnicode()) {
            return str;
        }
        UnicodeBuilderValue sb = new UnicodeBuilderValue();
        this.decodeUnicode(str, sb);
        return sb;
    }

    public final StringValue decodeUnicode(StringValue str) {
        UnicodeBuilderValue sb = new UnicodeBuilderValue();
        this.decodeUnicode(str, sb);
        return sb;
    }

    public abstract void decodeUnicode(StringValue var1, UnicodeBuilderValue var2);

    public abstract boolean isDecodable(Env var1, StringValue var2);
}

