/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.filter;

import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.filter.AbstractFilter;
import com.caucho.quercus.lib.filter.ValidateFilter;

public class BooleanValidateFilter
extends AbstractFilter
implements ValidateFilter {
    protected Value filterImpl(Env env, Value value, int flags, ArrayValue options) {
        if (value.isNull()) {
            if ((flags & 0x8000000) > 0) {
                return NullValue.NULL;
            }
            return BooleanValue.FALSE;
        }
        if (value.isBoolean()) {
            if ((flags & 0x8000000) > 0 && value == BooleanValue.FALSE) {
                return NullValue.NULL;
            }
            return value;
        }
        if (value.isLong()) {
            return BooleanValue.create(value.toLong() == 1L);
        }
        if (value.isDouble()) {
            return BooleanValue.create(value.toDouble() == 1.0);
        }
        if (value.isLongConvertible()) {
            return BooleanValue.create(value.toLong() == 1L);
        }
        String str = value.toStringValue(env).toString();
        if ("on".equals(str = str.toLowerCase().trim()) || "yes".equals(str) || "true".equals(str)) {
            return BooleanValue.TRUE;
        }
        if ("off".equals(str) || "no".equals(str) || "false".equals(str)) {
            return BooleanValue.FALSE;
        }
        if ((flags & 0x8000000) > 0) {
            return NullValue.NULL;
        }
        return BooleanValue.FALSE;
    }
}

