/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.db;

import com.caucho.quercus.UnimplementedException;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.annotation.ReadOnly;
import com.caucho.quercus.annotation.Reference;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.DefaultValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.EnvCleanup;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.UnsetValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.db.BoundColumn;
import com.caucho.quercus.lib.db.ColumnType;
import com.caucho.quercus.lib.db.JdbcPreparedStatementResource;
import com.caucho.quercus.lib.db.JdbcResultResource;
import com.caucho.quercus.lib.db.PDO;
import com.caucho.quercus.lib.db.PDOError;
import com.caucho.util.L10N;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDOStatement
extends JdbcPreparedStatementResource
implements Iterable<Value>,
EnvCleanup {
    private static final L10N L = new L10N(PDOStatement.class);
    private static final Value[] NULL_VALUES = new Value[0];
    private final PDO _pdo;
    private final PDOError _error;
    public final String queryString;
    private int _fetchMode = 4;
    private Value[] _fetchModeArgs = NULL_VALUES;
    private HashMap<Value, BoundColumn> _boundColumnMap;
    private HashMap<String, Integer> _parameterNameMap;
    private HashMap<Integer, ColumnType> _paramTypes;
    private HashMap<Integer, Value> _paramValues;

    protected PDOStatement(Env env, PDO pdo, PDOError error, String query, boolean isPrepared, ArrayValue options, boolean isCatchException) throws SQLException {
        super(pdo.getConnection());
        env.addCleanup(this);
        this._pdo = pdo;
        this._error = error;
        if (options != null && options.getSize() > 0) {
            env.notice(L.l("PDOStatement options unsupported"));
        }
        if (isPrepared) {
            query = this.parseQueryString(env, query);
            this.prepare(env, query);
        } else {
            this.setQuery(query);
            try {
                this.setStatement(pdo.getConnection().createStatement(env));
                this.execute(env, false);
            }
            catch (SQLException e) {
                if (isCatchException) {
                    this._error.error(env, e);
                }
                throw e;
            }
        }
        this.queryString = query;
    }

    private String parseQueryString(Env env, String query) {
        int len = query.length();
        StringBuilder sb = new StringBuilder(len);
        int parameterCount = 0;
        for (int i = 0; i < len; ++i) {
            char ch = query.charAt(i);
            if (ch == '\'' || ch == '\"') {
                char ch2;
                sb.append(ch);
                do {
                    if ((ch2 = query.charAt(++i)) < '\u0000') {
                        env.error(L.l("missing ending quote in query: {0}", (Object)query));
                    }
                    sb.append(ch2);
                } while (ch2 != ch);
                continue;
            }
            if (ch == '?') {
                ++parameterCount;
                sb.append(ch);
                continue;
            }
            if (ch == ':') {
                int ch2;
                if (i + 1 < len && query.charAt(i + 1) == ':') {
                    int j;
                    for (j = i + 1; j < len && query.charAt(j) == ':'; ++j) {
                    }
                    sb.append(query, i, j + 1);
                    i = j;
                    continue;
                }
                int start = i + 1;
                do {
                    ch2 = -1;
                    if (++i >= len) continue;
                    ch2 = query.charAt(i);
                } while (ch2 >= 0 && Character.isJavaIdentifierPart(ch2));
                String name = query.substring(start, i);
                if (this._parameterNameMap == null) {
                    this._parameterNameMap = new HashMap();
                }
                Integer index = parameterCount++;
                this._parameterNameMap.put(name, index);
                sb.append('?');
                if (ch2 < 0) continue;
                sb.append((char)ch2);
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public boolean bindColumn(Env env, Value column, @Reference Value var, @Optional(value="-1") int type) {
        try {
            if (this._boundColumnMap == null) {
                this._boundColumnMap = new HashMap();
            }
            ColumnType columnType = null;
            if (type != -1) {
                if (type == 1) {
                    columnType = ColumnType.LONG;
                } else if (type == 5) {
                    columnType = ColumnType.BOOLEAN;
                } else if (type == 2) {
                    columnType = ColumnType.STRING;
                } else if (type == 0) {
                    columnType = ColumnType.NULL;
                } else if (type == 3) {
                    columnType = ColumnType.LOB;
                } else {
                    if (type == 4) {
                        throw new UnimplementedException(L.l("PDO::PARAM_STMT"));
                    }
                    env.warning(L.l("unknown column type: {0}", type));
                    return false;
                }
            }
            ResultSetMetaData metaData = this.getMetaData();
            BoundColumn boundColumn = new BoundColumn(metaData, column, var, columnType);
            this._boundColumnMap.put(column, boundColumn);
            return true;
        }
        catch (SQLException e) {
            this._error.warning(env, e.getMessage());
            return false;
        }
    }

    public boolean bindParam(Env env, @ReadOnly Value parameter, @Reference Value value, @Optional(value="PDO::PARAM_STR") int dataType, @Optional(value="-1") int length, @Optional Value driverOptions) {
        ColumnType type;
        boolean isInputOutput;
        if (length != -1) {
            throw new UnimplementedException("length");
        }
        if (!driverOptions.isDefault()) {
            throw new UnimplementedException("driverOptions");
        }
        boolean bl = isInputOutput = (dataType & Integer.MIN_VALUE) != 0;
        if (isInputOutput) {
            dataType &= Integer.MAX_VALUE;
            throw new UnimplementedException("PARAM_INPUT_OUTPUT");
        }
        Integer index = this.resolveParameter(parameter);
        if (index == null) {
            this._error.warning(env, L.l("unknown parameter: '{0}'", (Object)parameter));
            return false;
        }
        switch (dataType) {
            case 5: {
                type = ColumnType.BOOLEAN;
                break;
            }
            case 1: {
                type = ColumnType.LONG;
                break;
            }
            case 3: {
                type = ColumnType.LOB;
                break;
            }
            case 0: {
                type = ColumnType.NULL;
                break;
            }
            case 2: {
                type = ColumnType.STRING;
                break;
            }
            case 4: {
                throw new UnimplementedException(L.l("PDO::PARAM_STMT"));
            }
            default: {
                this._error.warning(env, L.l("unknown dataType '{0}'", dataType));
                return false;
            }
        }
        if (this._paramTypes == null) {
            this._paramTypes = new HashMap();
            this._paramValues = new HashMap();
        }
        this._paramTypes.put(index, type);
        this._paramValues.put(index, value);
        return true;
    }

    public boolean bindValue(Env env, @ReadOnly Value parameter, @ReadOnly Value value, @Optional(value="PDO::PARAM_STR") int dataType) {
        if (dataType == -1) {
            dataType = 2;
        }
        value = value.toValue();
        return this.bindParam(env, parameter, value, dataType, -1, DefaultValue.DEFAULT);
    }

    public boolean closeCursor(Env env) {
        return this.freeResult();
    }

    public int columnCount(Env env) {
        return this.getColumnCount(env);
    }

    @Override
    public boolean close() {
        return super.close();
    }

    @Override
    public void cleanup() {
        this.close();
    }

    public String errorCode(Env env) {
        return this._error.getErrorCode();
    }

    public ArrayValue errorInfo() {
        return this._error.getErrorInfo();
    }

    @Override
    protected void setError(Env env, SQLException e) {
        e.printStackTrace();
        this._error.error(env, e);
    }

    public boolean execute(Env env, @Optional @ReadOnly Value inputParameters) {
        int size;
        ArrayValue parameters;
        this._error.clear();
        if (inputParameters.isArray()) {
            parameters = inputParameters.toArrayValue(env);
        } else if (inputParameters.isDefault()) {
            parameters = null;
        } else {
            env.warning(L.l("'{0}' is an unexpected argument, expected array", (Object)inputParameters));
            return false;
        }
        this.closeCursor(env);
        if (parameters != null) {
            size = parameters.getSize();
            ColumnType[] types = new ColumnType[size];
            Value[] values = new Value[size];
            for (Map.Entry<Value, Value> entry : parameters.entrySet()) {
                Value key = entry.getKey();
                Value value = entry.getValue();
                int index = key.isNumberConvertible() ? key.toInt() : this.resolveParameter(key).intValue();
                ColumnType type = ColumnType.getColumnType(value);
                if (type == null) {
                    this._error.warning(env, L.l("unknown type {0} ({1}) for parameter index {2}", (Object)value.getType(), (Object)value.getClass(), (Object)index));
                    return false;
                }
                types[index] = type;
                values[index] = value;
            }
            this.bindParams(env, types, values);
        } else if (this._paramTypes != null) {
            size = this._paramTypes.size();
            ColumnType[] types = new ColumnType[size];
            Value[] values = new Value[size];
            for (Map.Entry<Integer, ColumnType> entry : this._paramTypes.entrySet()) {
                Integer index = entry.getKey();
                ColumnType type = entry.getValue();
                int i = index;
                types[i] = type;
                values[i] = this._paramValues.get(index);
            }
            this.bindParams(env, types, values);
        }
        try {
            return this.execute(env, false);
        }
        catch (SQLException e) {
            this._error.error(env, e);
            return false;
        }
    }

    @Override
    protected boolean executeImpl(Env env) throws SQLException {
        this._pdo.setLastExecutedStatement(this);
        return super.executeImpl(env);
    }

    @Override
    protected JdbcResultResource createResultSet(ResultSet rs) {
        return new JdbcResultResource(rs, this._pdo.getColumnCase());
    }

    public Value fetch(Env env, @Optional int fetchMode, @Optional(value="0") int cursorOrientation, @Optional(value="0") int cursorOffset) {
        if (cursorOrientation != 0) {
            throw new UnimplementedException("fetch with cursorOrientation");
        }
        if (cursorOffset != 0) {
            throw new UnimplementedException("fetch with cursorOffset");
        }
        int columnIndex = 0;
        return this.fetchImpl(env, fetchMode, columnIndex);
    }

    public Value fetchAll(Env env, @Optional(value="0") int fetchMode, @Optional(value="-1") int columnIndex) {
        Value value;
        boolean isUnique;
        int effectiveFetchMode = fetchMode == 0 ? this._fetchMode : fetchMode;
        boolean isGroup = (fetchMode & 0x10000) != 0;
        boolean bl = isUnique = (fetchMode & 0x30000) != 0;
        if (isGroup) {
            throw new UnimplementedException("PDO.FETCH_GROUP");
        }
        if (isUnique) {
            throw new UnimplementedException("PDO.FETCH_UNIQUE");
        }
        switch (effectiveFetchMode &= 0xFFFCFFFF) {
            case 7: {
                break;
            }
            case 1: {
                this._error.warning(env, L.l("PDO::FETCH_LAZY can't be used with PDOStatement::fetchAll()"));
                return BooleanValue.FALSE;
            }
            default: {
                if (columnIndex == -1) break;
                this._error.warning(env, L.l("unexpected arguments"));
                return BooleanValue.FALSE;
            }
        }
        ArrayValueImpl rows = new ArrayValueImpl();
        while ((value = this.fetchImpl(env, effectiveFetchMode, columnIndex)) != BooleanValue.FALSE) {
            rows.put(value);
        }
        return rows;
    }

    private Value fetchBoth(Env env, JdbcResultResource rs) {
        Value value = rs.fetchBoth(env, false);
        if (value == NullValue.NULL) {
            return BooleanValue.FALSE;
        }
        return value;
    }

    private Value fetchBound(Env env, JdbcResultResource rs) {
        try {
            if (!rs.next()) {
                return BooleanValue.FALSE;
            }
            return BooleanValue.TRUE;
        }
        catch (SQLException e) {
            this._error.warning(env, e.getMessage());
            return BooleanValue.FALSE;
        }
    }

    private void bindColumns(Env env, JdbcResultResource rs) throws SQLException {
        if (this._boundColumnMap != null) {
            for (BoundColumn binding : this._boundColumnMap.values()) {
                binding.bind(env, rs);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Value fetchClass(Env env, JdbcResultResource rs) {
        Value[] ctorArgs;
        if (this._fetchModeArgs.length == 0 || this._fetchModeArgs.length > 2) {
            return this.fetchBoth(env, rs);
        }
        String className = this._fetchModeArgs[0].toString();
        if (this._fetchModeArgs.length == 2) {
            if (!this._fetchModeArgs[1].isArray()) return this.fetchBoth(env, rs);
            ArrayValue argsArray = (ArrayValue)this._fetchModeArgs[1];
            ctorArgs = new Value[argsArray.getSize()];
            int i = 0;
            for (Value key : argsArray.keySet()) {
                ctorArgs[i++] = argsArray.getVar(key);
            }
            return this.fetchObject(env, className, ctorArgs);
        } else {
            ctorArgs = NULL_VALUES;
        }
        return this.fetchObject(env, className, ctorArgs);
    }

    public Value fetchColumn(Env env, @Optional int column) {
        if (column < 0 && this._fetchModeArgs.length > 0) {
            column = this._fetchModeArgs[0].toInt();
        }
        try {
            if (column < 0 || column >= this.getMetaData().getColumnCount()) {
                return BooleanValue.FALSE;
            }
            JdbcResultResource rs = this.getResultSet();
            if (rs == null || !rs.next()) {
                return BooleanValue.FALSE;
            }
            return rs.getColumnValue(env, column + 1);
        }
        catch (SQLException e) {
            this._error.error(env, e);
            return BooleanValue.FALSE;
        }
    }

    private Value fetchFunc(Env env) {
        throw new UnimplementedException();
    }

    private Value fetchImpl(Env env, int fetchMode, int columnIndex) {
        Value value;
        JdbcResultResource rs = this.getResultSet();
        if (rs == null) {
            return BooleanValue.FALSE;
        }
        if (fetchMode == 0) {
            fetchMode = this._fetchMode;
            fetchMode &= 0xFFFCFFFF;
        } else {
            if ((fetchMode & 0x10000) != 0) {
                this._error.warning(env, L.l("FETCH_GROUP is not allowed"));
                return BooleanValue.FALSE;
            }
            if ((fetchMode & 0x30000) != 0) {
                this._error.warning(env, L.l("FETCH_UNIQUE is not allowed"));
                return BooleanValue.FALSE;
            }
        }
        boolean isClasstype = (fetchMode & 0x40000) != 0;
        boolean isSerialize = (fetchMode & 0x80000) != 0;
        switch (fetchMode &= 0xFFF3FFFF) {
            case 2: {
                value = this.fetchAssoc(env, rs);
                break;
            }
            case 4: {
                value = this.fetchBoth(env, rs);
                break;
            }
            case 6: {
                value = this.fetchBound(env, rs);
                break;
            }
            case 7: {
                value = this.fetchColumn(env, columnIndex);
                break;
            }
            case 8: {
                value = this.fetchClass(env, rs);
                break;
            }
            case 10: {
                value = this.fetchFunc(env);
                break;
            }
            case 9: {
                value = this.fetchInto(env, rs);
                break;
            }
            case 1: {
                value = this.fetchLazy(env);
                break;
            }
            case 11: {
                value = this.fetchNamed(env, rs);
                break;
            }
            case 3: {
                value = this.fetchNum(env, rs);
                break;
            }
            case 5: {
                value = this.fetchObject(env, rs);
                break;
            }
            default: {
                this._error.warning(env, L.l("invalid fetch mode {0}", fetchMode));
                this.closeCursor(env);
                value = BooleanValue.FALSE;
            }
        }
        try {
            if (value != BooleanValue.FALSE) {
                this.bindColumns(env, rs);
            }
            return value;
        }
        catch (SQLException e) {
            this._error.error(env, e);
            return BooleanValue.FALSE;
        }
    }

    private Value fetchNum(Env env, JdbcResultResource rs) {
        Value value = rs.fetchNum(env);
        if (value == NullValue.NULL) {
            return BooleanValue.FALSE;
        }
        return value;
    }

    private Value fetchAssoc(Env env, JdbcResultResource rs) {
        Value value = rs.fetchAssoc(env);
        if (value == NullValue.NULL) {
            return BooleanValue.FALSE;
        }
        return value;
    }

    private Value fetchObject(Env env, JdbcResultResource rs) {
        Value value = rs.fetchObject(env, null, Value.NULL_ARGS);
        if (value == NullValue.NULL) {
            return BooleanValue.FALSE;
        }
        return value;
    }

    private Value fetchInto(Env env, JdbcResultResource rs) {
        if (this._fetchModeArgs.length == 0) {
            return BooleanValue.FALSE;
        }
        if (!this._fetchModeArgs[0].isObject()) {
            return BooleanValue.FALSE;
        }
        try {
            if (!rs.next()) {
                return BooleanValue.FALSE;
            }
            Value var = this._fetchModeArgs[0];
            int columnCount = this.getMetaData().getColumnCount();
            for (int i = 1; i <= columnCount; ++i) {
                String name = rs.getColumnLabel(i);
                Value value = this.getColumnValue(env, i);
                var.putField(env, name, value);
            }
            return var;
        }
        catch (SQLException e) {
            this._error.error(env, e);
            return BooleanValue.FALSE;
        }
    }

    private Value fetchLazy(Env env) {
        return this.fetchObject(env, null, NULL_VALUES);
    }

    private Value fetchNamed(Env env, JdbcResultResource rs) {
        try {
            ArrayValueImpl array = new ArrayValueImpl();
            int columnCount = this.getMetaData().getColumnCount();
            for (int i = 1; i <= columnCount; ++i) {
                StringValue name = env.createString(rs.getColumnLabel(i));
                Value value = this.getColumnValue(env, i);
                Value existingValue = ((ArrayValue)array).get(name);
                if (!(existingValue instanceof UnsetValue)) {
                    if (!existingValue.isArray()) {
                        ArrayValueImpl arrayValue = new ArrayValueImpl();
                        ((ArrayValue)arrayValue).put(existingValue);
                        array.put(name, arrayValue);
                        existingValue = arrayValue;
                    }
                    existingValue.put(value);
                    continue;
                }
                array.put(name, value);
            }
            return array;
        }
        catch (SQLException e) {
            this._error.error(env, e);
            return BooleanValue.FALSE;
        }
    }

    public Value fetchObject(Env env, @Optional String className, @Optional Value[] args) {
        JdbcResultResource rs = this.getResultSet();
        if (rs == null) {
            return BooleanValue.FALSE;
        }
        Value value = rs.fetchObject(env, className, args);
        if (value == NullValue.NULL) {
            return BooleanValue.FALSE;
        }
        return value;
    }

    public Value getAttribute(Env env, int attribute) {
        this._error.unsupportedAttribute(env, attribute);
        return BooleanValue.FALSE;
    }

    public Value getColumnMeta(Env env, int column) {
        throw new UnimplementedException();
    }

    private Value getColumnValue(Env env, int column) throws SQLException {
        JdbcResultResource rs = this.getResultSet();
        return rs.getColumnValue(env, column);
    }

    @Override
    public Iterator<Value> iterator() {
        Value value = this.fetchAll(Env.getInstance(), 0, -1);
        if (value instanceof ArrayValue) {
            return ((ArrayValue)value).values().iterator();
        }
        Set emptySet = Collections.emptySet();
        return emptySet.iterator();
    }

    public boolean nextRowset() {
        throw new UnimplementedException();
    }

    private Integer resolveParameter(Value parameter) {
        Integer index = null;
        if (parameter.isLong()) {
            index = parameter.toInt() - 1;
        } else {
            String name = parameter.toString();
            if (name.length() > 1 && name.charAt(0) == ':') {
                name = name.substring(1);
            }
            index = this._parameterNameMap != null ? this._parameterNameMap.get(name) : Integer.valueOf(parameter.toInt());
        }
        return index;
    }

    public int rowCount(Env env) {
        JdbcResultResource rs = this.getResultSet();
        if (rs == null) {
            return 0;
        }
        return rs.getNumRows();
    }

    public boolean setAttribute(Env env, int attribute, Value value) {
        return this.setAttribute(env, attribute, value, false);
    }

    public boolean setAttribute(Env env, int attribute, Value value, boolean isFromConstructor) {
        if (isFromConstructor) {
            switch (attribute) {
                case 0: 
                case 1: {
                    return this.setCursor(env, attribute);
                }
            }
        }
        this._error.unsupportedAttribute(env, attribute);
        return false;
    }

    private boolean setCursor(Env env, int attribute) {
        switch (attribute) {
            case 0: {
                throw new UnimplementedException();
            }
            case 1: {
                throw new UnimplementedException();
            }
        }
        this._error.unsupportedAttribute(env, attribute);
        return false;
    }

    public boolean setFetchMode(Env env, int fetchMode, Value[] args) {
        boolean isUnique;
        this._fetchMode = 4;
        this._fetchModeArgs = NULL_VALUES;
        int fetchStyle = fetchMode;
        boolean isGroup = (fetchMode & 0x10000) != 0;
        boolean bl = isUnique = (fetchMode & 0x30000) != 0;
        if (isGroup) {
            throw new UnimplementedException("PDO.FETCH_GROUP");
        }
        if (isUnique) {
            throw new UnimplementedException("PDO.FETCH_UNIQUE");
        }
        fetchStyle &= 0xFFFCFFFF;
        boolean isClasstype = (fetchMode & 0x40000) != 0;
        boolean isSerialize = (fetchMode & 0x80000) != 0;
        switch (fetchStyle &= 0xFFF3FFFF) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 11: {
                if (args.length <= 0) break;
                env.warning(L.l("this fetch mode does not accept any arguments"));
                return false;
            }
            case 8: {
                if (args.length < 1 || args.length > 2) {
                    return false;
                }
                if (env.findClass(args[0].toString()) == null) {
                    return false;
                }
                if (args.length != 2 || args[1].isNull() || args[1].isArray()) break;
                env.warning(L.l("constructor args must be an array"));
                return false;
            }
            case 7: {
                if (args.length == 1) break;
                return false;
            }
            case 10: {
                this._error.warning(env, L.l("PDO::FETCH_FUNC can only be used with PDOStatement::fetchAll()"));
                return false;
            }
            case 9: {
                if (args.length == 1 && args[0].isObject()) break;
                return false;
            }
            default: {
                this._error.warning(env, L.l("invalid fetch mode"));
            }
        }
        this._fetchModeArgs = args;
        this._fetchMode = fetchMode;
        return true;
    }

    @Override
    protected boolean isFetchFieldIndexBeforeFieldName() {
        return false;
    }

    @Override
    public String toString() {
        String query = this.getQuery();
        return "PDOStatement[" + query.substring(0, 16) + "]";
    }
}

