/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.db;

import com.caucho.quercus.QuercusException;
import com.caucho.util.L10N;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.logging.Logger;

public class MysqlResultSetMetaData {
    private static final Logger log = Logger.getLogger(MysqlResultSetMetaData.class.getName());
    private static final L10N L = new L10N(MysqlResultSetMetaData.class);
    private ResultSetMetaData _resultSetMetaData;
    private String[] _columnEncodings;

    protected MysqlResultSetMetaData(ResultSetMetaData metaData) {
        this._resultSetMetaData = metaData;
        try {
            this._columnEncodings = new String[metaData.getColumnCount()];
        }
        catch (SQLException e) {
            throw new QuercusException(e);
        }
    }

    public String getColumnCharacterEncoding(int column) {
        String encoding = this._columnEncodings[column - 1];
        if (encoding == null) {
            this._columnEncodings[column - 1] = encoding = this.getColumnCharacterEncodingImpl(column);
        }
        return encoding;
    }

    private String getColumnCharacterEncodingImpl(int column) {
        Class<?> cls = this._resultSetMetaData.getClass();
        try {
            Method method = cls.getMethod("getColumnCharacterEncoding", Integer.TYPE);
            Object result = method.invoke((Object)this._resultSetMetaData, column);
            return (String)result;
        }
        catch (NoSuchMethodException e) {
            throw new QuercusException(e);
        }
        catch (InvocationTargetException e) {
            throw new QuercusException(e);
        }
        catch (IllegalAccessException e) {
            throw new QuercusException(e);
        }
    }
}

