/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.db;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.db.ColumnType;
import com.caucho.quercus.lib.db.JdbcResultResource;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class BoundColumn {
    private final String _columnAsName;
    private final Value _var;
    private int _column;
    private ColumnType _type;
    private boolean _isValid;

    public BoundColumn(ResultSetMetaData metaData, Value column, Value var, ColumnType type) throws SQLException {
        if (column.isNumberConvertible()) {
            this._column = column.toInt();
            this._columnAsName = null;
        } else {
            this._columnAsName = column.toString();
        }
        this._var = var;
        this.init(metaData);
    }

    private boolean init(ResultSetMetaData metaData) throws SQLException {
        int columnCount = metaData.getColumnCount();
        if (this._columnAsName != null) {
            for (int i = 1; i <= columnCount; ++i) {
                String name = metaData.getColumnName(i);
                if (!name.equals(this._columnAsName)) continue;
                this._column = i;
                break;
            }
        }
        this._isValid = this._column > 0 && this._column <= columnCount;
        return true;
    }

    public boolean bind(Env env, JdbcResultResource rs) throws SQLException {
        if (!this._isValid) {
            this._var.set(env.getEmptyString());
        } else {
            Value value = this._type != null ? rs.getColumnValue(env, this._column, this._type.getType()) : rs.getColumnValue(env, this._column);
            this._var.set(value);
        }
        return true;
    }
}

