/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.date;

import com.caucho.util.QDate;

public class DateParser {
    private static final int INT = 1;
    private static final int PERIOD = 2;
    private static final int AGO = 3;
    private static final int AM = 4;
    private static final int PM = 5;
    private static final int MONTH = 6;
    private static final int WEEKDAY = 7;
    private static final int UTC = 8;
    private static final int UNIT_YEAR = 1;
    private static final int UNIT_MONTH = 2;
    private static final int UNIT_FORTNIGHT = 3;
    private static final int UNIT_WEEK = 4;
    private static final int UNIT_DAY = 5;
    private static final int UNIT_HOUR = 6;
    private static final int UNIT_MINUTE = 7;
    private static final int UNIT_SECOND = 8;
    private static final int UNIT_NOW = 9;
    private static final int NULL_VALUE = Integer.MAX_VALUE;
    private QDate _date;
    private CharSequence _s;
    private int _index;
    private int _length;
    private StringBuilder _sb = new StringBuilder();
    private int _peekToken;
    private int _value;
    private int _digits;
    private int _unit;
    private int _weekday;
    private boolean _hasDate;
    private boolean _hasTime;
    private static final long MINUTE = 60000L;
    private static final long HOUR = 3600000L;
    private static final long DAY = 86400000L;

    public DateParser(CharSequence s, QDate date) {
        this._date = date;
        this._s = s;
        this._length = s.length();
    }

    public long parse() {
        this._value = Integer.MAX_VALUE;
        this._unit = 0;
        while (true) {
            int token;
            if ((token = this.nextToken()) == 45) {
                token = this.nextToken();
                if (token == 1) {
                    this._value = -this._value;
                } else {
                    this._peekToken = token;
                    continue;
                }
            }
            if (token < 0) {
                if (this._hasDate && !this._hasTime) {
                    this._date.setTime(0L, 0L, 0L, 0L);
                }
                return this._date.getGMTTime();
            }
            if (token == 1) {
                int digits = this._digits;
                int value = this._value;
                token = this.nextToken();
                if (token == 2) {
                    this.parsePeriod();
                    continue;
                }
                if (token == 58) {
                    this.parseTime();
                    this._hasTime = true;
                    continue;
                }
                if (token == 45) {
                    this.parseISODate(value);
                    this._hasDate = true;
                    continue;
                }
                if (token == 47) {
                    this.parseUSDate(value);
                    this._hasDate = true;
                    continue;
                }
                if (token == 6) {
                    this.parseDayMonthDate(value);
                    this._hasDate = true;
                    continue;
                }
                this._peekToken = token;
                this.parseBareInt(value, digits);
                continue;
            }
            if (token == 2) {
                this.parsePeriod();
                continue;
            }
            if (token == 7) {
                this.addWeekday(this._value, this._weekday);
                this._value = Integer.MAX_VALUE;
                continue;
            }
            if (token == 6) {
                this.parseMonthDate(this._value);
                this._hasDate = true;
                continue;
            }
            if (token != 64 || (token = this.nextToken()) != 1) continue;
            int value = this._value;
            this._value = Integer.MAX_VALUE;
            this._date.setGMTTime((long)value * 1000L);
            token = this.nextToken();
            if (token == 46) {
                token = this.nextToken();
                if (token == 1) continue;
                this._peekToken = token;
                continue;
            }
            this._peekToken = token;
        }
    }

    private void parsePeriod() {
        int value = this._value;
        int unit = this._unit;
        this._value = Integer.MAX_VALUE;
        this._unit = 0;
        int token = this.nextToken();
        if (token == 3) {
            value = -value;
        } else {
            this._peekToken = token;
        }
        this.addTime(value, unit);
    }

    private void parseISODate(int value1) {
        if (value1 < 0) {
            value1 = -value1;
        }
        int token = this.nextToken();
        int value2 = 0;
        if (token != 1) {
            this._peekToken = token;
            return;
        }
        value2 = this._value;
        this._value = Integer.MAX_VALUE;
        token = this.nextToken();
        if (token == 45) {
            token = this.nextToken();
            if (token == 1) {
                if (value1 < 0) {
                    this._date.setYear(value1);
                } else if (value1 <= 68) {
                    this._date.setYear(2000 + value1);
                } else if (value1 < 100) {
                    this._date.setYear(1900 + value1);
                } else {
                    this._date.setYear(value1);
                }
                this._date.setMonth(value2 - 1);
                this._date.setDayOfMonth(this._value);
            } else {
                this._date.setMonth(value1 - 1);
                this._date.setDayOfMonth(value2);
                this._peekToken = token;
            }
        } else {
            this._date.setMonth(value1 - 1);
            this._date.setDayOfMonth(value2);
            this._peekToken = token;
        }
    }

    private void parseUSDate(int value1) {
        if (value1 < 0) {
            value1 = -value1;
        }
        int token = this.nextToken();
        int value2 = 0;
        if (token != 1) {
            this._peekToken = token;
            return;
        }
        value2 = this._value;
        this._value = Integer.MAX_VALUE;
        token = this.nextToken();
        if (token == 47) {
            token = this.nextToken();
            if (token == 1) {
                this._date.setMonth(value1 - 1);
                this._date.setDayOfMonth(value2);
                if (this._value < 0) {
                    this._date.setYear(this._value);
                } else if (this._value <= 68) {
                    this._date.setYear(2000 + this._value);
                } else if (this._value < 100) {
                    this._date.setYear(1900 + this._value);
                } else {
                    this._date.setYear(this._value);
                }
            } else {
                this._date.setMonth(value1 - 1);
                this._date.setDayOfMonth(value2);
                this._peekToken = token;
            }
            this._value = Integer.MAX_VALUE;
        } else {
            this._date.setMonth(value1 - 1);
            this._date.setDayOfMonth(value2);
            this._peekToken = token;
        }
    }

    private void parseDayMonthDate(int value1) {
        if (value1 < 0) {
            value1 = -value1;
        }
        int value2 = this._value;
        this._value = Integer.MAX_VALUE;
        int token = this.nextToken();
        if (token == 45) {
            this._value = Integer.MAX_VALUE;
            token = this.nextToken();
        }
        if (token == 1 && this._digits > 0) {
            this._date.setDayOfMonth(value1);
            this._date.setMonth(value2 - 1);
            if (this._value < 0) {
                this._date.setYear(this._value);
            } else if (this._value <= 68) {
                this._date.setYear(2000 + this._value);
            } else if (this._value < 100) {
                this._date.setYear(1900 + this._value);
            } else {
                this._date.setYear(this._value);
            }
            this._value = Integer.MAX_VALUE;
        } else {
            this._date.setDayOfMonth(value1);
            this._date.setMonth(value2 - 1);
            this._peekToken = token;
        }
    }

    private void parseMonthDate(int value1) {
        if (value1 < 0) {
            value1 = -value1;
        }
        this._value = Integer.MAX_VALUE;
        int token = this.nextToken();
        if (token == 45) {
            this._value = Integer.MAX_VALUE;
            token = this.nextToken();
        }
        if (token == 1) {
            int value2 = this._value;
            this._value = Integer.MAX_VALUE;
            token = this.nextToken();
            if (token == 45) {
                this._value = Integer.MAX_VALUE;
                token = this.nextToken();
            }
            if (token == 1) {
                this._date.setMonth(value1 - 1);
                this._date.setDayOfMonth(value2);
                if (this._value < 0) {
                    this._date.setYear(this._value);
                } else if (this._value <= 68) {
                    this._date.setYear(2000 + this._value);
                } else if (this._value < 100) {
                    this._date.setYear(1900 + this._value);
                } else {
                    this._date.setYear(this._value);
                }
                this._value = Integer.MAX_VALUE;
            } else {
                this._date.setMonth(value1 - 1);
                this._date.setDayOfMonth(value2);
                this._peekToken = token;
            }
        } else {
            this._date.setMonth(value1 - 1);
            this._peekToken = token;
        }
    }

    private void parseTime() {
        int hour = this._value;
        this._value = Integer.MAX_VALUE;
        if (hour < 0) {
            hour = -hour;
        }
        this._date.setHour(hour);
        this._date.setMinute(0);
        this._date.setSecond(0);
        this._date.setMillisecond(0L);
        int token = this.nextToken();
        if (token != 1) {
            this._peekToken = token;
            return;
        }
        this._date.setMinute(this._value);
        this._value = Integer.MAX_VALUE;
        token = this.nextToken();
        if (token == 58) {
            token = this.nextToken();
            if (token != 1) {
                this._peekToken = token;
                return;
            }
            this._date.setSecond(this._value);
            this._value = Integer.MAX_VALUE;
            token = this.nextToken();
            if (token == 46) {
                token = this.nextToken();
                if (token == 1) {
                    token = this.nextToken();
                } else {
                    this._peekToken = token;
                    return;
                }
            }
        }
        if (token == 4) {
            hour = this._date.getHour();
            if (hour == 12) {
                this._date.setHour(0);
            }
        } else if (token == 5) {
            hour = this._date.getHour();
            if (hour == 12) {
                this._date.setHour(12);
            } else {
                this._date.setHour(hour + 12);
            }
        } else {
            this._peekToken = token;
        }
        this.parseTimezone();
    }

    private void parseTimezone() {
        int token = this.nextToken();
        int sign = 1;
        boolean hasUTC = false;
        if (token == 8) {
            token = this.nextToken();
            hasUTC = true;
        }
        if (token == 45) {
            sign = -1;
        } else if (token == 43) {
            sign = 1;
        } else {
            this._peekToken = token;
            if (hasUTC) {
                this._date.setGMTTime(this._date.getGMTTime() + this._date.getZoneOffset());
            }
            return;
        }
        token = this.nextToken();
        if (token != 1) {
            this._peekToken = token;
            if (hasUTC) {
                this._date.setGMTTime(this._date.getGMTTime() + this._date.getZoneOffset());
            }
            return;
        }
        if (this._digits == 4) {
            int hours = this._value / 100;
            int minutes = this._value % 100;
            int value = sign * (hours * 60 + minutes);
            this._value = Integer.MAX_VALUE;
            if (hasUTC) {
                this._date.setGMTTime(this._date.getGMTTime() + this._date.getZoneOffset());
            } else {
                this._date.setGMTTime(this._date.getGMTTime() - (long)value * 60000L + this._date.getZoneOffset());
            }
            return;
        }
        if (this._digits == 2) {
            int value = this._value;
            token = this.nextToken();
            if (token != 58) {
                this._value = sign * this._value;
                this._peekToken = token;
                if (hasUTC) {
                    this._date.setGMTTime(this._date.getGMTTime() + this._date.getZoneOffset());
                }
                return;
            }
            token = this.nextToken();
            if (token != 1) {
                return;
            }
            value = sign * (60 * value + this._value);
            this._date.setGMTTime(this._date.getGMTTime() - (long)value * 60000L + this._date.getZoneOffset());
            return;
        }
        this._value = sign * this._value;
        this._peekToken = token;
        if (hasUTC) {
            this._date.setGMTTime(this._date.getGMTTime() + this._date.getZoneOffset());
        }
    }

    private void addTime(int value, int unit) {
        if (value == Integer.MAX_VALUE) {
            value = 1;
        } else if (value == -2147483647) {
            value = -1;
        }
        switch (unit) {
            case 1: {
                this._date.setYear(this._date.getYear() + value);
                break;
            }
            case 2: {
                int month = this._date.getMonth() + value;
                int year = this._date.getYear();
                if (month < 0 || month >= 12) {
                    year += month / 12;
                    month %= 12;
                }
                this._date.setDate(year, month, this._date.getDayOfMonth());
                break;
            }
            case 3: {
                this._date.setDayOfMonth(this._date.getDayOfMonth() + 14 * value);
                break;
            }
            case 4: {
                this._date.setDayOfMonth(this._date.getDayOfMonth() + 7 * value);
                break;
            }
            case 5: {
                this._date.setDayOfMonth(this._date.getDayOfMonth() + value);
                break;
            }
            case 6: {
                this._date.setHour(this._date.getHour() + value);
                break;
            }
            case 7: {
                this._date.setMinute(this._date.getMinute() + value);
                break;
            }
            case 8: {
                this._date.setSecond(this._date.getSecond() + value);
            }
        }
    }

    private void addWeekday(int value, int weekday) {
        if (value == Integer.MAX_VALUE) {
            value = 0;
        } else if (value == -2147483647) {
            value = -1;
        }
        this._date.setDayOfMonth(this._date.getDayOfMonth() + (8 + weekday - this._date.getDayOfWeek()) % 7 + 7 * value);
    }

    private void parseBareInt(int value, int digits) {
        if (digits == 8 && !this._hasDate) {
            this._hasDate = true;
            this._date.setYear(value / 10000);
            this._date.setMonth(value / 100 % 12 - 1);
            this._date.setDayOfMonth(value % 100);
        } else if (digits == 6 && !this._hasTime) {
            this._hasTime = true;
            this._date.setHour(value / 10000);
            this._date.setMinute(value / 100 % 100);
            this._date.setSecond(value % 100);
            this.parseTimezone();
        } else if (digits == 4 && !this._hasTime) {
            this._hasTime = true;
            this._date.setHour(value / 100);
            this._date.setMinute(value % 100);
            this._date.setSecond(0);
            this.parseTimezone();
        } else if (digits == 2 && !this._hasTime) {
            this._hasTime = true;
            this._date.setHour(value);
            this._date.setMinute(0);
            this._date.setSecond(0);
            this.parseTimezone();
        }
        int token = this.nextToken();
        if (token == 46) {
            this._value = Integer.MAX_VALUE;
            token = this.nextToken();
            if (token == 1) {
                this._value = Integer.MAX_VALUE;
            } else {
                this._peekToken = token;
            }
        } else {
            this._peekToken = token;
        }
    }

    private int nextToken() {
        int ch;
        if (this._peekToken > 0) {
            int token = this._peekToken;
            this._peekToken = 0;
            return token;
        }
        do {
            this.skipSpaces();
            ch = this.read();
            if (ch < 0) {
                return -1;
            }
            if (ch == 45) {
                return 45;
            }
            if (ch == 43) {
                return 43;
            }
            if (ch == 58) {
                return 58;
            }
            if (ch == 46) {
                return 46;
            }
            if (ch == 47) {
                return 47;
            }
            if (ch == 64) {
                return 64;
            }
            if (48 > ch || ch > 57) continue;
            int value = 0;
            int digits = 0;
            while (48 <= ch && ch <= 57) {
                ++digits;
                value = 10 * value + ch - 48;
                ch = this.read();
            }
            this._value = value;
            this._digits = digits;
            this.unread();
            return 1;
        } while ((97 > ch || ch > 122) && (65 > ch || ch > 90));
        this._sb.setLength(0);
        while (97 <= ch && ch <= 122 || 65 <= ch && ch <= 90 || ch == 46) {
            this._sb.append(Character.toLowerCase((char)ch));
            ch = this.read();
        }
        this.unread();
        String s = this._sb.toString();
        return this.parseString(s);
    }

    private int parseString(String s) {
        if (s.endsWith(".")) {
            s = s.substring(0, s.length() - 1);
        }
        if ("now".equals(s) || "today".equals(s)) {
            this._value = 0;
            this._unit = 9;
            return 2;
        }
        if ("last".equals(s)) {
            this._value = -1;
            this._digits = 0;
            return 1;
        }
        if ("this".equals(s)) {
            this._value = 0;
            this._digits = 0;
            return 1;
        }
        if ("am".equals(s) || "a.m".equals(s)) {
            return 4;
        }
        if ("pm".equals(s) || "p.m".equals(s)) {
            return 5;
        }
        if ("next".equals(s)) {
            this._value = 1;
            this._digits = 0;
            return 1;
        }
        if ("third".equals(s)) {
            this._value = 3;
            this._digits = 0;
            return 1;
        }
        if ("fourth".equals(s)) {
            this._value = 4;
            this._digits = 0;
            return 1;
        }
        if ("fifth".equals(s)) {
            this._value = 5;
            this._digits = 0;
            return 1;
        }
        if ("sixth".equals(s)) {
            this._value = 6;
            this._digits = 0;
            return 1;
        }
        if ("seventh".equals(s)) {
            this._value = 7;
            this._digits = 0;
            return 1;
        }
        if ("eighth".equals(s)) {
            this._value = 8;
            this._digits = 0;
            return 1;
        }
        if ("ninth".equals(s)) {
            this._value = 9;
            this._digits = 0;
            return 1;
        }
        if ("tenth".equals(s)) {
            this._value = 10;
            this._digits = 0;
            return 1;
        }
        if ("eleventh".equals(s)) {
            this._value = 11;
            this._digits = 0;
            return 1;
        }
        if ("twelfth".equals(s)) {
            this._value = 12;
            this._digits = 0;
            return 1;
        }
        if ("yesterday".equals(s)) {
            this._value = -1;
            this._unit = 5;
            return 2;
        }
        if ("tomorrow".equals(s)) {
            this._value = 1;
            this._unit = 5;
            return 2;
        }
        if ("ago".equals(s)) {
            return 3;
        }
        if ("year".equals(s) || "years".equals(s)) {
            this._unit = 1;
            return 2;
        }
        if ("month".equals(s) || "months".equals(s)) {
            this._unit = 2;
            return 2;
        }
        if ("fortnight".equals(s) || "fortnights".equals(s)) {
            this._unit = 3;
            return 2;
        }
        if ("week".equals(s) || "weeks".equals(s)) {
            this._unit = 4;
            return 2;
        }
        if ("day".equals(s) || "days".equals(s)) {
            this._unit = 5;
            return 2;
        }
        if ("hour".equals(s) || "hours".equals(s)) {
            this._unit = 6;
            return 2;
        }
        if ("minute".equals(s) || "minutes".equals(s)) {
            this._unit = 7;
            return 2;
        }
        if ("second".equals(s) || "seconds".equals(s)) {
            if (this._value == Integer.MAX_VALUE) {
                this._digits = 0;
                this._value = 2;
                return 1;
            }
            this._unit = 8;
            return 2;
        }
        if ("january".equals(s) || "jan".equals(s)) {
            this._value = 1;
            return 6;
        }
        if ("february".equals(s) || "feb".equals(s)) {
            this._value = 2;
            return 6;
        }
        if ("march".equals(s) || "mar".equals(s)) {
            this._value = 3;
            return 6;
        }
        if ("april".equals(s) || "apr".equals(s)) {
            this._value = 4;
            return 6;
        }
        if ("may".equals(s)) {
            this._value = 5;
            return 6;
        }
        if ("june".equals(s) || "jun".equals(s)) {
            this._value = 6;
            return 6;
        }
        if ("july".equals(s) || "jul".equals(s)) {
            this._value = 7;
            return 6;
        }
        if ("august".equals(s) || "aug".equals(s)) {
            this._value = 8;
            return 6;
        }
        if ("september".equals(s) || "sep".equals(s) || "sept".equals(s)) {
            this._value = 9;
            return 6;
        }
        if ("october".equals(s) || "oct".equals(s)) {
            this._value = 10;
            return 6;
        }
        if ("november".equals(s) || "nov".equals(s)) {
            this._value = 11;
            return 6;
        }
        if ("december".equals(s) || "dec".equals(s)) {
            this._value = 12;
            return 6;
        }
        if ("sunday".equals(s) || "sun".equals(s)) {
            this._weekday = 0;
            return 7;
        }
        if ("monday".equals(s) || "mon".equals(s)) {
            this._weekday = 1;
            return 7;
        }
        if ("tuesday".equals(s) || "tue".equals(s) || "tues".equals(s)) {
            this._weekday = 2;
            return 7;
        }
        if ("wednesday".equals(s) || "wed".equals(s) || "wednes".equals(s)) {
            this._weekday = 3;
            return 7;
        }
        if ("thursday".equals(s) || "thu".equals(s) || "thur".equals(s) || "thurs".equals(s)) {
            this._weekday = 4;
            return 7;
        }
        if ("friday".equals(s) || "fri".equals(s)) {
            this._weekday = 5;
            return 7;
        }
        if ("saturday".equals(s) || "sat".equals(s)) {
            this._weekday = 6;
            return 7;
        }
        if ("z".equals(s) || "gmt".equals(s) || "utc".equals(s)) {
            return 8;
        }
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    private void skipSpaces() {
        block0: while (true) {
            if (Character.isWhitespace((char)(ch = this.read()))) {
                continue;
            }
            if (ch != 40) break;
            ch = this.read();
            while (true) {
                if (ch > 0 && ch != 41) ** break;
                continue block0;
                ch = this.read();
            }
            break;
        }
        this.unread();
    }

    private int read() {
        if (this._index < this._length) {
            return this._s.charAt(this._index++);
        }
        ++this._index;
        return -1;
    }

    private void unread() {
        --this._index;
    }
}

