/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.date;

import com.caucho.quercus.UnimplementedException;
import com.caucho.quercus.annotation.NotNull;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.annotation.ReturnNullAsFalse;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.DoubleValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.date.DateParser;
import com.caucho.quercus.lib.date.DateTime;
import com.caucho.quercus.lib.date.DateTimeZone;
import com.caucho.quercus.module.AbstractQuercusModule;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.util.QDate;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateModule
extends AbstractQuercusModule {
    private static final L10N L = new L10N(DateModule.class);
    private static final Logger log = Logger.getLogger(DateModule.class.getName());
    public static final int CAL_GREGORIAN = 0;
    public static final int CAL_JULIAN = 1;
    private static final String[] _shortDayOfWeek = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
    private static final String[] _fullDayOfWeek = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
    private static final String[] _shortMonth = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private static final String[] _fullMonth = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    private static final HashMap<StringValue, Value> _constMap = new HashMap();

    @Override
    public String[] getLoadedExtensions() {
        return new String[]{"date"};
    }

    public static int cal_days_in_month(Env env, int cal, int month, int year) {
        QDate date = env.getDate();
        date.setGMTTime(env.getCurrentTime());
        date.setYear(year);
        date.setMonth(month - 1);
        return date.getDaysInMonth();
    }

    public static boolean checkdate(Env env, int month, int day, int year) {
        if (1 > year || year > Short.MAX_VALUE) {
            return false;
        }
        if (1 > month || month > 12) {
            return false;
        }
        return 1 <= day && day <= DateModule.cal_days_in_month(env, 0, month, year);
    }

    public StringValue date(Env env, StringValue format, @Optional(value="-1") long time) {
        if (time < 0L) {
            time = DateModule.time(env);
        }
        return this.date(env, format, time, false);
    }

    public Value idate(Env env, StringValue format, @Optional(value="-1") long time) {
        if (format.length() != 1) {
            log.log(Level.FINE, L.l("idate format '{0}' needs to be of length one and only one", (Object)format));
            env.warning(L.l("idate format '{0}' needs to be of length one and only one", (Object)format));
            return BooleanValue.FALSE;
        }
        if (time < 0L) {
            time = DateModule.time(env);
        }
        switch (format.charAt(0)) {
            case 'B': 
            case 'H': 
            case 'I': 
            case 'L': 
            case 'U': 
            case 'W': 
            case 'Y': 
            case 'Z': 
            case 'd': 
            case 'h': 
            case 'i': 
            case 'm': 
            case 's': 
            case 't': 
            case 'w': 
            case 'y': 
            case 'z': {
                StringValue dateString = this.date(env, format, time, false);
                int sign = 1;
                long result = 0L;
                int length = dateString.length();
                for (int i = 0; i < length; ++i) {
                    char ch = dateString.charAt(i);
                    if ('0' <= ch && ch <= '9') {
                        result = result * 10L + (long)ch - 48L;
                        continue;
                    }
                    if (ch == '-' && i == 0) {
                        sign = -1;
                        continue;
                    }
                    log.log(Level.FINEST, L.l("error parsing idate string '{0}'", (Object)dateString));
                    break;
                }
                return LongValue.create(result * (long)sign);
            }
        }
        log.log(Level.FINE, L.l("'{0}' is not a valid idate format", (Object)format));
        env.warning(L.l("'{0}' is not a valid idate format", (Object)format));
        return BooleanValue.FALSE;
    }

    public static long easter_date(Env env, @Optional(value="-1") int year) {
        long now = env.getCurrentTime();
        QDate date = env.getDate();
        date.setGMTTime(now);
        if (year < 0) {
            date.setGMTTime(now);
            year = date.getYear();
        }
        int y = year;
        int c = y / 100;
        int n = y - 19 * (y / 19);
        int k = (c - 17) / 25;
        int i = c - c / 4 - (c - k) / 3 + 19 * n + 15;
        i -= 30 * (i / 30);
        i -= i / 28 * (1 - i / 28 * (29 / (i + 1)) * ((21 - n) / 11));
        int j = y + y / 4 + i + 2 - c + c / 4;
        j -= 7 * (j / 7);
        int l = i - j;
        int m = 3 + (l + 40) / 44;
        int d = l + 28 - 31 * (m / 4);
        date.setYear(year);
        date.setMonth(m - 1);
        date.setDayOfMonth(d);
        return date.getGMTTime() / 1000L;
    }

    public static long easter_days(Env env, @Optional(value="-1") int year, @Optional int method) {
        return DateModule.easter_date(env, year);
    }

    public Value getdate(Env env, @Optional Value timeV) {
        QDate date = env.getDate();
        long time = timeV.isDefault() ? env.getCurrentTime() : timeV.toLong() * 1000L;
        date.setGMTTime(time);
        ArrayValueImpl array = new ArrayValueImpl();
        array.put("seconds", date.getSecond());
        array.put("minutes", date.getMinute());
        array.put("hours", date.getHour());
        array.put("mday", date.getDayOfMonth());
        array.put("wday", date.getDayOfWeek() - 1);
        array.put("mon", date.getMonth() + 1);
        array.put("year", date.getYear());
        array.put("yday", date.getDayOfYear());
        array.put("weekday", _fullDayOfWeek[date.getDayOfWeek() - 1]);
        array.put("month", _fullMonth[date.getMonth()]);
        array.put(LongValue.ZERO, LongValue.create(time / 1000L));
        return array;
    }

    public Value gettimeofday(Env env, @Optional boolean isFloatReturn) {
        long gmtTime = env.getExactTime();
        if (isFloatReturn) {
            return new DoubleValue((double)gmtTime / 1000.0);
        }
        ArrayValueImpl result = new ArrayValueImpl();
        TimeZone localTimeZone = TimeZone.getDefault();
        long sec = gmtTime / 1000L;
        long microsec = (gmtTime - sec * 1000L) * 1000L;
        long minutesWest = (long)localTimeZone.getRawOffset() / 1000L / 60L * -1L;
        long dstTime = localTimeZone.useDaylightTime() ? 1L : 0L;
        result.put("sec", sec);
        result.put("usec", microsec);
        result.put("minuteswest", minutesWest);
        result.put("dsttime", dstTime);
        return result;
    }

    public StringValue gmdate(Env env, StringValue format, @Optional(value="-1") long time) {
        if (time < 0L) {
            time = DateModule.time(env);
        }
        return this.date(env, format, time, true);
    }

    public long gmmktime(Env env, @Optional Value hourV, @Optional Value minuteV, @Optional Value secondV, @Optional Value monthV, @Optional Value dayV, @Optional Value yearV) {
        QDate date = env.getGmtDate();
        long now = env.getCurrentTime();
        date.setLocalTime(now);
        long gmtNow = date.getGMTTime();
        date.setGMTTime(gmtNow);
        DateModule.setMktime(date, hourV, minuteV, secondV, monthV, dayV, yearV);
        return date.getGMTTime() / 1000L;
    }

    public String gmstrftime(Env env, String format, @Optional(value="-1") long phpTime) {
        long time = phpTime == -1L ? env.getCurrentTime() : 1000L * phpTime;
        return QDate.formatGMT(time, format);
    }

    public double gregoriantojd(int month, int day, int year) {
        if (month <= 2) {
            --year;
            month += 12;
        }
        long a = year / 100;
        long b = a / 4L;
        long c = 2L - a + b;
        long e = (long)(365.25 * (double)(year + 4716));
        long f = (long)(30.6001 * (double)(month + 1));
        return (double)(c + (long)day + e + f) - 1524.5;
    }

    private StringValue date(Env env, StringValue format, long time, boolean isGMT) {
        if (format == null) {
            return null;
        }
        if (isGMT) {
            return DateModule.dateImpl(env, format, time, env.getGmtDate());
        }
        QDate calendar = env.getDate();
        return DateModule.dateImpl(env, format, time, calendar);
    }

    protected static StringValue dateImpl(Env env, StringValue format, long time, QDate calendar) {
        long now = 1000L * time;
        calendar.setGMTTime(now);
        CharBuffer sb = CharBuffer.allocate();
        int len = format.length();
        block43: for (int i = 0; i < len; ++i) {
            char ch = format.charAt(i);
            switch (ch) {
                case 'd': {
                    int day = calendar.getDayOfMonth();
                    sb.append(day / 10);
                    sb.append(day % 10);
                    continue block43;
                }
                case 'D': {
                    int day = calendar.getDayOfWeek() - 1;
                    sb.append(_shortDayOfWeek[day]);
                    continue block43;
                }
                case 'j': {
                    int day = calendar.getDayOfMonth();
                    sb.append(day);
                    continue block43;
                }
                case 'l': {
                    int day = calendar.getDayOfWeek() - 1;
                    sb.append(_fullDayOfWeek[day]);
                    continue block43;
                }
                case 'N': {
                    int day = calendar.getDayOfWeek();
                    if (--day == 0) {
                        day = 7;
                    }
                    sb.append(day);
                    continue block43;
                }
                case 'S': {
                    int day = calendar.getDayOfMonth();
                    switch (day) {
                        case 1: 
                        case 21: 
                        case 31: {
                            sb.append("st");
                            continue block43;
                        }
                        case 2: 
                        case 22: {
                            sb.append("nd");
                            continue block43;
                        }
                        case 3: 
                        case 23: {
                            sb.append("rd");
                            continue block43;
                        }
                    }
                    sb.append("th");
                    continue block43;
                }
                case 'w': {
                    int day = calendar.getDayOfWeek() - 1;
                    sb.append(day);
                    continue block43;
                }
                case 'z': {
                    int day = calendar.getDayOfYear();
                    sb.append(day);
                    continue block43;
                }
                case 'W': {
                    int week = calendar.getWeek();
                    sb.append(week / 10);
                    sb.append(week % 10);
                    continue block43;
                }
                case 'F': {
                    int month = calendar.getMonth();
                    sb.append(_fullMonth[month]);
                    continue block43;
                }
                case 'm': {
                    int month = calendar.getMonth() + 1;
                    sb.append(month / 10);
                    sb.append(month % 10);
                    continue block43;
                }
                case 'M': {
                    int month = calendar.getMonth();
                    sb.append(_shortMonth[month]);
                    continue block43;
                }
                case 'n': {
                    int month = calendar.getMonth() + 1;
                    sb.append(month);
                    continue block43;
                }
                case 't': {
                    int days = calendar.getDaysInMonth();
                    sb.append(days);
                    continue block43;
                }
                case 'L': {
                    if (calendar.isLeapYear()) {
                        sb.append(1);
                        continue block43;
                    }
                    sb.append(0);
                    continue block43;
                }
                case 'o': {
                    int year = calendar.getYear();
                    int week = calendar.getWeek();
                    int month = calendar.getMonth();
                    if (month > week) {
                        ++year;
                    } else if (week == 53) {
                        --year;
                    }
                    sb.append(year / 1000 % 10);
                    sb.append(year / 100 % 10);
                    sb.append(year / 10 % 10);
                    sb.append(year % 10);
                    continue block43;
                }
                case 'Y': {
                    int year = calendar.getYear();
                    sb.append(year / 1000 % 10);
                    sb.append(year / 100 % 10);
                    sb.append(year / 10 % 10);
                    sb.append(year % 10);
                    continue block43;
                }
                case 'y': {
                    int year = calendar.getYear();
                    sb.append(year / 10 % 10);
                    sb.append(year % 10);
                    continue block43;
                }
                case 'a': {
                    int hour = calendar.getHour();
                    if (hour < 12) {
                        sb.append("am");
                        continue block43;
                    }
                    sb.append("pm");
                    continue block43;
                }
                case 'A': {
                    int hour = calendar.getHour();
                    if (hour < 12) {
                        sb.append("AM");
                        continue block43;
                    }
                    sb.append("PM");
                    continue block43;
                }
                case 'g': {
                    int hour = calendar.getHour() % 12;
                    if (hour == 0) {
                        hour = 12;
                    }
                    sb.append(hour);
                    continue block43;
                }
                case 'G': {
                    int hour = calendar.getHour();
                    sb.append(hour);
                    continue block43;
                }
                case 'h': {
                    int hour = calendar.getHour() % 12;
                    if (hour == 0) {
                        hour = 12;
                    }
                    sb.append(hour / 10);
                    sb.append(hour % 10);
                    continue block43;
                }
                case 'H': {
                    int hour = calendar.getHour();
                    sb.append(hour / 10);
                    sb.append(hour % 10);
                    continue block43;
                }
                case 'i': {
                    int minutes = calendar.getMinute();
                    sb.append(minutes / 10);
                    sb.append(minutes % 10);
                    continue block43;
                }
                case 's': {
                    int seconds = calendar.getSecond();
                    sb.append(seconds / 10);
                    sb.append(seconds % 10);
                    continue block43;
                }
                case 'e': {
                    TimeZone zone = calendar.getLocalTimeZone();
                    sb.append(zone.getID());
                    continue block43;
                }
                case 'I': {
                    if (calendar.isDST()) {
                        sb.append('1');
                        continue block43;
                    }
                    sb.append('0');
                    continue block43;
                }
                case 'O': {
                    long offset = calendar.getZoneOffset();
                    int minute = (int)(offset / 60000L);
                    if (minute < 0) {
                        sb.append('-');
                        minute = -1 * minute;
                    } else {
                        sb.append('+');
                    }
                    sb.append(minute / 60 / 10);
                    sb.append(minute / 60 % 10);
                    sb.append(minute % 60 % 10);
                    sb.append(minute % 10);
                    continue block43;
                }
                case 'P': {
                    long offset = calendar.getZoneOffset();
                    int minute = (int)(offset / 60000L);
                    if (minute < 0) {
                        sb.append('-');
                        minute = -1 * minute;
                    } else {
                        sb.append('+');
                    }
                    sb.append(minute / 60 / 10);
                    sb.append(minute / 60 % 10);
                    sb.append(':');
                    sb.append(minute % 60 % 10);
                    sb.append(minute % 10);
                    continue block43;
                }
                case 'T': {
                    TimeZone zone = calendar.getLocalTimeZone();
                    sb.append(zone.getDisplayName(calendar.isDST(), 0));
                    continue block43;
                }
                case 'Z': {
                    long offset = calendar.getZoneOffset();
                    sb.append(offset / 1000L);
                    continue block43;
                }
                case 'c': {
                    sb.append(calendar.printISO8601());
                    continue block43;
                }
                case 'r': {
                    calendar.printRFC2822(sb);
                    continue block43;
                }
                case 'U': {
                    sb.append(now / 1000L);
                    continue block43;
                }
                case '\\': {
                    sb.append(format.charAt(++i));
                    continue block43;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        char[] buffer = sb.getBuffer();
        return env.createString(buffer, 0, sb.getLength());
    }

    public ArrayValue localtime(Env env, @NotNull @Optional(value="-1") long time, @Optional(value="false") boolean isAssociative) {
        time = time < 0L ? env.getCurrentTime() : (time *= 1000L);
        QDate localCalendar = env.getLocalDate();
        localCalendar.setGMTTime(time);
        long sec = localCalendar.getSecond();
        long min = localCalendar.getMinute();
        long hour = localCalendar.getHour();
        long mday = localCalendar.getDayOfMonth();
        long mon = localCalendar.getMonth();
        long year = localCalendar.getYear();
        long wday = localCalendar.getDayOfWeek();
        long yday = localCalendar.getDayOfYear();
        long isdst = localCalendar.isDST() ? 1L : 0L;
        year -= 1900L;
        --wday;
        ArrayValueImpl value = new ArrayValueImpl();
        if (isAssociative) {
            value.put("tm_sec", sec);
            value.put("tm_min", min);
            value.put("tm_hour", hour);
            value.put("tm_mday", mday);
            value.put("tm_mon", mon);
            value.put("tm_year", year);
            value.put("tm_wday", wday);
            value.put("tm_yday", yday);
            value.put("tm_isdst", isdst);
        } else {
            value.put(sec);
            value.put(min);
            value.put(hour);
            value.put(mday);
            value.put(mon);
            value.put(year);
            value.put(wday);
            value.put(yday);
            value.put(isdst);
        }
        return value;
    }

    public static Value microtime(Env env, @Optional boolean getAsFloat) {
        double now = (double)env.getMicroTime() * 1.0E-6;
        if (getAsFloat) {
            return new DoubleValue(now);
        }
        return env.createUnicodeBuilder().append(String.format("%.6f", now - Math.floor(now))).append(' ').append((int)Math.floor(now));
    }

    public long mktime(Env env, @Optional Value hourV, @Optional Value minuteV, @Optional Value secondV, @Optional Value monthV, @Optional Value dayV, @Optional Value yearV, @Optional(value="-1") int isDST) {
        if (isDST != -1) {
            env.deprecatedArgument("isDST");
        }
        long now = env.getCurrentTime();
        QDate date = env.getDate();
        date.setGMTTime(now);
        DateModule.setMktime(date, hourV, minuteV, secondV, monthV, dayV, yearV);
        return date.getGMTTime() / 1000L;
    }

    private static void setMktime(QDate date, Value hourV, Value minuteV, Value secondV, Value monthV, Value dayV, Value yearV) {
        if (!hourV.isDefault()) {
            int hour = hourV.toInt();
            date.setHour(hour);
        }
        if (!minuteV.isDefault()) {
            int minute = minuteV.toInt();
            date.setMinute(minute);
        }
        if (!secondV.isDefault()) {
            int second = secondV.toInt();
            date.setSecond(second);
        }
        if (!monthV.isDefault()) {
            int month = monthV.toInt();
            date.setMonth(month - 1);
        }
        if (!dayV.isDefault()) {
            int day = dayV.toInt();
            date.setDayOfMonth(day);
        }
        if (!yearV.isDefault()) {
            int year = yearV.toInt();
            if (year >= 1000) {
                date.setYear(year);
            } else if (year >= 70) {
                date.setYear(year + 1900);
            } else if (year >= 0) {
                date.setYear(year + 2000);
            } else if (year < 0) {
                date.setYear(1969);
            }
        }
    }

    public static String strftime(Env env, String format, @Optional(value="-1") long phpTime) {
        long time = phpTime == -1L ? env.getCurrentTime() : 1000L * phpTime;
        if (format.contains("%p") || format.contains("%P")) {
            StringBuilder sb = new StringBuilder();
            int len = format.length();
            for (int i = 0; i < len; ++i) {
                char ch2;
                char ch = format.charAt(i);
                sb.append(ch);
                if (ch != '%' || i + 1 >= len) continue;
                if ((ch2 = format.charAt(++i)) == 'p') {
                    ch2 = 'P';
                } else if (ch2 == 'P') {
                    ch2 = 'p';
                }
                sb.append(ch2);
            }
            format = sb.toString();
        }
        return QDate.formatLocal(time, format);
    }

    public static Value strtotime(Env env, String timeString, @Optional(value="-1") long now) {
        try {
            now = now >= 0L ? 1000L * now : env.getCurrentTime();
            QDate date = env.getDate();
            date.setGMTTime(now);
            if (timeString == null || timeString.equals("")) {
                date.setHour(0);
                date.setMinute(0);
                date.setSecond(0);
                return new LongValue(date.getGMTTime() / 1000L);
            }
            DateParser parser = new DateParser(timeString, date);
            return new LongValue(parser.parse() / 1000L);
        }
        catch (Exception e) {
            env.warning(e);
            return BooleanValue.FALSE;
        }
    }

    public static long time(Env env) {
        return env.getCurrentTime() / 1000L;
    }

    public long jdtounix(Env env, double jd) {
        long z = (long)(jd + 0.5);
        long w = (long)(((double)z - 1867216.25) / 36524.25);
        long x = w / 4L;
        long a = z + 1L + w - x;
        long b = a + 1524L;
        long c = (long)(((double)b - 122.1) / 365.25);
        long d = (long)(365.25 * (double)c);
        long e = (long)((double)(b - d) / 30.6001);
        long f = (long)(30.6001 * (double)e);
        long day = b - d - f;
        long month = e - 1L;
        long year = c - 4716L;
        if (month > 12L) {
            month -= 12L;
            ++year;
        }
        QDate localCalendar = env.getLocalDate();
        localCalendar.setHour(0);
        localCalendar.setMinute(0);
        localCalendar.setSecond(0);
        localCalendar.setDayOfMonth((int)day);
        localCalendar.setMonth((int)(month - 1L));
        localCalendar.setYear((int)year);
        return localCalendar.getLocalTime() / 1000L;
    }

    public static DateTime date_create(Env env, @Optional Value time, @Optional DateTimeZone dateTimeZone) {
        if (time.isDefault()) {
            time = env.createString("now");
        }
        return DateTime.__construct(env, time, dateTimeZone);
    }

    public static void date_date_set(Env env, DateTime dateTime, int year, int month, int day) {
        if (dateTime == null) {
            env.warning(L.l("DateTime arg is null"));
            return;
        }
        dateTime.setDate(year, month, day);
    }

    public static String date_default_timezone_get(Env env) {
        TimeZone timeZone = env.getDefaultTimeZone();
        return timeZone.getID();
    }

    public static boolean date_default_timezone_set(Env env, String id) {
        env.setDefaultTimeZone(id);
        return true;
    }

    public static Value date_format(Env env, DateTime dateTime, StringValue format) {
        if (dateTime == null) {
            return BooleanValue.FALSE;
        }
        return dateTime.format(env, format);
    }

    public static void date_isodate_set(Env env, DateTime dateTime, int year, int week, int day) {
        if (dateTime == null) {
            env.warning(L.l("DateTime arg is null"));
            return;
        }
        dateTime.setISODate(year, week, day);
    }

    public static void date_modify(DateTime dateTime, StringValue modify) {
        dateTime.modify(modify);
    }

    public static long date_offset_get(DateTime dateTime) {
        if (dateTime == null) {
            return -1L;
        }
        return dateTime.getOffset();
    }

    public static Value date_parse(Env env, StringValue date) {
        DateTimeZone dateTimeZone = new DateTimeZone(env);
        QDate qDate = new QDate(dateTimeZone.getTimeZone(), env.getCurrentTime());
        DateParser parser = new DateParser(date, qDate);
        parser.parse();
        ArrayValueImpl array = new ArrayValueImpl();
        array.put("year", qDate.getYear());
        array.put("month", qDate.getMonth() + 1);
        array.put("day", qDate.getDayOfMonth());
        array.put("hour", qDate.getHour());
        array.put("minute", qDate.getMinute());
        array.put("second", qDate.getSecond());
        array.put("fraction", (double)qDate.getMillisecond() / 1000.0);
        return array;
    }

    public static ArrayValue date_sun_info(long time, double latitude, double longitude) {
        throw new UnimplementedException("date_sun_info");
    }

    public static Value date_sunrise(int timestamp, @Optional int format, @Optional double latitude, @Optional double longitude, @Optional double zenith, @Optional double gmtOffset) {
        throw new UnimplementedException("date_sunrise");
    }

    public static Value date_sunset(int timestamp, @Optional int format, @Optional double latitude, @Optional double longitude, @Optional double zenith, @Optional double gmtOffset) {
        throw new UnimplementedException("date_sunset");
    }

    public static void date_time_set(DateTime dateTime, int hour, int minute, @Optional int second) {
        dateTime.setTime(hour, minute, second);
    }

    public static Value date_timestamp_get(Env env, @NotNull DateTime dateTime) {
        if (dateTime == null) {
            return BooleanValue.FALSE;
        }
        long value = dateTime.getTimestamp();
        return LongValue.create(value);
    }

    public static void date_timestamp_set(Env env, @NotNull DateTime dateTime, long time) {
        if (dateTime == null) {
            return;
        }
        dateTime.setTimestamp(time);
    }

    public static DateTimeZone date_timezone_get(Env env, @NotNull DateTime dateTime) {
        if (dateTime == null) {
            return null;
        }
        return dateTime.getTimeZone();
    }

    @ReturnNullAsFalse
    public static DateTime date_timezone_set(Env env, @NotNull DateTime dateTime, @NotNull DateTimeZone dateTimeZone) {
        if (dateTime == null || dateTimeZone == null) {
            return null;
        }
        return dateTime.setTimeZone(env, dateTimeZone);
    }

    public static ArrayValue timezone_abbreviations_list() {
        return DateTimeZone.listAbbreviations();
    }

    public static ArrayValue timezone_identifiers_list() {
        return DateTimeZone.listIdentifiers();
    }

    public static Value timezone_name_from_abbr(StringValue abbr, @Optional(value="-1") int gmtOffset, @Optional boolean isDST) {
        if (gmtOffset == -1) {
            return DateTimeZone.findTimeZone(abbr);
        }
        return DateTimeZone.findTimeZone(abbr, gmtOffset, isDST);
    }

    public static String timezone_name_get(DateTimeZone dateTimeZone) {
        return dateTimeZone.getName();
    }

    public static long timezone_offset_get(DateTimeZone dateTimeZone, DateTime dateTime) {
        if (dateTimeZone == null) {
            return 0L;
        }
        return dateTimeZone.getOffset(dateTime);
    }

    public static DateTimeZone timezone_open(String timeZone) {
        return new DateTimeZone(timeZone);
    }

    public static Value timezone_transitions_get(DateTimeZone dateTimeZone, @Optional int start, @Optional int end) {
        return dateTimeZone.getTransitions(start, end);
    }

    @Override
    public Map<StringValue, Value> getConstMap() {
        return _constMap;
    }

    static {
        DateModule.addConstant(_constMap, "DATE_ATOM", "Y-m-d\\TH:i:sP");
        DateModule.addConstant(_constMap, "DATE_COOKIE", "l, d-M-y H:i:s T");
        DateModule.addConstant(_constMap, "DATE_ISO8601 ", "Y-m-d\\TH:i:sO");
        DateModule.addConstant(_constMap, "DATE_RFC822", "D, d M y H:i:s O");
        DateModule.addConstant(_constMap, "DATE_RFC850", "l, d-M-y H:i:s T");
        DateModule.addConstant(_constMap, "DATE_RFC1036", "D, d M y H:i:s O");
        DateModule.addConstant(_constMap, "DATE_RFC1123", "D, d M Y H:i:s O");
        DateModule.addConstant(_constMap, "DATE_RFC2822", "D, d M Y H:i:s O");
        DateModule.addConstant(_constMap, "DATE_RFC3339", "Y-m-d\\TH:i:sP");
        DateModule.addConstant(_constMap, "DATE_RSS", "D, d M Y H:i:s O");
        DateModule.addConstant(_constMap, "DATE_W3C", "Y-m-d\\TH:i:sP");
    }
}

