/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.curl;

import com.caucho.quercus.env.Callable;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.curl.CurlResource;
import com.caucho.quercus.lib.curl.MultipartBody;
import com.caucho.quercus.lib.curl.UrlEncodedBody;
import com.caucho.quercus.lib.curl.UserBody;
import com.caucho.quercus.lib.file.BinaryInput;
import java.io.IOException;
import java.io.OutputStream;

public abstract class PostBody {
    private boolean _isValid = true;

    static PostBody create(Env env, CurlResource curl) {
        Value data = curl.getPostBody();
        Callable bodyFun = curl.getReadCallback();
        BinaryInput file = curl.getUploadFile();
        long length = curl.getUploadFileSize();
        if (data == null && bodyFun == null) {
            return null;
        }
        PostBody post = bodyFun != null ? new UserBody(env, curl, bodyFun, file, length) : (data.isArray() ? new MultipartBody(env, data) : new UrlEncodedBody(env, data));
        if (post.isValid()) {
            return post;
        }
        return null;
    }

    public boolean isChunked() {
        return false;
    }

    public void setValid(boolean isValid) {
        this._isValid = isValid;
    }

    public boolean isValid() {
        return true;
    }

    public abstract long getContentLength();

    public abstract String getContentType();

    public abstract void writeTo(Env var1, OutputStream var2) throws IOException;
}

