/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib;

import com.caucho.network.listen.SocketLinkDuplexController;
import com.caucho.network.listen.SocketLinkDuplexListener;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.module.AbstractQuercusModule;
import com.caucho.server.http.CauchoRequest;
import com.caucho.util.L10N;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WebSocketModule
extends AbstractQuercusModule {
    private static final L10N L = new L10N(WebSocketModule.class);
    private static final Logger log = Logger.getLogger(WebSocketModule.class.getName());

    public static Value websocket_write(Env env, StringValue string) {
        try {
            OutputStream out = env.getResponse().getOutputStream();
            int length = string.length();
            out.write(0);
            for (int offset = 0; offset < length; ++offset) {
                char ch = string.charAt(offset);
                if ((ch & 0xF0) == 240) {
                    env.error("websocket_write expects utf-8 encoded string");
                }
                out.write(ch);
            }
            out.write(255);
            out.flush();
            return BooleanValue.TRUE;
        }
        catch (IOException e) {
            log.log(Level.WARNING, e.toString(), e);
            return BooleanValue.FALSE;
        }
    }

    public static Value websocket_read(Env env) {
        try {
            InputStream is = env.getRequest().getInputStream();
            int ch = is.read();
            while (Character.isWhitespace(ch)) {
                ch = is.read();
            }
            if (ch != 0) {
                log.fine("websocket_read expected 0x00 at '0x" + Integer.toHexString(ch) + "'");
                return BooleanValue.FALSE;
            }
            StringValue sb = env.createStringBuilder();
            while ((ch = is.read()) >= 0 && ch != 255) {
                int ch2;
                if (ch < 128) {
                    sb.append((char)ch);
                    continue;
                }
                if ((ch & 0xE0) == 192) {
                    ch2 = is.read();
                    if ((ch2 & 0x80) == 128) {
                        sb.append(ch);
                        sb.append(ch2);
                        continue;
                    }
                    log.fine("websocket_read expected 0x80 character at '0x" + Integer.toHexString(ch2) + "' for string " + sb);
                    sb.append(254L);
                    sb.append(221L);
                    continue;
                }
                if ((ch & 0xF0) == 224) {
                    ch2 = is.read();
                    int ch3 = is.read();
                    if ((ch2 & 0x80) == 128 && (ch3 & 0x80) == 128) {
                        sb.append(ch);
                        sb.append(ch2);
                        sb.append(ch3);
                        continue;
                    }
                    log.fine("websocket_read expected 0x80 character at  '0x" + Integer.toHexString(ch2) + "' '0x" + Integer.toHexString(ch3) + "' for string " + sb);
                    sb.append(254L);
                    sb.append(221L);
                    continue;
                }
                log.fine("websocket_read invalid lead character  '0x" + Integer.toHexString(ch) + "' for string " + sb);
                sb.append(254L);
                sb.append(221L);
            }
            if (ch != 255) {
                log.fine("websocket_read expected 0xff  '0x" + Integer.toHexString(ch) + "' for string " + sb);
            }
            return sb;
        }
        catch (IOException e) {
            log.log(Level.WARNING, e.toString(), e);
            return BooleanValue.FALSE;
        }
    }

    public static SocketLinkDuplexController websocket_start(Env env, StringValue path) {
        if (!(env.getRequest() instanceof CauchoRequest)) {
            env.warning("websocket_start requires a Resin request at " + env.getRequest());
            return null;
        }
        CauchoRequest request = (CauchoRequest)((Object)env.getRequest());
        String connection = request.getHeader("Connection");
        String upgrade = request.getHeader("Upgrade");
        if (!"WebSocket".equals(upgrade)) {
            env.warning("request Upgrade header '" + upgrade + "' must be 'WebSocket' for a websocket_start");
            return null;
        }
        if (!"Upgrade".equalsIgnoreCase(connection)) {
            env.warning("request connection header '" + connection + "' must be 'Upgrade' for a websocket_start");
            return null;
        }
        String origin = request.getHeader("Origin");
        if (origin == null) {
            env.warning("websocket_start requires an 'Origin' header in the request");
            return null;
        }
        env.getResponse().setStatus(101, "Web Socket Protocol Handshake");
        env.getResponse().setHeader("Upgrade", "WebSocket");
        String protocol = request.getHeader("WebSocket-Protocol");
        StringBuilder sb = new StringBuilder();
        if (request.isSecure()) {
            sb.append("wss://");
        } else {
            sb.append("ws://");
        }
        sb.append(request.getServerName());
        if (!request.isSecure() && request.getServerPort() != 80 || request.isSecure() && request.getServerPort() != 443) {
            sb.append(":");
            sb.append(request.getServerPort());
        }
        sb.append(request.getContextPath());
        if (request.getServletPath() != null) {
            sb.append(request.getServletPath());
        }
        String url = sb.toString();
        if (origin != null) {
            env.getResponse().setHeader("WebSocket-Origin", origin.toLowerCase(Locale.ENGLISH));
        }
        if (protocol != null) {
            env.getResponse().setHeader("WebSocket-Protocol", protocol);
        }
        env.getResponse().setHeader("WebSocket-Location", url);
        QuercusWebSocketListener listener = new QuercusWebSocketListener(env, path);
        SocketLinkDuplexController context = null;
        env.startDuplex(context);
        return context;
    }

    public static class QuercusWebSocketListener
    implements SocketLinkDuplexListener {
        private Env _env;
        private StringValue _path;

        QuercusWebSocketListener(Env env, StringValue path) {
            this._env = env;
            this._path = path;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onRead(SocketLinkDuplexController context) {
            boolean isValid = false;
            try {
                if (log.isLoggable(Level.FINE)) {
                    log.fine(this + " WebSocket read " + this._path);
                }
                this._env.include(this._path);
                isValid = true;
                Object var4_3 = null;
                if (!isValid) {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine(this + " WebSocket exit " + this._path);
                    }
                    context.complete();
                }
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (!isValid) {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine(this + " WebSocket exit " + this._path);
                    }
                    context.complete();
                }
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onDisconnect(SocketLinkDuplexController context) {
            try {
                this._env.closeDuplex();
                Object var3_2 = null;
                context.complete();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                context.complete();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onTimeout(SocketLinkDuplexController context) {
            try {
                this._env.closeDuplex();
                Object var3_2 = null;
                context.complete();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                context.complete();
                throw throwable;
            }
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this._path + "]";
        }

        public void onStart(SocketLinkDuplexController context) throws IOException {
        }
    }
}

