/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib;

import com.caucho.VersionFactory;
import com.caucho.quercus.QuercusModuleException;
import com.caucho.quercus.annotation.NotNull;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.annotation.ReadOnly;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.SaveState;
import com.caucho.quercus.env.StringBuilderValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.VariableModule;
import com.caucho.quercus.module.AbstractQuercusModule;
import com.caucho.util.L10N;
import com.caucho.util.LruCache;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.ref.SoftReference;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.MutableConfiguration;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.UserTransaction;

public class ResinModule
extends AbstractQuercusModule {
    private static final L10N L = new L10N(ResinModule.class);
    private static final Logger log = Logger.getLogger(ResinModule.class.getName());
    public static final int XA_STATUS_ACTIVE = 0;
    public static final int XA_STATUS_MARKED_ROLLBACK = 1;
    public static final int XA_STATUS_PREPARED = 2;
    public static final int XA_STATUS_COMMITTED = 3;
    public static final int XA_STATUS_ROLLEDBACK = 4;
    public static final int XA_STATUS_UNKNOWN = 5;
    public static final int XA_STATUS_NO_TRANSACTION = 6;
    public static final int XA_STATUS_PREPARING = 7;
    public static final int XA_STATUS_COMMITTING = 8;
    public static final int XA_STATUS_ROLLING_BACK = 9;
    private static LruCache<String, SaveState> _saveState;
    private static WeakHashMap<ClassLoader, SoftReference<BeanManager>> _beanManagerMap;

    public static Value resin_string_to_binary(Env env, String string, @Optional String encoding) {
        if (encoding == null || encoding.length() == 0) {
            encoding = env.getScriptEncoding();
        }
        try {
            byte[] bytes = string.getBytes(encoding);
            return env.createBinaryBuilder(bytes);
        }
        catch (UnsupportedEncodingException e) {
            env.error(e);
            return BooleanValue.FALSE;
        }
    }

    public Object java_bean(String name) {
        BeanManager beanManager = this.getBeanManager();
        if (beanManager == null) {
            return null;
        }
        Set beans = beanManager.getBeans(name);
        if (beans.size() == 0) {
            return null;
        }
        Bean bean = beanManager.resolve(beans);
        CreationalContext env = beanManager.createCreationalContext(bean);
        return beanManager.getReference(bean, bean.getBeanClass(), env);
    }

    private BeanManager getBeanManager() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        SoftReference<BeanManager> beanManagerRef = _beanManagerMap.get(loader);
        BeanManager beanManager = beanManagerRef != null ? beanManagerRef.get() : null;
        if (beanManager == null) {
            try {
                beanManager = (BeanManager)new InitialContext().lookup("java:comp/BeanManager");
                beanManagerRef = new SoftReference<BeanManager>(beanManager);
                _beanManagerMap.put(loader, beanManagerRef);
            }
            catch (Exception e) {
                log.log(Level.FINER, e.toString(), e);
            }
        }
        return beanManager;
    }

    public static Object jndi_lookup(String name) {
        if (!name.startsWith("java:") && !name.startsWith("/")) {
            name = "java:comp/env/" + name;
        }
        try {
            InitialContext ic = new InitialContext();
            return ic.lookup(name);
        }
        catch (NamingException e) {
            log.log(Level.FINER, e.toString(), e);
            return null;
        }
    }

    public static String resin_version() {
        return VersionFactory.getFullVersion();
    }

    public static boolean xa_begin(Env env) {
        try {
            ResinModule.getUserTransaction().begin();
            return true;
        }
        catch (Exception e) {
            log.log(Level.FINE, e.getMessage(), e);
            env.warning(e);
            return false;
        }
    }

    public static boolean xa_commit(Env env) {
        try {
            ResinModule.getUserTransaction().commit();
            return true;
        }
        catch (Exception e) {
            log.log(Level.FINE, e.getMessage(), e);
            env.warning(e);
            return false;
        }
    }

    public static boolean xa_rollback(Env env) {
        try {
            ResinModule.getUserTransaction().rollback();
            return true;
        }
        catch (Exception e) {
            log.log(Level.FINE, e.getMessage(), e);
            env.warning(e);
            return false;
        }
    }

    public static boolean xa_rollback_only(Env env) {
        try {
            ResinModule.getUserTransaction().setRollbackOnly();
            return true;
        }
        catch (Exception e) {
            log.log(Level.FINE, e.getMessage(), e);
            env.warning(e);
            return false;
        }
    }

    public static boolean xa_set_timeout(Env env, int timeoutSeconds) {
        try {
            ResinModule.getUserTransaction().setTransactionTimeout(timeoutSeconds);
            return true;
        }
        catch (Exception e) {
            log.log(Level.FINE, e.getMessage(), e);
            env.warning(e);
            return false;
        }
    }

    public static int xa_status() {
        try {
            return ResinModule.getUserTransaction().getStatus();
        }
        catch (Exception e) {
            throw new QuercusModuleException(e);
        }
    }

    private static UserTransaction getUserTransaction() {
        try {
            InitialContext ic = new InitialContext();
            return (UserTransaction)ic.lookup("java:comp/UserTransaction");
        }
        catch (NamingException e) {
            throw new QuercusModuleException(e);
        }
    }

    public static ArrayValue mbean_explode(String name) {
        try {
            ArrayValueImpl exploded = new ArrayValueImpl();
            if (name == null) {
                name = "";
            }
            ObjectName objectName = new ObjectName(name);
            exploded.put(":domain:", objectName.getDomain());
            Hashtable<String, String> entries = objectName.getKeyPropertyList();
            for (Map.Entry<String, String> entry : entries.entrySet()) {
                exploded.put(entry.getKey(), entry.getValue());
            }
            return exploded;
        }
        catch (MalformedObjectNameException e) {
            throw new QuercusModuleException(e);
        }
    }

    public static String mbean_implode(@NotNull @ReadOnly ArrayValue exploded) {
        try {
            if (exploded == null) {
                return null;
            }
            Value domainValue = exploded.get(StringValue.create(":domain:"));
            String domain = domainValue.isNull() ? "*" : domainValue.toString();
            Hashtable<String, String> entries = new Hashtable<String, String>();
            for (Map.Entry<Value, Value> entry : exploded.entrySet()) {
                String key = entry.getKey().toString();
                String value = entry.getValue().toString();
                if (":domain:".equals(key)) continue;
                entries.put(key, value);
            }
            ObjectName objectName = entries.isEmpty() ? new ObjectName(domain + ":" + "*") : new ObjectName(domain, entries);
            return objectName.getCanonicalName();
        }
        catch (MalformedObjectNameException e) {
            throw new QuercusModuleException(e);
        }
    }

    public static boolean resin_dump_stack(Env env) {
        Thread.dumpStack();
        return true;
    }

    public static Value resin_var_dump(Env env, @ReadOnly Value[] args) {
        try {
            WriteStream out = Vfs.openWrite("stdout:");
            out.setNewlineString("\n");
            if (args != null) {
                for (Value v : args) {
                    if (v != null) {
                        v.varDump(env, out, 0, new IdentityHashMap<Value, String>());
                    }
                    out.println();
                }
            }
            out.close();
            return NullValue.NULL;
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public static boolean resin_restore_state(Env env) {
        if (_saveState == null) {
            return false;
        }
        SaveState saveState = _saveState.get(env.getSelfPath().getURL());
        if (saveState != null && !saveState.isModified()) {
            env.restoreState(saveState);
            return true;
        }
        return false;
    }

    public static boolean resin_save_state(Env env) {
        SaveState saveState;
        if (_saveState == null) {
            _saveState = new LruCache(256);
        }
        if ((saveState = env.saveState()) != null) {
            _saveState.put(env.getSelfPath().getURL(), saveState);
            return true;
        }
        return false;
    }

    public static boolean resin_clear_state(Env env) {
        if (_saveState == null) {
            return false;
        }
        String url = env.getSelfPath().getURL();
        SaveState saveState = _saveState.get(url);
        if (saveState != null) {
            _saveState.remove(url);
            return true;
        }
        return false;
    }

    public static void resin_clear_states() {
        if (_saveState != null) {
            _saveState.clear();
        }
    }

    public static QuercusDistcache resin_create_distcache(Env env, String name) {
        CacheManager manager = Caching.getCacheManager();
        MutableConfiguration cfg = new MutableConfiguration();
        Cache cache = manager.configureCache(name, cfg);
        return new QuercusDistcache(cache);
    }

    static {
        _beanManagerMap = new WeakHashMap();
    }

    public static class QuercusDistcache {
        private final Cache _cache;

        QuercusDistcache(Cache cache) {
            this._cache = cache;
        }

        public Value get(Env env, StringValue key) {
            String value = (String)this._cache.get(key.toString());
            if (value == null) {
                return NullValue.NULL;
            }
            return VariableModule.unserialize(env, new StringBuilderValue(value));
        }

        public Value put(Env env, StringValue key, Value value) {
            String sValue = VariableModule.serialize(env, value);
            this._cache.put(key.toString(), sValue);
            return value;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this._cache + "]";
        }
    }
}

