/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.InterpretedClosure;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.expr.ExprFactory;
import com.caucho.quercus.expr.VarExpr;
import com.caucho.quercus.parser.QuercusParser;
import com.caucho.quercus.program.Function;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClosureExpr
extends Expr {
    protected final Function _fun;
    protected final boolean _isInClassScope;
    protected final ArrayList<VarExpr> _useArgs;

    public ClosureExpr(Location location, Function fun, ArrayList<VarExpr> useArgs, boolean isInClassScope) {
        super(location);
        this._fun = fun;
        this._useArgs = useArgs;
        this._isInClassScope = isInClassScope;
    }

    public String getName() {
        return this._fun.getName();
    }

    public Function getFunction() {
        return this._fun;
    }

    @Override
    public String getFunctionLocation() {
        return " [" + this.getName() + "]";
    }

    @Override
    public Expr createRef(QuercusParser parser) {
        return parser.getFactory().createRef(this);
    }

    @Override
    public Expr createCopy(ExprFactory factory) {
        return this;
    }

    @Override
    public Value eval(Env env) {
        return this.evalImpl(env);
    }

    @Override
    public Value evalCopy(Env env) {
        return this.evalImpl(env);
    }

    private Value evalImpl(Env env) {
        Value qThis = NullValue.NULL;
        if (this._isInClassScope && this._fun.getInfo().hasThis()) {
            qThis = env.getThis();
        }
        return new InterpretedClosure(env, this._fun, qThis);
    }

    @Override
    public String toString() {
        return this.getName() + "()";
    }
}

