/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.AbstractBinaryExpr;
import com.caucho.quercus.expr.Expr;

public class BinaryEqExpr
extends AbstractBinaryExpr {
    public BinaryEqExpr(Location location, Expr left, Expr right) {
        super(location, left, right);
    }

    public BinaryEqExpr(Expr left, Expr right) {
        super(left, right);
    }

    public boolean isBoolean() {
        return true;
    }

    public Value eval(Env env) {
        return this.evalBoolean(env) ? BooleanValue.TRUE : BooleanValue.FALSE;
    }

    public boolean evalBoolean(Env env) {
        Value lValue = this._left.eval(env);
        Value rValue = this._right.eval(env);
        return lValue.eq(rValue);
    }

    public String toString() {
        return "(" + this._left + " == " + this._right + ")";
    }
}

