/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;

public class BinaryAppendExpr
extends Expr {
    private final Expr _value;
    private BinaryAppendExpr _next;

    protected BinaryAppendExpr(Expr value, BinaryAppendExpr next) {
        this._value = value;
        this._next = next;
    }

    public Expr getValue() {
        return this._value;
    }

    public BinaryAppendExpr getNext() {
        return this._next;
    }

    void setNext(BinaryAppendExpr next) {
        this._next = next;
    }

    public boolean isString() {
        return true;
    }

    public Value eval(Env env) {
        Value value = this._value.eval(env);
        StringValue sb = value.toStringBuilder(env);
        BinaryAppendExpr ptr = this._next;
        while (ptr != null) {
            Value ptrValue = ptr._value.eval(env);
            sb = sb.appendUnicode(ptrValue);
            ptr = ptr._next;
        }
        return sb;
    }

    public String evalString(Env env) {
        Value value = this._value.eval(env);
        StringValue sb = value.toStringBuilder(env);
        BinaryAppendExpr ptr = this._next;
        while (ptr != null) {
            sb = sb.appendUnicode(ptr._value.eval(env));
            ptr = ptr._next;
        }
        return sb.toString();
    }

    public Value evalConstantPrefix() {
        return this._value.evalConstantPrefix();
    }

    public Value evalConstantSuffix() {
        if (this._next != null) {
            return this._next.evalConstantSuffix();
        }
        return null;
    }

    public String toString() {
        if (this._next != null) {
            return "(" + this._value + " . " + this._next + ")";
        }
        return String.valueOf(this._value);
    }
}

