/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.AbstractBinaryExpr;
import com.caucho.quercus.expr.Expr;

public class BinaryAddExpr
extends AbstractBinaryExpr {
    protected BinaryAddExpr(Location location, Expr left, Expr right) {
        super(location, left, right);
    }

    protected BinaryAddExpr(Expr left, Expr right) {
        super(left, right);
    }

    public Value eval(Env env) {
        Value lValue = this._left.eval(env);
        Value rValue = this._right.eval(env);
        return lValue.add(rValue);
    }

    public boolean isDouble() {
        return this._left.isDouble() || this._right.isDouble();
    }

    public boolean isLong() {
        return this._left.isLong() && this._right.isLong();
    }

    public boolean isNumber() {
        return true;
    }

    public String toString() {
        return "(" + this._left + " + " + this._right + ")";
    }
}

