/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.Var;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.expr.ExprFactory;
import com.caucho.quercus.parser.QuercusParser;
import com.caucho.quercus.statement.Statement;

public abstract class AbstractVarExpr
extends Expr {
    public AbstractVarExpr(Location location) {
        super(location);
    }

    public AbstractVarExpr() {
    }

    public boolean isVar() {
        return true;
    }

    public void assign(QuercusParser parser) {
    }

    public Expr createAssign(QuercusParser parser, Expr value) {
        return value.createAssignFrom(parser, this);
    }

    public Expr createAssignRef(QuercusParser parser, Expr value) {
        return parser.getExprFactory().createAssignRef(this, value);
    }

    public Expr createRef(QuercusParser parser) {
        return parser.getExprFactory().createRef(this);
    }

    public Expr createCopy(ExprFactory factory) {
        return factory.createCopy(this);
    }

    public Statement createUnset(ExprFactory factory, Location location) {
        return factory.createExpr(location, factory.createUnsetVar(this));
    }

    public abstract Value eval(Env var1);

    public abstract Var evalVar(Env var1);

    public Value evalRef(Env env) {
        return this.evalVar(env);
    }

    public Value evalArg(Env env, boolean isTop) {
        return this.evalVar(env);
    }

    public Value evalCopy(Env env) {
        return this.eval(env).copy();
    }

    public Value evalArray(Env env) {
        return this.evalVar(env).toAutoArray();
    }

    public Value evalObject(Env env) {
        return this.evalVar(env).toObject(env);
    }

    public abstract void evalUnset(Env var1);

    public Value evalAssignValue(Env env, Value value) {
        return this.evalAssignRef(env, value);
    }

    public abstract Value evalAssignRef(Env var1, Value var2);
}

