/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.QuercusModuleException;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.ArrayValueWrapper;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.SerializeMap;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.UnserializeReader;
import com.caucho.util.CacheListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionArrayValue
extends ArrayValueWrapper
implements CacheListener,
Serializable {
    protected static final Logger log = Logger.getLogger(SessionArrayValue.class.getName());
    private String _id;
    private AtomicInteger _useCount = new AtomicInteger();
    protected long _accessTime;
    private long _maxInactiveInterval;
    private boolean _isValid;

    public SessionArrayValue(String id, long now, long maxInactiveInterval) {
        this(id, now, maxInactiveInterval, new ArrayValueImpl());
    }

    public SessionArrayValue(String id, long now, long maxInactiveInterval, ArrayValue array) {
        super(array);
        this._id = id;
        this._accessTime = now;
        this._maxInactiveInterval = maxInactiveInterval;
    }

    public String getId() {
        return this._id;
    }

    public void setId(String id) {
        this._id = id;
    }

    @Override
    public Object toObject() {
        return null;
    }

    @Override
    public Value copy(Env env, IdentityHashMap<Value, Value> map) {
        long accessTime = this._accessTime;
        SessionArrayValue copy = new SessionArrayValue(this._id, accessTime, this._maxInactiveInterval, (ArrayValue)this.getArray().copy(env, map));
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String encode(Env env) {
        StringBuilder sb = new StringBuilder();
        ArrayValue array = this.getArray();
        SerializeMap serializeMap = new SerializeMap();
        ArrayValue arrayValue = array;
        synchronized (arrayValue) {
            for (Map.Entry<Value, Value> entry : array.entrySet()) {
                sb.append(entry.getKey().toString());
                sb.append("|");
                entry.getValue().serialize(env, sb, serializeMap);
            }
        }
        return sb.toString();
    }

    public boolean decode(Env env, StringValue encoded) {
        ArrayValue array = this.getArray();
        try {
            UnserializeReader is = new UnserializeReader(encoded);
            ArrayValue arrayValue = array;
            synchronized (arrayValue) {
                while (true) {
                    int ch;
                    StringValue sb = env.createUnicodeBuilder();
                    while ((ch = is.read()) > 0 && ch != 124) {
                        sb.append((char)ch);
                    }
                    if (sb.length() == 0) {
                        return true;
                    }
                    array.put(sb, is.unserialize(env));
                }
            }
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public boolean inUse() {
        return this._useCount.get() > 0;
    }

    public void addUse() {
        this._useCount.incrementAndGet();
    }

    public boolean load() {
        return true;
    }

    public void store(Env env, OutputStream out) throws IOException {
        String encode = this.encode(env);
        int len = encode.length();
        out.write(len >> 24);
        out.write(len >> 16);
        out.write(len >> 8);
        out.write(len);
        for (int i = 0; i < len; ++i) {
            char ch = encode.charAt(i);
            out.write(ch >> 8);
            out.write(ch);
        }
    }

    public void load(Env env, InputStream in) throws IOException {
        int len = ((in.read() & 0xFF) << 24) + ((in.read() & 0xFF) << 16) + ((in.read() & 0xFF) << 8) + (in.read() & 0xFF);
        StringValue sb = env.createUnicodeBuilder();
        for (int i = 0; i < len; ++i) {
            char ch = (char)(((in.read() & 0xFF) << 8) + (in.read() & 0xFF));
            sb.append(ch);
        }
        this.decode(env, sb);
    }

    public void finish() {
        int count = this._useCount.decrementAndGet();
        if (count > 0) {
            return;
        }
        if (count < 0) {
            throw new IllegalStateException();
        }
        this.store();
    }

    public void storeOnShutdown() {
        this.store();
    }

    protected void store() {
    }

    public long getMaxInactiveInterval() {
        return this._maxInactiveInterval;
    }

    public void reset(long now) {
        this.setValid(true);
        this.setAccess(now);
        this.clear();
    }

    public long getAccessTime() {
        return this._accessTime;
    }

    public void setAccess(long now) {
        this._accessTime = now;
    }

    public boolean isValid() {
        return this._isValid;
    }

    public void setValid(boolean isValid) {
        this._isValid = isValid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate() {
        if (!this._isValid) {
            throw new IllegalStateException(L.l("Can't call invalidate() when session is no longer valid."));
        }
        try {
            this.remove();
            this.clear();
        }
        finally {
            this._isValid = false;
        }
    }

    protected void remove() {
    }

    @Override
    public boolean isEmpty() {
        return this.getSize() == 0;
    }

    @Override
    public void removeEvent() {
    }

    private Object writeReplace() {
        return new ArrayValueImpl(this);
    }
}

