/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.env.Closure;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.function.AbstractFunction;
import com.caucho.quercus.program.Arg;

public class InterpretedClosure
extends Closure {
    private final AbstractFunction _fun;
    private final Value[] _args;

    public InterpretedClosure(Env env, AbstractFunction fun, Value qThis) {
        super(fun.getName(), qThis);
        this._fun = fun;
        Arg[] args = fun.getClosureUseArgs();
        if (args != null && args.length > 0) {
            this._args = new Value[args.length];
            for (int i = 0; i < args.length; ++i) {
                Arg arg = args[i];
                this._args[i] = arg.isReference() ? env.getRef(arg.getName()) : env.getValue(arg.getName());
            }
        } else {
            this._args = null;
        }
    }

    public String getDeclFileName(Env env) {
        return this._fun.getDeclFileName(env);
    }

    public int getDeclStartLine(Env env) {
        return this._fun.getDeclStartLine(env);
    }

    public int getDeclEndLine(Env env) {
        return this._fun.getDeclEndLine(env);
    }

    public String getDeclComment(Env env) {
        return this._fun.getDeclComment(env);
    }

    public boolean isReturnsReference(Env env) {
        return this._fun.isReturnsReference(env);
    }

    public Arg[] getArgs(Env env) {
        return this._fun.getArgs(env);
    }

    public boolean isInternal(Env env) {
        return this._fun.isInternal(env);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value call(Env env, Value[] args) {
        Value oldThis = env.setThis(this.getThis());
        Closure oldClosure = env.setClosure(this);
        try {
            Value value = this._fun.callClosure(env, args, this._args);
            return value;
        }
        finally {
            env.setClosure(oldClosure);
            env.setThis(oldThis);
        }
    }
}

