/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.naming;

import com.caucho.loader.EnvironmentLocal;
import com.caucho.naming.ContextImpl;
import com.caucho.naming.InitialContextFactoryImpl;
import com.caucho.util.L10N;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingException;

public class Jndi {
    private static Logger log = Logger.getLogger(Jndi.class.getName());
    private static L10N L = new L10N(Jndi.class);
    private static final EnvironmentLocal<Context> _javaCompEnvMap = new EnvironmentLocal();

    private Jndi() {
    }

    public static String getFullName(String shortName) {
        if (shortName.startsWith("java:")) {
            return shortName;
        }
        return "java:comp/env/" + shortName;
    }

    private static Context getShortContext(String shortName) throws NamingException {
        if (shortName.startsWith("java:")) {
            return Jndi.getInitialContext();
        }
        Context context = _javaCompEnvMap.getLevel();
        if (context == null) {
            context = (Context)new InitialContext().lookup("java:comp/env");
            _javaCompEnvMap.set(context);
        }
        return context;
    }

    public static void bindDeepShort(String name, Object obj) throws NamingException {
        String fullName = Jndi.getFullName(name);
        Context context = Jndi.getShortContext(name);
        Jndi.bindImpl(context, name, obj, fullName);
    }

    public static void bindDeepShort(Context context, String name, Object obj) throws NamingException {
        Jndi.bindImpl(context, Jndi.getFullName(name), obj, name);
    }

    public static void bindDeep(String name, Object obj) throws NamingException {
        Jndi.bindImpl(Jndi.getInitialContext(), name, obj, name);
    }

    public static void bindDeep(Context context, String name, Object obj) throws NamingException {
        Jndi.bindImpl(context, name, obj, name);
    }

    private static Context getInitialContext() throws NamingException {
        return InitialContextFactoryImpl.createInitialContext();
    }

    private static void bindImpl(Context context, String name, Object obj, String fullName) throws NamingException {
        NameParser parser = context.getNameParser("");
        Name parsedName = parser.parse(name);
        if (parsedName.size() == 1) {
            Object value = null;
            try {
                value = context instanceof ContextImpl ? ((ContextImpl)context).lookupLink(name) : context.lookupLink(name);
            }
            catch (NameNotFoundException e) {
                // empty catch block
            }
            context.rebind(name, obj);
            if (value != null && value != obj) {
                log.config(L.l("'{0}' overrides a previous JNDI resource.  The old resource is '{1}' and the new one is '{2}'", (Object)fullName, value, obj));
            }
            return;
        }
        Object sub = null;
        try {
            sub = context instanceof ContextImpl ? ((ContextImpl)context).lookupImpl(parsedName.get(0)) : context.lookup(parsedName.get(0));
        }
        catch (NameNotFoundException e) {
            // empty catch block
        }
        if (sub == null) {
            sub = context.createSubcontext(parsedName.get(0));
        }
        if (!(sub instanceof Context)) {
            throw new NamingException(L.l("'{0}' is an invalid JNDI name because '{1} is not a Context.  One of the subcontexts is not a Context as expected.", (Object)fullName, sub));
        }
        Jndi.bindImpl((Context)sub, parsedName.getSuffix(1).toString(), obj, fullName);
    }

    public static void rebindDeepShort(String name, Object obj) throws NamingException {
        Jndi.rebindImpl(new InitialContext(), Jndi.getFullName(name), obj, name);
    }

    public static void rebindDeepShort(Context context, String name, Object obj) throws NamingException {
        Jndi.rebindImpl(context, Jndi.getFullName(name), obj, name);
    }

    public static void rebindDeep(String name, Object obj) throws NamingException {
        Jndi.rebindImpl(new InitialContext(), name, obj, name);
    }

    public static void rebindDeep(Context context, String name, Object obj) throws NamingException {
        Jndi.rebindImpl(context, name, obj, name);
    }

    private static void rebindImpl(Context context, String name, Object obj, String fullName) throws NamingException {
        NameParser parser = context.getNameParser("");
        Name parsedName = parser.parse(name);
        if (parsedName.size() == 1) {
            context.rebind(name, obj);
            return;
        }
        Object sub = null;
        try {
            sub = context.lookup(parsedName.get(0));
        }
        catch (NameNotFoundException e) {
            log.log(Level.FINEST, e.toString(), e);
        }
        if (sub == null) {
            sub = context.createSubcontext(parsedName.get(0));
        }
        if (!(sub instanceof Context)) {
            throw new NamingException(L.l("'{0}' is an invalid JNDI name because '{1} is not a Context.  One of the subcontexts is not a Context as expected.", (Object)fullName, sub));
        }
        Jndi.rebindImpl((Context)sub, parsedName.getSuffix(1).toString(), obj, fullName);
    }

    public static Object lookup(String name) {
        Object value;
        NamingException ex = null;
        try {
            value = new InitialContext().lookup(name);
            if (value != null) {
                return value;
            }
        }
        catch (NamingException e) {
            ex = e;
        }
        if (!name.startsWith("java:")) {
            try {
                value = new InitialContext().lookup("java:comp/env/" + name);
                if (value != null) {
                    return value;
                }
            }
            catch (NamingException e) {
                ex = e;
            }
        }
        if (ex != null && log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, ((Throwable)ex).toString(), ex);
        }
        return null;
    }
}

