/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.naming;

import com.caucho.naming.AbstractModel;
import com.caucho.naming.NamingExceptionWrapper;
import com.caucho.naming.ObjectProxy;
import com.caucho.naming.QBindingEnumeration;
import com.caucho.naming.QNameClassEnumeration;
import com.caucho.naming.QNameParser;
import com.caucho.util.L10N;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;
import javax.naming.Reference;
import javax.naming.spi.NamingManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextImpl
implements Context {
    protected static final Logger log = Logger.getLogger(ContextImpl.class.getName());
    protected static final L10N L = new L10N(ContextImpl.class);
    protected Hashtable<String, Object> _env;
    protected AbstractModel _model;
    protected String _name;

    public ContextImpl(AbstractModel model, Hashtable<String, Object> env) {
        this._model = model;
        this._env = env;
        this._name = "";
        if (this._model == null) {
            throw new NullPointerException();
        }
    }

    public ContextImpl(String name, AbstractModel model, Hashtable<String, Object> env) {
        this._model = model;
        this._env = env;
        this._name = name;
        if (this._model == null) {
            throw new NullPointerException();
        }
    }

    protected ContextImpl create(String name, AbstractModel model, Hashtable<String, Object> env) {
        return new ContextImpl(name, model, env);
    }

    protected final ContextImpl create(AbstractModel model, Hashtable<String, Object> env) {
        return this.create("", model, env);
    }

    public AbstractModel getModel() {
        return this._model;
    }

    public String getName() {
        return this._name;
    }

    @Override
    public Object lookup(String name) throws NamingException {
        Object value = this.lookupImpl(name);
        if (value == NullValue.NULL) {
            return null;
        }
        if (value != null) {
            return value;
        }
        throw new NameNotFoundException(this.getFullPath(name));
    }

    protected Object lookupImpl(String name) throws NamingException {
        String tail = name;
        AbstractModel model = this._model;
        while (tail != null) {
            String first = this.parseFirst(tail);
            String rest = this.parseRest(tail);
            if (first == null) {
                return this.create(this.getFullPath(name), model, this._env);
            }
            Object value = model.lookup(first);
            if (value instanceof AbstractModel) {
                model = (AbstractModel)value;
                tail = rest;
                continue;
            }
            value = this.dereference(value, null, model);
            if (rest == null) {
                return value;
            }
            if (value instanceof Context) {
                return ((Context)value).lookup(rest);
            }
            if (value != null) {
                throw new NotContextException(L.l("{0}: expected intermediate context at `{1}'", (Object)this.getFullPath(name), value));
            }
            throw new NameNotFoundException(this.getFullPath(name));
        }
        return this.create(this.getFullPath(name), model, this._env);
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        Object value = this.lookupImpl(name);
        if (value == NullValue.NULL) {
            return null;
        }
        if (value != null) {
            return value;
        }
        throw new NameNotFoundException(this.getFullPath(name));
    }

    private Object lookupImpl(Name name) throws NamingException {
        if (log.isLoggable(Level.FINEST)) {
            log.finest(L.l("JNDI lookup `{0}'", (Object)name));
        }
        if (name == null) {
            return this.create(this._model, this._env);
        }
        AbstractModel model = this._model;
        for (int i = 0; i < name.size(); ++i) {
            String first = name.get(i);
            Object value = model.lookup(first);
            if (!(value instanceof AbstractModel)) {
                value = this.dereference(value, null, model);
                if (i + 1 == name.size()) {
                    return value;
                }
                if (value instanceof Context) {
                    return ((Context)value).lookup(name.getSuffix(i + 1));
                }
                if (value != null) {
                    throw new NotContextException(L.l("{0}: expected intermediate context at `{1}'", (Object)this.getFullPath(name), value));
                }
                throw new NameNotFoundException(this.getFullPath(name));
            }
            model = (AbstractModel)value;
        }
        return this.create(this.getFullPath(name), model, this._env);
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        String tail = name;
        AbstractModel model = this._model;
        while (tail != null) {
            String first = this.parseFirst(tail);
            String rest = this.parseRest(tail);
            if (first == null) {
                return this.create(this.getFullPath(name), model, this._env);
            }
            Object value = model.lookup(first);
            if (value instanceof AbstractModel) {
                model = (AbstractModel)value;
                tail = rest;
                continue;
            }
            if (rest == null) {
                if (value == NullValue.NULL) {
                    return null;
                }
                if (value != null) {
                    return value;
                }
                throw new NameNotFoundException(this.getFullPath(name));
            }
            if ((value = this.dereference(value, null, model)) instanceof Context) {
                return ((Context)value).lookupLink(rest);
            }
            if (value != null) {
                throw new NotContextException(L.l("{0}: expected intermediate context at `{1}'", (Object)this.getFullPath(name), value));
            }
            throw new NameNotFoundException(this.getFullPath(name));
        }
        return this.create(this.getFullPath(name), model, this._env);
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        if (name == null) {
            return this.create(this._model, this._env);
        }
        AbstractModel model = this._model;
        for (int i = 0; i < name.size(); ++i) {
            String first = name.get(i);
            Object value = model.lookup(first);
            if (!(value instanceof AbstractModel)) {
                if (i + 1 == name.size()) {
                    if (value == NullValue.NULL) {
                        return null;
                    }
                    if (value != null) {
                        return value;
                    }
                    throw new NameNotFoundException(this.getFullPath(name));
                }
                if ((value = this.dereference(value, null, model)) instanceof Context) {
                    return ((Context)value).lookupLink(name.getSuffix(i + 1));
                }
                if (value != null) {
                    throw new NotContextException(L.l("{0}: expected intermediate context at `{1}'", (Object)this.getFullPath(name), value));
                }
                throw new NameNotFoundException(this.getFullPath(name));
            }
            model = (AbstractModel)value;
        }
        return this.create(this.getFullPath(name), model, this._env);
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        Object value;
        String rest;
        String tail = name;
        AbstractModel model = this._model;
        if (obj == null) {
            obj = NullValue.NULL;
        }
        while (true) {
            String first = this.parseFirst(tail);
            rest = this.parseRest(tail);
            if (first == null) {
                throw new NamingException(L.l("can't bind root"));
            }
            if (rest == null) {
                value = model.lookup(first);
                if (value != null) {
                    throw new NamingException(L.l("`{0}' is already bound to `{1}'", (Object)name, value));
                }
                model.bind(first, this.getReference(model, obj));
                return;
            }
            value = model.lookup(first);
            if (!(value instanceof AbstractModel)) break;
            model = (AbstractModel)value;
            tail = rest;
        }
        if ((value = this.dereference(value, null, model)) instanceof Context) {
            ((Context)value).bind(rest, obj);
            return;
        }
        if (value != null) {
            throw new NotContextException(L.l("{0}: expected intermediate context at `{1}'", (Object)this.getFullPath(name), value));
        }
        throw new NameNotFoundException(this.getFullPath(name));
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        Object value;
        String first;
        if (log.isLoggable(Level.FINEST)) {
            log.finest(L.l("JNDI bind `{0}'", (Object)name));
        }
        if (name.size() == 0) {
            throw new NamingException(L.l("can't bind root"));
        }
        AbstractModel model = this._model;
        int i = 0;
        while (i + 1 < name.size()) {
            first = name.get(i);
            value = model.lookup(first);
            if (!(value instanceof AbstractModel)) {
                if ((value = this.dereference(value, null, model)) instanceof Context) {
                    ((Context)value).bind(name.getSuffix(i + 1), obj);
                    return;
                }
                if (value != null) {
                    throw new NotContextException(L.l("{0}: expected intermediate context at `{1}'", (Object)this.getFullPath(name), value));
                }
                throw new NameNotFoundException(this.getFullPath(name));
            }
            model = (AbstractModel)value;
            ++i;
        }
        first = name.get(i);
        value = model.lookup(first);
        if (value != null) {
            throw new NamingException(L.l("`{0}' is already bound to `{1}'", (Object)name, value));
        }
        if (obj == null) {
            obj = NullValue.NULL;
        }
        model.bind(first, this.getReference(model, obj));
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        Object value;
        String rest;
        String first;
        if (log.isLoggable(Level.FINEST)) {
            log.finest(L.l("JNDI rebind `{0}' value: {1}", (Object)name, obj));
        }
        String tail = name;
        AbstractModel model = this._model;
        if (obj == null) {
            obj = NullValue.NULL;
        }
        while (true) {
            first = this.parseFirst(tail);
            rest = this.parseRest(tail);
            if (first == null) {
                throw new NamingException(L.l("can't bind root"));
            }
            if (rest == null) {
                model.bind(first, this.getReference(model, obj));
                return;
            }
            value = model.lookup(first);
            if (!(value instanceof AbstractModel)) break;
            model = (AbstractModel)value;
            tail = rest;
        }
        if ((value = this.dereference(value, null, model)) instanceof Context) {
            ((Context)value).rebind(rest, obj);
            return;
        }
        if (value != null) {
            throw new NotContextException(L.l("{0}: expected intermediate context at '{1}'\n  {2}", (Object)this.getFullPath(name), value, (Object)Thread.currentThread().getContextClassLoader()));
        }
        throw new NameNotFoundException(L.l("{0}: JNDI rebind requires the parent Context '{1}' to be created but it is null.\n  {2}',", (Object)this.getFullPath(name), (Object)first, (Object)Thread.currentThread().getContextClassLoader()));
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        String first;
        if (name.size() == 0) {
            throw new NamingException(L.l("can't bind root"));
        }
        AbstractModel model = this._model;
        int i = 0;
        while (i + 1 < name.size()) {
            first = name.get(i);
            Object value = model.lookup(first);
            if (!(value instanceof AbstractModel)) {
                if ((value = this.dereference(value, null, model)) instanceof Context) {
                    ((Context)value).bind(name.getSuffix(i + 1), obj);
                    return;
                }
                if (value != null) {
                    throw new NotContextException(L.l("{0}: expected intermediate context at `{1}'", (Object)this.getFullPath(name), value));
                }
                throw new NameNotFoundException(this.getFullPath(name));
            }
            model = (AbstractModel)value;
            ++i;
        }
        first = name.get(i);
        if (obj == null) {
            obj = NullValue.NULL;
        }
        model.bind(first, this.getReference(model, obj));
    }

    private Object getReference(AbstractModel model, Object obj) {
        return obj;
    }

    @Override
    public void unbind(String name) throws NamingException {
        this.unbindImpl(name, false);
    }

    private void unbindImpl(String name, boolean isRename) throws NamingException {
        Object value;
        String rest;
        String tail = name;
        AbstractModel model = this._model;
        while (true) {
            String first = this.parseFirst(tail);
            rest = this.parseRest(tail);
            if (first == null) {
                throw new NamingException(L.l("can't unbind root"));
            }
            if (rest == null) {
                if (!isRename && model.lookup(name) instanceof AbstractModel) {
                    throw new NamingException(L.l("can't unbind subcontext; use destroySubcontext"));
                }
                model.unbind(first);
                return;
            }
            value = model.lookup(first);
            if (!(value instanceof AbstractModel)) break;
            model = (AbstractModel)value;
            tail = rest;
        }
        if ((value = this.dereference(value, null, model)) instanceof Context) {
            ((Context)value).unbind(rest);
            return;
        }
        if (value != null) {
            throw new NotContextException(L.l("{0}: expected intermediate context at `{1}'", (Object)this.getFullPath(name), value));
        }
        throw new NameNotFoundException(this.getFullPath(name));
    }

    private Object dereference(Object value, Name tail, AbstractModel model) throws NamingException {
        try {
            if (value instanceof ObjectProxy) {
                return ((ObjectProxy)value).createObject(this._env);
            }
            if (value instanceof Reference) {
                ContextImpl context = this.create(model, this._env);
                return NamingManager.getObjectInstance(value, null, context, this._env);
            }
            return value;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (NamingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new NamingExceptionWrapper(e);
        }
    }

    @Override
    public void unbind(Name name) throws NamingException {
        String first;
        if (name.size() == 0) {
            throw new NamingException(L.l("can't unbind root"));
        }
        AbstractModel model = this._model;
        int i = 0;
        while (i + 1 < name.size()) {
            first = name.get(i);
            Object value = model.lookup(first);
            if (!(value instanceof AbstractModel)) {
                if ((value = this.dereference(value, null, model)) instanceof Context) {
                    ((Context)value).unbind(name.getSuffix(i + 1));
                    return;
                }
                if (value != null) {
                    throw new NotContextException(L.l("{0}: expected intermediate context at `{1}'", (Object)this.getFullPath(name), value));
                }
                throw new NameNotFoundException(this.getFullPath(name));
            }
            model = (AbstractModel)value;
            ++i;
        }
        first = name.get(i);
        model.unbind(first);
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        Object value = this.lookup(oldName);
        this.unbindImpl(oldName, true);
        if (value instanceof ContextImpl) {
            ((ContextImpl)value).setName(newName);
        }
        this.bind(newName, value);
    }

    private void setName(String newName) {
        this._name = newName;
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        Object value = this.lookup(oldName);
        this.unbind(oldName);
        if (value instanceof ContextImpl) {
            ((ContextImpl)value).setName(newName.toString());
        }
        this.bind(newName, value);
    }

    public NamingEnumeration list(String name) throws NamingException {
        Object value;
        String rest;
        String tail = name;
        AbstractModel model = this._model;
        while (true) {
            String first = this.parseFirst(tail);
            rest = this.parseRest(tail);
            if (first == null) {
                return new QNameClassEnumeration(this.create(model, this._env), model.list());
            }
            value = model.lookup(first);
            if (!(value instanceof AbstractModel)) break;
            model = (AbstractModel)value;
            tail = rest;
        }
        if ((value = this.dereference(value, null, model)) instanceof Context) {
            if (rest == null) {
                return ((Context)value).list("");
            }
            return ((Context)value).list(rest);
        }
        if (value != null) {
            throw new NotContextException(L.l("{0}: expected intermediate context at `{1}'", (Object)this.getFullPath(name), value));
        }
        throw new NameNotFoundException(this.getFullPath(name));
    }

    public NamingEnumeration list(Name name) throws NamingException {
        AbstractModel model = this._model;
        if (name == null) {
            return new QNameClassEnumeration(this.create(model, this._env), model.list());
        }
        for (int i = 0; i < name.size(); ++i) {
            String first = name.get(i);
            Object value = model.lookup(first);
            if (!(value instanceof AbstractModel)) {
                if ((value = this.dereference(value, null, model)) instanceof Context) {
                    return ((Context)value).list(name.getSuffix(i + 1));
                }
                if (value != null) {
                    throw new NotContextException(L.l("{0}: expected intermediate context at `{1}'", (Object)this.getFullPath(name), value));
                }
                throw new NameNotFoundException(this.getFullPath(name));
            }
            model = (AbstractModel)value;
        }
        return new QNameClassEnumeration(this.create(model, this._env), model.list());
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        Object value;
        String rest;
        String tail = name;
        AbstractModel model = this._model;
        while (true) {
            String first = this.parseFirst(tail);
            rest = this.parseRest(tail);
            if (first == null) {
                return new QBindingEnumeration(this.create(model, this._env), model.list());
            }
            value = model.lookup(first);
            if (!(value instanceof AbstractModel)) break;
            model = (AbstractModel)value;
            tail = rest;
        }
        if ((value = this.dereference(value, null, model)) instanceof Context) {
            return ((Context)value).listBindings(rest);
        }
        if (value != null) {
            throw new NotContextException(L.l("{0}: expected intermediate context at `{1}'", (Object)this.getFullPath(name), value));
        }
        throw new NameNotFoundException(this.getFullPath(name));
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        AbstractModel model = this._model;
        for (int i = 0; name != null && i < name.size(); ++i) {
            String first = name.get(i);
            Object value = model.lookup(first);
            if (!(value instanceof AbstractModel)) {
                if ((value = this.dereference(value, null, model)) instanceof Context) {
                    return ((Context)value).listBindings(name.getSuffix(i + 1));
                }
                if (value != null) {
                    throw new NotContextException(L.l("{0}: expected intermediate context at `{1}'", (Object)this.getFullPath(name), value));
                }
                throw new NameNotFoundException(this.getFullPath(name));
            }
            model = (AbstractModel)value;
        }
        return new QBindingEnumeration(this.create(model, this._env), model.list());
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        Object value;
        String rest;
        String tail = name;
        AbstractModel model = this._model;
        while (true) {
            String first = this.parseFirst(tail);
            rest = this.parseRest(tail);
            if (first == null) {
                throw new NamingException(L.l("can't create root subcontext"));
            }
            if (rest == null) {
                model = model.createSubcontext(first);
                return this.create(this.getFullPath(name), model, this._env);
            }
            value = model.lookup(first);
            if (!(value instanceof AbstractModel)) break;
            model = (AbstractModel)value;
            tail = rest;
        }
        if ((value = this.dereference(value, null, model)) instanceof Context) {
            return ((Context)value).createSubcontext(rest);
        }
        if (value != null) {
            throw new NotContextException(L.l("{0}: expected intermediate context at `{1}'", (Object)this.getFullPath(name), value));
        }
        throw new NameNotFoundException(this.getFullPath(name));
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        String first;
        if (name.size() == 0) {
            throw new NamingException(L.l("can't create root subcontext"));
        }
        AbstractModel model = this._model;
        int i = 0;
        while (i + 1 < name.size()) {
            first = name.get(i);
            Object value = model.lookup(first);
            if (!(value instanceof AbstractModel)) {
                if ((value = this.dereference(value, null, model)) instanceof Context) {
                    return ((Context)value).createSubcontext(name.getSuffix(i + 1));
                }
                if (value != null) {
                    throw new NotContextException(L.l("{0}: expected intermediate context at `{1}'", (Object)this.getFullPath(name), value));
                }
                throw new NameNotFoundException(this.getFullPath(name));
            }
            model = (AbstractModel)value;
            ++i;
        }
        first = name.get(i);
        model = model.createSubcontext(first);
        return this.create(this.getFullPath(name), model, this._env);
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        Object value;
        String rest;
        String tail = name;
        AbstractModel model = this._model;
        while (true) {
            String first = this.parseFirst(tail);
            rest = this.parseRest(tail);
            if (first == null) {
                throw new NamingException(L.l("can't destroy root subcontext"));
            }
            if (rest == null) {
                model.unbind(first);
                return;
            }
            value = model.lookup(first);
            if (!(value instanceof AbstractModel)) break;
            model = (AbstractModel)value;
            tail = rest;
        }
        if ((value = this.dereference(value, null, model)) instanceof Context) {
            ((Context)value).destroySubcontext(rest);
            return;
        }
        if (value != null) {
            throw new NotContextException(L.l("{0}: expected intermediate context at `{1}'", (Object)this.getFullPath(name), value));
        }
        throw new NameNotFoundException(this.getFullPath(name));
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        String first;
        if (name.size() == 0) {
            throw new NamingException(L.l("can't destroy root subcontext"));
        }
        AbstractModel model = this._model;
        int i = 0;
        while (i + 1 < name.size()) {
            first = name.get(i);
            Object value = model.lookup(first);
            if (!(value instanceof AbstractModel)) {
                if ((value = this.dereference(value, null, model)) instanceof Context) {
                    ((Context)value).destroySubcontext(name.getSuffix(i + 1));
                    return;
                }
                if (value != null) {
                    throw new NotContextException(L.l("{0}: expected intermediate context at `{1}'", (Object)this.getFullPath(name), value));
                }
                throw new NameNotFoundException(this.getFullPath(name));
            }
            model = (AbstractModel)value;
            ++i;
        }
        first = name.get(i);
        model.unbind(first);
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        String first = this.parseFirst(name);
        String rest = this.parseRest(name);
        if (first == null) {
            return new QNameParser(this);
        }
        Object obj = this.lookupSingleObject(first);
        if (obj instanceof Context) {
            return ((Context)obj).getNameParser(rest == null ? "" : rest);
        }
        return new QNameParser(this);
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        if (name.size() == 0) {
            return new QNameParser(this);
        }
        Object obj = this.lookupSingleObject(name.get(0));
        if (obj instanceof Context) {
            return ((Context)obj).getNameParser(name.getSuffix(1));
        }
        return new QNameParser(this);
    }

    @Override
    public String composeName(String suffix, String prefix) throws NamingException {
        if (suffix == null) {
            throw new NamingException(L.l("suffix cannot be null"));
        }
        if (prefix == null) {
            throw new NamingException(L.l("prefix cannot be null"));
        }
        if (prefix.length() == 0) {
            return suffix;
        }
        return prefix + "/" + suffix;
    }

    @Override
    public Name composeName(Name suffix, Name prefix) throws NamingException {
        if (suffix == null) {
            throw new NamingException(L.l("suffix cannot be null"));
        }
        if (prefix == null) {
            throw new NamingException(L.l("prefix cannot be null"));
        }
        return prefix.addAll(suffix);
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        throw new OperationNotSupportedException();
    }

    private Object lookupSingleObject(String name) throws NamingException {
        Object obj = this.lookupSingle(name);
        if (obj instanceof ObjectProxy) {
            return ((ObjectProxy)obj).createObject(this._env);
        }
        return obj;
    }

    protected Object lookupSingle(String name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    protected void rebindSingle(String name, Object obj) throws NamingException {
        throw new UnsupportedOperationException();
    }

    protected void unbindSingle(String name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    protected Context createSingleSubcontext(String name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    protected void destroySingleSubcontext(String name) throws NamingException {
        this.unbindSingle(name);
    }

    protected Iterator listSingle() {
        throw new UnsupportedOperationException();
    }

    protected String parseFirst(String name) throws NamingException {
        if (name == null || name.equals("")) {
            return null;
        }
        int p = name.indexOf(this.getSeparator());
        if (p == 0) {
            return this.parseFirst(name.substring(1));
        }
        if (p > 0) {
            return name.substring(0, p);
        }
        return name;
    }

    protected String parseRest(String name) throws NamingException {
        if (name == null || name.equals("")) {
            return null;
        }
        int p = name.indexOf(this.getSeparator());
        if (p == 0) {
            return this.parseRest(name.substring(1));
        }
        if (p > 0) {
            return name.substring(p + 1);
        }
        return null;
    }

    protected char getSeparator() {
        return '/';
    }

    protected String getSeparatorString() {
        return "/";
    }

    protected String getFullPath(String name) {
        if (this._name == null || this._name.equals("")) {
            return name;
        }
        if (name == null) {
            return this._name;
        }
        String sep = this.getSeparatorString();
        while (name.endsWith(sep)) {
            name = name.substring(0, name.length() - sep.length());
        }
        if (name.equals("")) {
            return this._name;
        }
        if (name.startsWith(sep)) {
            return this._name + name;
        }
        return this._name + sep + name;
    }

    protected String getFullPath(Name name) {
        if (this._name == null || this._name.equals("")) {
            return name.toString();
        }
        if (name == null || name.size() == 0) {
            return this._name;
        }
        String sep = this.getSeparatorString();
        return this._name + sep + name;
    }

    @Override
    public Object addToEnvironment(String prop, Object value) throws NamingException {
        Object old = this._env.get(prop);
        this._env.put(prop, value);
        return old;
    }

    @Override
    public Object removeFromEnvironment(String prop) throws NamingException {
        Object old = this._env.get(prop);
        this._env.remove(prop);
        return old;
    }

    public Hashtable getEnvironment() throws NamingException {
        return this._env;
    }

    @Override
    public void close() throws NamingException {
    }

    public String toString() {
        return "ContextImpl[" + this._name + "]";
    }

    private static class NullValue {
        static final NullValue NULL = new NullValue();

        private NullValue() {
        }
    }
}

