/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.message.tourmaline;

import com.caucho.message.tourmaline.AbstractNautilusEndpoint;
import com.caucho.message.tourmaline.NautilusClientReceiver;
import com.caucho.message.tourmaline.NautilusCode;
import com.caucho.util.IoUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NautilusClientReceiverEndpoint<T>
extends AbstractNautilusEndpoint {
    private static final Logger log = Logger.getLogger(NautilusClientReceiverEndpoint.class.getName());
    private final NautilusClientReceiver<T> _receiver;

    NautilusClientReceiverEndpoint(NautilusClientReceiver<T> receiver) {
        this._receiver = receiver;
    }

    @Override
    protected void onSend(InputStream is) throws IOException {
        T value = this._receiver.getDecoder().decode(is);
        this._receiver.receiveEntry(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendReceive(String queue) throws IOException {
        OutputStream os = this.getContext().startBinaryMessage();
        try {
            os.write(NautilusCode.RECEIVE.ordinal());
            this.write(os, "name:");
            this.write(os, queue);
            this.write(os, "\n");
            int prefetch = this._receiver.getPrefetch();
            if (prefetch > 0) {
                this._receiver.updateCredit(prefetch);
                this.write(os, "credit:");
                this.write(os, String.valueOf(prefetch));
                this.write(os, "\n");
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            IoUtil.close(os);
            throw throwable;
        }
        IoUtil.close(os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void updateFlow(int credit, long endpointSequence) {
        OutputStream os = null;
        try {
            try {
                os = this.getContext().startBinaryMessage();
                os.write(NautilusCode.FLOW.ordinal());
                this.writeInt(os, credit);
                this.writeLong(os, endpointSequence);
            }
            catch (IOException e) {
                log.log(Level.FINER, e.toString(), e);
                Object var7_5 = null;
                IoUtil.close(os);
                return;
            }
            Object var7_4 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            IoUtil.close(os);
            throw throwable;
        }
        IoUtil.close(os);
    }
}

