/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.message.tourmaline;

import com.caucho.message.MessageDecoder;
import com.caucho.message.common.BasicMessageReceiver;
import com.caucho.message.tourmaline.NautilusClientReceiverEndpoint;
import com.caucho.message.tourmaline.NautilusReceiverFactory;
import com.caucho.remote.websocket.WebSocketClient;
import com.caucho.util.L10N;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NautilusClientReceiver<T>
extends BasicMessageReceiver<T> {
    private static final L10N L = new L10N(NautilusClientReceiver.class);
    private static final Logger log = Logger.getLogger(NautilusClientReceiver.class.getName());
    private final String _queue;
    private final MessageDecoder<T> _decoder;
    private NautilusClientReceiverEndpoint<T> _endpoint;

    NautilusClientReceiver(NautilusReceiverFactory factory) {
        super(factory);
        String address = this.getAddress();
        int q = address.indexOf("?queue=");
        this._queue = address.substring(q + "?queue=".length());
        this._decoder = factory.getMessageDecoder();
        Object nodeProperties = null;
        this.connect();
    }

    MessageDecoder<T> getDecoder() {
        return this._decoder;
    }

    private void connect() {
        try {
            this._endpoint = new NautilusClientReceiverEndpoint(this);
            WebSocketClient client = new WebSocketClient(this.getAddress(), this._endpoint);
            client.connect();
            this._endpoint.sendReceive(this._queue);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void updateFlow(int credit, long endpointSequence) {
        this._endpoint.updateFlow(credit, endpointSequence);
    }
}

