/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.message.stomp;

import com.caucho.message.broker.BrokerSender;
import com.caucho.message.broker.SenderSettleHandler;
import com.caucho.message.stomp.StompCommand;
import com.caucho.message.stomp.StompConnection;
import com.caucho.message.stomp.StompXaSend;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.WriteStream;
import java.io.IOException;

public class StompSendCommand
extends StompCommand {
    boolean doCommand(StompConnection conn, ReadStream is, WriteStream os) throws IOException {
        int ch;
        BrokerSender dest = conn.getDestination();
        long contentLength = conn.getContentLength();
        String contentType = conn.getContentType();
        String xa = conn.getTransaction();
        SenderSettleHandler receipt = conn.createReceiptCallback();
        StompXaSend xaSend = null;
        long mid = 0L;
        if (contentLength >= 0L) {
            int offset = 0;
            while ((long)offset < contentLength) {
                int sublen = (int)(contentLength - (long)offset);
                TempBuffer tBuf = TempBuffer.allocate();
                byte[] buffer = tBuf.getBuffer();
                if (buffer.length < sublen) {
                    sublen = buffer.length;
                }
                if ((sublen = is.readAll(buffer, 0, sublen)) < 0) {
                    throw new IOException("eof protocol");
                }
                if (xa == null) {
                    boolean isFinal = (long)(offset + sublen) == contentLength;
                    boolean isDurable = false;
                    int priority = -1;
                    long expireTime = 0L;
                    dest.message(conn.getXid(), mid, isDurable, priority, expireTime, tBuf.getBuffer(), 0, sublen, tBuf, receipt);
                } else {
                    xaSend = new StompXaSend(dest, tBuf, sublen);
                }
                offset += sublen;
            }
            ch = is.read();
        } else {
            TempBuffer tBuf = TempBuffer.allocate();
            byte[] buffer = tBuf.getBuffer();
            boolean isDurable = false;
            int priority = -1;
            long expireTime = 0L;
            int offset = 0;
            ch = is.read();
            while (ch > 0) {
                buffer[offset++] = (byte)ch;
                if (offset == buffer.length) {
                    dest.message(conn.getXid(), mid, isDurable, priority, expireTime, tBuf.getBuffer(), 0, offset, tBuf, receipt);
                    tBuf = TempBuffer.allocate();
                    offset = 0;
                }
                ch = is.read();
            }
            System.out.println("MSG: " + xa);
            if (xa == null) {
                dest.message(conn.getXid(), mid, isDurable, priority, expireTime, tBuf.getBuffer(), 0, offset, tBuf, receipt);
            } else {
                xaSend = new StompXaSend(dest, tBuf, offset);
            }
        }
        if (ch != 0) {
            throw new IOException("protocol");
        }
        if (xaSend != null) {
            conn.addXaItem(xaSend);
            if (receipt != null) {
                receipt.onAccepted(mid);
            }
        }
        return true;
    }
}

